/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.Outfile;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterFile
extends Outfile {
    private int currentClusterNo = 0;

    public void printPreProcessingClusters(String tccFile) {
        if (tccFile != null && !tccFile.equals("")) {
            if (tccFile.endsWith("1.tcc")) {
                this.printOldTccFormat(tccFile);
            } else {
                try {
                    BufferedReader tccBuffer = new BufferedReader(new FileReader(tccFile));
                    String line = "";
                    String clusterNo = "";
                    Pattern objectLine = Pattern.compile(".+\\t(\\d+)");
                    while ((line = tccBuffer.readLine()) != null) {
                        Matcher objectMatcher = objectLine.matcher(line);
                        if (!objectMatcher.find()) continue;
                        this.println(line);
                        clusterNo = objectMatcher.group(1);
                    }
                    this.currentClusterNo = Integer.parseInt(clusterNo) + 1;
                }
                catch (IOException e) {
                    System.err.println("Unable to read this file:  " + tccFile);
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
        }
        this.flushbw();
    }

    private void printOldTccFormat(String tccFile) {
        try {
            BufferedReader tccBuffer = new BufferedReader(new FileReader(tccFile));
            String line = "";
            int clusterNo = 0;
            Pattern objectLine = Pattern.compile("^\\d+\\t(.+)\\s*");
            String objectString = "";
            while ((line = tccBuffer.readLine()) != null) {
                Matcher objectMatcher = objectLine.matcher(line);
                if (!objectMatcher.find()) continue;
                objectString = objectMatcher.group(1);
                String[] objects = objectString.split("\t");
                for (int i = 0; i < objects.length; ++i) {
                    this.println(objects[i] + "\t" + clusterNo);
                }
                ++clusterNo;
            }
            this.currentClusterNo = clusterNo;
        }
        catch (IOException e) {
            System.err.println("Unable to read this file:  " + tccFile);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public synchronized void printCluster(ArrayList<String> cluster2) {
        StringBuffer clusterbuffer = new StringBuffer();
        for (String objectString : cluster2) {
            String[] separatedObjectString = objectString.split("\t");
            for (int i = 0; i < separatedObjectString.length; ++i) {
                clusterbuffer.append(separatedObjectString[i]);
                clusterbuffer.append("\t");
                clusterbuffer.append(this.currentClusterNo);
                clusterbuffer.append(NL);
            }
        }
        this.print(clusterbuffer.toString());
        ++this.currentClusterNo;
    }

    public int getCurrentClusterNo() {
        return this.currentClusterNo;
    }

    public void setCurrentClusterNo(int currentClusterNo) {
        this.currentClusterNo = currentClusterNo;
    }
}

