/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Numeric;
import org.junit.Assert;
import org.junit.Test;

public class NumericTest {
    private static double epsilon = 0.001;

    @Test
    public void testMean() {
        Double[][] tests = new Double[][]{{2.0, 1.0, 4.0, 3.0}, {1.5, 2.5, 3.6, 1.4, 1.0}, {-3.0, null, 2.0, null, null}};
        double[] ans = new double[]{2.5, 2.0, -0.5};
        for (int i = 0; i < tests.length; ++i) {
            Assert.assertEquals((String)"mean", (double)ans[i], (double)Numeric.mean(tests[i]), (double)epsilon);
        }
    }

    @Test
    public void testMedian() {
        Double[][] tests = new Double[][]{{3.0, 5.0, 1.0, 9.0, 7.0}, {4.0, 3.0, 1.0, 2.0}};
        double[] ans = new double[]{5.0, 2.5};
        for (int i = 0; i < tests.length; ++i) {
            Assert.assertEquals((String)"median", (double)ans[i], (double)Numeric.median(tests[i]), (double)epsilon);
        }
    }

    @Test
    public void testSelect() {
        Double[] test = new Double[]{9.0, 4.0, 3.0, 2.0, 2.0, 6.0, 1.0, 4.0, 4.0, 1.0};
        int[] order = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        double[] ans = new double[]{1.0, 1.0, 2.0, 2.0, 3.0, 4.0, 4.0, 4.0, 6.0, 9.0};
        for (int i = 0; i < order.length; ++i) {
            Assert.assertEquals((String)"select", (double)ans[i], (double)Numeric.select(test, order[i]), (double)epsilon);
        }
    }
}

