/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.commands;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class GetClusterTask
extends AbstractTask
implements ObservableTask {
    ClusterManager clusterManager;
    List<String> clusterParams;
    List<String> orderList = null;
    List<String> clusterList = null;
    String algName;
    String clusterType;
    @Tunable(description="Network to look for cluster in", context="nogui")
    public CyNetwork network;
    @Tunable(description="Cluster algorithm", context="nogui")
    public String algorithm;
    @Tunable(description="Node clusters or Attribute clusters", context="nogui")
    public ListSingleSelection<String> type = new ListSingleSelection(new Object[]{"node", "attribute"});

    public GetClusterTask(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void run(TaskMonitor monitor) {
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        if (this.algorithm == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Algorithm must be specified");
            return;
        }
        ClusterTaskFactory algTF = this.clusterManager.getAlgorithm(this.algorithm);
        if (algTF == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't find algorithm: '" + this.algorithm + "'");
        }
        if (!algTF.getTypeList().contains((Object)ClusterTaskFactory.ClusterType.ATTRIBUTE)) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Algorithm: '" + this.algorithm + "' is not an attribute clusterer");
            return;
        }
        if (!algTF.isAvailable(this.network)) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No data for algorithm: '" + this.algorithm + "' in this network");
            return;
        }
        this.algName = algTF.getShortName();
        if (ModelUtils.hasAttribute(this.network, (CyIdentifiable)this.network, "__clusterType")) {
            this.clusterType = (String)this.network.getRow((CyIdentifiable)this.network).get("__clusterType", String.class);
        }
        if (ModelUtils.hasAttribute(this.network, (CyIdentifiable)this.network, "__clusterParams")) {
            this.clusterParams = this.network.getRow((CyIdentifiable)this.network).getList("__clusterParams", String.class);
        }
        if (((String)this.type.getSelectedValue()).equals("node")) {
            this.getEisenClusters("__nodeOrder", "__nodeClusters");
        } else {
            this.getEisenClusters("__arrayOrder", "__attrClusters");
        }
    }

    private void getEisenClusters(String orderAttribute, String clusterAttribute) {
        this.orderList = this.network.getRow((CyIdentifiable)this.network).getList(orderAttribute, String.class);
        this.clusterList = this.network.getRow((CyIdentifiable)this.network).getList(clusterAttribute, String.class);
    }

    public Object getResults(Class clzz) {
        if (this.orderList == null || this.clusterList == null) {
            return null;
        }
        if (clzz.equals(List.class)) {
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            result.add(this.orderList);
            result.add(this.clusterList);
            return result;
        }
        if (clzz.equals(Map.class)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("algorithm", this.algName);
            result.put("type", this.type.getSelectedValue());
            result.put("order", this.orderList);
            result.put("cluster", this.clusterList);
            return result;
        }
        String typeString = ((String)this.type.getSelectedValue()).equals("node") ? "Node (gene) " : "Attribute (array) ";
        String result = typeString + "cluster results for " + this.algName + ": \n";
        for (String cluster2 : this.clusterList) {
            result = result + "   " + cluster2 + "\n";
        }
        result = result + typeString + "cluster order for " + this.algName + ": \n";
        for (String node : this.orderList) {
            result = result + "   " + node + "\n";
        }
        return result;
    }
}

