/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.commands;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNetworkClusterTask
extends AbstractTask
implements ObservableTask {
    ClusterManager clusterManager;
    Map<Integer, List<CyNode>> clusterMap;
    String algName;
    @Tunable(description="Network to look for cluster in", context="nogui")
    public CyNetwork network;
    @Tunable(description="Cluster algorithm", context="nogui")
    public String algorithm;

    public GetNetworkClusterTask(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void run(TaskMonitor monitor) {
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        if (this.algorithm == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Algorithm must be specified");
            return;
        }
        ClusterTaskFactory algTF = this.clusterManager.getAlgorithm(this.algorithm);
        if (algTF == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't find algorithm: '" + this.algorithm + "'");
        }
        if (!algTF.getTypeList().contains((Object)ClusterTaskFactory.ClusterType.NETWORK) && !algTF.getTypeList().contains((Object)ClusterTaskFactory.ClusterType.FILTER)) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Algorithm: '" + this.algorithm + "' is not a network clusterer");
            return;
        }
        if (!algTF.isAvailable(this.network)) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No data for algorithm: '" + this.algorithm + "' in this network");
            return;
        }
        this.algName = algTF.getShortName();
        String clusterAttribute = (String)this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").get("__clusterAttribute", String.class);
        boolean isFuzzy = this.network.getTable(CyNode.class, "LOCAL_ATTRS").getColumn(clusterAttribute).getType().equals(List.class);
        this.clusterMap = new HashMap<Integer, List<CyNode>>();
        for (CyNode node : this.network.getNodeList()) {
            if (!ModelUtils.hasAttribute(this.network, (CyIdentifiable)node, clusterAttribute)) continue;
            if (isFuzzy) {
                List clusterList = this.network.getRow((CyIdentifiable)node).getList(clusterAttribute, Integer.class);
                for (Integer cluster2 : clusterList) {
                    this.addNodeToMap(this.clusterMap, cluster2, node);
                }
                continue;
            }
            Integer cluster3 = (Integer)this.network.getRow((CyIdentifiable)node).get(clusterAttribute, Integer.class);
            this.addNodeToMap(this.clusterMap, cluster3, node);
        }
    }

    private void addNodeToMap(Map<Integer, List<CyNode>> map, Integer cluster2, CyNode node) {
        if (!map.containsKey(cluster2)) {
            map.put(cluster2, new ArrayList());
        }
        map.get(cluster2).add(node);
    }

    public Object getResults(Class clzz) {
        if (this.clusterMap == null) {
            return null;
        }
        if (clzz.equals(Map.class)) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("type", this.algName);
            resultMap.put("networkclusters", this.clusterMap.values());
            return resultMap;
        }
        String resultString = "Network clusters: \n";
        for (Integer clusterNumber : this.clusterMap.keySet()) {
            List<CyNode> nodeList = this.clusterMap.get(clusterNumber);
            String out = "   " + clusterNumber + ": [";
            for (CyNode node : nodeList) {
                out = out + node.getSUID() + ",";
            }
            resultString = resultString + out.substring(0, out.length() - 1) + "]\n";
        }
        return resultString;
    }
}

