/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.commands;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class HasClusterTask
extends AbstractTask
implements ObservableTask {
    ClusterManager clusterManager;
    Boolean hasCluster = false;
    @Tunable(description="Network to look for cluster in", context="nogui")
    public CyNetwork network;
    @Tunable(description="Algorithm", context="nogui")
    public String algorithm;

    public HasClusterTask(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void run(TaskMonitor monitor) {
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        this.hasCluster = false;
        if (this.algorithm != null) {
            ClusterTaskFactory algTF = this.clusterManager.getAlgorithm(this.algorithm);
            if (algTF != null) {
                if (algTF.isAvailable(this.network)) {
                    this.hasCluster = true;
                } else {
                    monitor.showMessage(TaskMonitor.Level.ERROR, "This network doesn't have a '" + this.algorithm + "' cluster");
                }
            } else {
                monitor.showMessage(TaskMonitor.Level.ERROR, "Can't find algorithm: '" + this.algorithm + "'");
            }
        } else {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Algorithm must be specified");
        }
    }

    public Object getResults(Class type) {
        if (type.equals(Boolean.class)) {
            return (boolean)this.hasCluster;
        }
        return Boolean.toString(this.hasCluster);
    }
}

