/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MainPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LinkedPanel
extends JTabbedPane
implements MainPanel {
    ViewFrame viewFrame;
    ConfigNode configNode = null;
    Vector mpdialogs = new Vector();

    public LinkedPanel(ViewFrame viewFrame) {
        this.setName("LinkedPanel");
        this.setViewFrame(viewFrame);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ConfigNode viewsNode = LinkedPanel.this.getConfigNode();
                if (viewsNode != null) {
                    viewsNode.setAttribute("selected", LinkedPanel.this.getSelectedIndex(), 0);
                }
            }
        });
    }

    public void setViewFrame(ViewFrame viewFrame) {
        this.viewFrame = viewFrame;
    }

    public ViewFrame getViewFrame() {
        return this.viewFrame;
    }

    public void syncConfig() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MainPanel modelView = (MainPanel)((Object)this.getComponentAt(i));
            modelView.syncConfig();
        }
    }

    public void setConfigNode(ConfigNode configNode) {
        this.configNode = configNode;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public void populateSettingsMenu(JMenu menu) {
    }

    public void populateAnalysisMenu(JMenu menu) {
    }

    public void populateExportMenu(JMenu menu) {
    }

    public void scrollToGene(int index) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MainPanel modelView = (MainPanel)((Object)this.getComponentAt(i));
            modelView.scrollToGene(index);
        }
    }

    public void scrollToArray(int index) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MainPanel modelView = (MainPanel)((Object)this.getComponentAt(i));
            modelView.scrollToArray(index);
        }
    }

    public void addTab(MainPanel mp) {
        this.addTab(mp.getName(), mp.getIcon(), (Component)((Object)mp), "What's this button do?");
        mp.getConfigNode().setAttribute("dock", 1, -1);
    }

    public void addDialog(MainPanel mp) {
        MainPanelFrame nmp = new MainPanelFrame(mp);
        this.mpdialogs.add(nmp);
        Rectangle r = this.viewFrame.getBounds();
        r.height -= 10;
        r.width -= 10;
        r.x += 10;
        r.y += 10;
        nmp.setBounds(r);
        nmp.setVisible(true);
        mp.getConfigNode().setAttribute("dock", 0, -1);
    }

    public void removeDialog(MainPanel mp) {
        Enumeration e = this.mpdialogs.elements();
        while (e.hasMoreElements()) {
            MainPanelFrame mpd = (MainPanelFrame)e.nextElement();
            if (mpd.getMainPanel() != mp) continue;
            this.removeDialog(mpd);
        }
    }

    public void removeDialog(MainPanelFrame mpd) {
        this.mpdialogs.remove(mpd);
        ConfigNode viewsNode = this.getConfigNode();
        viewsNode.remove(mpd.getMainPanel().getConfigNode());
        mpd.dispose();
    }

    public void dockMainPanelDialog(MainPanelFrame mpd) {
        MainPanel mp = mpd.getMainPanel();
        this.mpdialogs.remove(mpd);
        mpd.setVisible(false);
        this.addTab(mp);
        mpd.dispose();
        mp.getConfigNode().setAttribute("dock", 1, -1);
    }

    public void detachCurrent() {
        Component current = this.getSelectedComponent();
        if (current != null) {
            MainPanel mp = (MainPanel)((Object)current);
            this.remove(current);
            this.addDialog(mp);
            mp.getConfigNode().setAttribute("dock", 0, -1);
        }
    }

    public void removeCurrent() {
        Component current = this.getSelectedComponent();
        if (current != null) {
            MainPanel cPanel = (MainPanel)((Object)current);
            cPanel.syncConfig();
            ConfigNode viewsNode = this.getConfigNode();
            viewsNode.remove(cPanel.getConfigNode());
            this.remove(current);
        }
    }

    public ImageIcon getIcon() {
        return null;
    }

    public MainPanel[] getMainPanelsByName(String name) {
        Vector<MainPanel> matches = new Vector<MainPanel>();
        Enumeration e = this.mpdialogs.elements();
        while (e.hasMoreElements()) {
            MainPanelFrame mpd = (MainPanelFrame)e.nextElement();
            MainPanel mp = mpd.getMainPanel();
            if (!name.equals(mp.getName())) continue;
            matches.add(mp);
        }
        Component[] docked = this.getComponents();
        for (int i = 0; i < docked.length; ++i) {
            MainPanel mp = (MainPanel)((Object)docked[i]);
            if (!name.equals(mp.getName())) continue;
            matches.add(mp);
        }
        Object[] comps = matches.toArray();
        MainPanel[] ret = new MainPanel[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            ret[i] = (MainPanel)comps[i];
        }
        return ret;
    }

    public MainPanel[] getMainPanels() {
        Vector<MainPanel> matches = new Vector<MainPanel>();
        Enumeration e = this.mpdialogs.elements();
        while (e.hasMoreElements()) {
            MainPanelFrame mpd = (MainPanelFrame)e.nextElement();
            MainPanel mp = mpd.getMainPanel();
            matches.add(mp);
        }
        Component[] docked = this.getComponents();
        for (int i = 0; i < docked.length; ++i) {
            MainPanel mp = (MainPanel)((Object)docked[i]);
            matches.add(mp);
        }
        Object[] comps = matches.toArray();
        MainPanel[] ret = new MainPanel[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            ret[i] = (MainPanel)comps[i];
        }
        return ret;
    }

    private class MainPanelFrame
    extends JFrame {
        MainPanel mainPanel;

        public MainPanelFrame(MainPanel mp) {
            this.mainPanel = mp;
            final WindowAdapter listener = new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    LinkedPanel.this.removeDialog(MainPanelFrame.this);
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }
            };
            this.addWindowListener(listener);
            JButton dockButton = new JButton("Dock");
            dockButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainPanelFrame.this.removeWindowListener(listener);
                    LinkedPanel.this.dockMainPanelDialog(MainPanelFrame.this);
                }
            });
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainPanelFrame.this.removeWindowListener(listener);
                    LinkedPanel.this.removeDialog(MainPanelFrame.this);
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(dockButton);
            buttonPanel.add(closeButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)buttonPanel, "South");
            this.getContentPane().add((Component)((Object)this.mainPanel), "Center");
            this.setTitle(mp.getName() + ": " + LinkedPanel.this.viewFrame.getDataModel().getSource());
        }

        public MainPanel getMainPanel() {
            return this.mainPanel;
        }
    }
}

