/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MessagePanel
extends JScrollPane {
    protected MessageCanvas messagecanvas;
    protected Vector messages;
    private String title;

    public MessagePanel() {
        this((String)null);
    }

    public MessagePanel(String t) {
        this.title = t;
        this.messages = new Vector(5, 5);
        this.messagecanvas = new MessageCanvas();
        this.messagecanvas.setBackground(Color.white);
        this.messagecanvas.setForeground(Color.black);
        this.setViewportView(this.messagecanvas);
    }

    public void setMessages(String[] m) {
        this.resetMessages();
        for (int i = 0; i < m.length; ++i) {
            this.addMessage(m[i]);
        }
        this.layoutMessages();
    }

    public void resetMessages() {
        this.messages.removeAllElements();
    }

    public void addMessage(String message) {
        this.messages.addElement(message);
    }

    public void layoutMessages() {
        this.revalidate();
        this.repaint();
    }

    private JLabel getTitleLabel() {
        return new JLabel(this.title);
    }

    class MessageCanvas
    extends JPanel {
        MessageCanvas() {
        }

        public void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int xoff = 0;
            boolean yoff = false;
            FontMetrics metrics = this.getFontMetrics(g.getFont());
            int ascent = metrics.getAscent();
            int height = 0;
            Enumeration e = MessagePanel.this.messages.elements();
            Dimension size = this.getSize();
            g.clearRect(0, 0, size.width, size.height);
            g.drawString(MessagePanel.this.title, -xoff, height += ascent);
            while (e.hasMoreElements()) {
                String message = (String)e.nextElement();
                if (message == null) continue;
                g.drawString(message, -xoff, height += ascent);
            }
        }

        public Dimension getPreferredSize() {
            int ascent;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int height = ascent = metrics.getAscent();
            int width = metrics.stringWidth(MessagePanel.this.title);
            Enumeration e = MessagePanel.this.messages.elements();
            while (e.hasMoreElements()) {
                String message = (String)e.nextElement();
                if (message == null) continue;
                height += ascent;
                int length = metrics.stringWidth(message);
                if (width >= length) continue;
                width = length;
            }
            return new Dimension(width, height);
        }
    }
}

