/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MessagePanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class ModelView
extends JPanel
implements Observer,
MouseListener {
    protected ViewFrame viewFrame = null;
    protected MessagePanel hint = null;
    protected MessagePanel status = null;
    protected boolean hasMouse = false;
    protected boolean offscreenValid = false;
    protected boolean offscreenChanged = false;
    protected Dimension offscreenSize = null;
    protected JComponent panel;
    private String[] default_hint = null;
    private String[] default_status = null;

    protected ModelView() {
        super(false);
        this.setBackground(Color.white);
    }

    public abstract String viewName();

    public void setViewFrame(ViewFrame m) {
        this.viewFrame = m;
    }

    public ViewFrame getViewFrame() {
        return this.viewFrame;
    }

    public void setHintPanel(MessagePanel h) {
        this.hint = h;
    }

    public void setStatusPanel(MessagePanel s) {
        this.status = s;
    }

    public String[] getHints() {
        if (this.default_hint == null) {
            this.default_hint = new String[]{"No hints for " + this.viewName()};
        }
        return this.default_hint;
    }

    public String[] getStatus() {
        if (this.default_status == null) {
            this.default_status = new String[]{"No status info for " + this.viewName()};
        }
        return this.default_status;
    }

    public JComponent getComponent() {
        return this.panel;
    }

    protected abstract void updateBuffer(Graphics var1);

    public synchronized void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        g.setColor(Color.white);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        Dimension reqSize = this.getSize();
        if (reqSize == null) {
            return;
        }
        if (this.offscreenSize == null || reqSize.width != this.offscreenSize.width || reqSize.height != this.offscreenSize.height) {
            this.offscreenChanged = true;
            this.offscreenSize = reqSize;
        }
        if (this.isEnabled()) {
            this.offscreenValid = false;
            this.updateBuffer(g);
            this.paintComposite(g);
        }
    }

    public void paintComposite(Graphics g) {
    }

    public void addNotify() {
        super.addNotify();
    }

    public Window enclosingWindow() {
        Container f = this.getParent();
        while (!(f instanceof Window)) {
            f = ((Component)f).getParent();
        }
        return (Window)f;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.viewFrame == null) {
            return;
        }
        Window frame = this.enclosingWindow();
        if (frame.isActive()) {
            this.requestFocus();
            if (this.hint != null) {
                this.hint.setMessages(this.getHints());
            }
            try {
                if (this.status != null) {
                    this.status.setMessages(this.getStatus());
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.toString());
            }
        }
        this.hasMouse = true;
    }

    public void mouseExited(MouseEvent e) {
        this.hasMouse = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

