/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;

public abstract class ModelViewProduced
extends ModelView {
    protected int[] offscreenPixels = null;
    protected MemoryImageSource offscreenSource = null;
    protected Image offscreenBuffer = null;
    protected Graphics offscreenGraphics = null;
    protected int offscreenScanSize = 0;
    protected boolean rotateOffscreen = false;

    protected ModelViewProduced() {
    }

    protected void ensureCapacity(Dimension req) {
        if (this.offscreenBuffer == null) {
            this.createNewBuffer(req.width, req.height);
        } else {
            int w = this.offscreenBuffer.getWidth(null);
            int h = this.offscreenBuffer.getHeight(null);
            if (w < req.width || h < req.height) {
                if (w < req.width) {
                    w = req.width;
                }
                if (h < req.height) {
                    h = req.height;
                }
                this.createNewBuffer(w, h);
            }
        }
    }

    private synchronized void createNewBuffer(int w, int h) {
        this.offscreenPixels = new int[w * h];
        this.offscreenScanSize = w;
        this.offscreenSource = new MemoryImageSource(w, h, this.offscreenPixels, 0, w);
        this.offscreenSource.setAnimated(true);
        this.offscreenBuffer = this.createImage(this.offscreenSource);
    }

    public synchronized void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Dimension newsize = this.getSize();
        if (newsize == null) {
            return;
        }
        Dimension reqSize = newsize;
        if (this.offscreenBuffer == null || reqSize.width != this.offscreenSize.width || reqSize.height != this.offscreenSize.height) {
            this.offscreenSize = reqSize;
            this.ensureCapacity(this.offscreenSize);
            this.offscreenChanged = true;
            this.offscreenValid = false;
        } else {
            this.offscreenChanged = false;
        }
        int backgoundInt = -1;
        for (int i = 0; i < this.offscreenPixels.length; ++i) {
            this.offscreenPixels[i] = backgoundInt;
        }
        if (this.isEnabled() && this.offscreenSize.width > 0 && this.offscreenSize.height > 0) {
            this.updatePixels();
            this.offscreenValid = true;
        }
        g.drawImage(this.offscreenBuffer, 0, 0, null);
        this.paintComposite(g);
    }

    protected abstract void updatePixels();
}

