/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import java.util.Observable;

public class TreeSelection
extends Observable
implements TreeSelectionI {
    private IntegerSelection integerSelection;
    private String selectedNode;

    public TreeSelection(int nIndex) {
        this.integerSelection = new IntegerSelection(nIndex);
    }

    public void resize(int nIndex) {
        IntegerSelection temp = new IntegerSelection(nIndex);
        for (int i = 0; i < nIndex; ++i) {
            if (i < this.integerSelection.getNSelectable()) {
                temp.set(i, this.integerSelection.isSelected(i));
                continue;
            }
            temp.set(i, false);
        }
        this.integerSelection = temp;
        this.setChanged();
    }

    public void deselectAllIndexes() {
        this.integerSelection.deselectAll();
    }

    public void selectAllIndexes() {
        this.integerSelection.selectAll();
    }

    public void setIndex(int i, boolean b) {
        this.integerSelection.set(i, b);
    }

    public boolean isIndexSelected(int i) {
        return this.integerSelection.isSelected(i);
    }

    public int getMinIndex() {
        return this.integerSelection.getMin();
    }

    public int[] getSelectedIndexes() {
        return this.integerSelection.getSelectedIndexes();
    }

    public int getMaxIndex() {
        return this.integerSelection.getMax();
    }

    public int getNumIndexes() {
        return this.integerSelection.getNSelectable();
    }

    public void selectIndexRange(int min, int max) {
        if (min > max) {
            int swap = min;
            min = max;
            max = swap;
        }
        for (int i = min; i <= max; ++i) {
            this.integerSelection.set(i, true);
        }
    }

    public int getNSelectedIndexes() {
        return this.integerSelection.getNSelected();
    }

    public void setSelectedNode(String n) {
        if (this.selectedNode != n) {
            this.selectedNode = n;
            this.setChanged();
        }
    }

    public String getSelectedNode() {
        return this.selectedNode;
    }

    class IntegerSelection {
        boolean[] isSelected;

        IntegerSelection(int size) {
            this.isSelected = new boolean[size];
            this.deselectAll();
        }

        public int getNSelectable() {
            return this.isSelected.length;
        }

        public int getNSelected() {
            int n = 0;
            for (int i = 0; i < this.isSelected.length; ++i) {
                if (!this.isSelected[i]) continue;
                ++n;
            }
            return n;
        }

        public int[] getSelectedIndexes() {
            int nSelected = this.getNSelected();
            int[] indexes = new int[nSelected];
            int curr = 0;
            for (int i = 0; i < this.isSelected.length; ++i) {
                if (!this.isSelected[i]) continue;
                indexes[curr++] = i;
            }
            return indexes;
        }

        public void deselectAll() {
            TreeSelection.this.setChanged();
            for (int i = 0; i < this.isSelected.length; ++i) {
                this.isSelected[i] = false;
            }
        }

        public void selectAll() {
            TreeSelection.this.setChanged();
            for (int i = 0; i < this.isSelected.length; ++i) {
                this.isSelected[i] = true;
            }
        }

        public void set(int i, boolean b) {
            if (i >= 0 && i < this.isSelected.length) {
                TreeSelection.this.setChanged();
                this.isSelected[i] = b;
            }
        }

        public boolean isSelected(int i) {
            return this.isSelected[i];
        }

        public int getMin() {
            int min = -1;
            for (int i = 0; i < this.isSelected.length; ++i) {
                if (!this.isSelected[i]) continue;
                return i;
            }
            return min;
        }

        public int getMax() {
            int max = -1;
            for (int i = 0; i < this.isSelected.length; ++i) {
                if (!this.isSelected[i]) continue;
                max = i;
            }
            return max;
        }
    }
}

