/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinkedPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MainPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelection;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewApp;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DendroView;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class TreeViewFrame
extends ViewFrame {
    private static String appName = "TreeView Classic";
    TreeViewApp treeView;
    private boolean loaded;
    protected MainPanel running;
    protected DataModel dataModel;

    public String getAppName() {
        return appName;
    }

    public TreeViewFrame(TreeViewApp treeview) {
        this(treeview, appName);
    }

    public TreeViewFrame(TreeViewApp treeview, String appName) {
        super(appName);
        TreeViewFrame.appName = appName;
        this.treeView = treeview;
        this.loaded = false;
        this.setWindowActive(true);
        this.setupPresets();
        this.centerOnscreen();
        this.setLoaded(false);
    }

    protected void setupPresets() {
    }

    public void closeWindow() {
        if (this.running != null) {
            this.running.syncConfig();
        }
        super.closeWindow();
    }

    public void scrollToGene(int i) {
        this.running.scrollToGene(i);
    }

    public void scrollToArray(int i) {
        this.running.scrollToArray(i);
    }

    protected void setupExtractors() {
        ConfigNode documentConfig = this.getDataModel().getDocumentConfig();
        DataMatrix matrix = this.getDataModel().getDataMatrix();
        int ngene = matrix.getNumRow();
        int nexpr = matrix.getNumCol();
        this.geneSelection = new TreeSelection(ngene);
        this.arraySelection = new TreeSelection(nexpr);
    }

    protected void setupRunning() {
        DendroView dv = new DendroView(this.getDataModel(), this);
        this.running = dv;
    }

    public void update(Observable observable, Object object) {
    }

    public void setLoaded(boolean flag) {
        this.loaded = flag;
        this.getContentPane().removeAll();
        if (this.loaded) {
            if (this.running == null) {
                JOptionPane.showMessageDialog(this, "TreeViewFrame 253: No data to display");
            } else {
                this.getContentPane().add((JComponent)((Object)this.running));
                this.setTitle(this.getAppName() + " : " + this.dataModel.getSource());
                this.treeView.getGlobalConfig().store();
            }
        } else {
            this.setTitle(this.getAppName());
        }
        this.validate();
        this.repaint();
    }

    public boolean getLoaded() {
        return this.loaded;
    }

    public boolean warnSelectionEmpty() {
        TreeSelectionI treeSelection = this.getGeneSelection();
        if (treeSelection == null || treeSelection.getNSelectedIndexes() <= 0) {
            JOptionPane.showMessageDialog(this, "Cannot generate gene list, no gene selected");
            return false;
        }
        return true;
    }

    public TreeViewApp getApp() {
        return this.treeView;
    }

    public double noData() {
        return -1.0E7;
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.setupExtractors();
        this.setupRunning();
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public MainPanel[] getMainPanelsByName(String name) {
        if (this.running != null) {
            if (name.equals(this.running.getName())) {
                MainPanel[] list = new MainPanel[]{this.running};
                return list;
            }
            try {
                LinkedPanel linked = (LinkedPanel)this.running;
                return linked.getMainPanelsByName(name);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        MainPanel[] list = new MainPanel[]{};
        return list;
    }

    public MainPanel[] getMainPanels() {
        if (this.running == null) {
            MainPanel[] list = new MainPanel[]{};
            return list;
        }
        try {
            LinkedPanel linked = (LinkedPanel)this.running;
            return linked.getMainPanels();
        }
        catch (ClassCastException e) {
            MainPanel[] list = new MainPanel[]{this.running};
            return list;
        }
    }
}

