/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.MainPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewApp;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.ReorderedDataModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class ViewFrame
extends JFrame
implements Observer {
    private boolean windowActive;
    TreeSelectionI geneSelection = null;
    TreeSelectionI arraySelection = null;

    public abstract void update(Observable var1, Object var2);

    public abstract MainPanel[] getMainPanelsByName(String var1);

    public abstract MainPanel[] getMainPanels();

    private void center(Rectangle rectangle) {
        Dimension dimension = this.getSize();
        this.setLocation((rectangle.width - dimension.width) / 3 + rectangle.x, (rectangle.height - dimension.height) / 3 + rectangle.y);
    }

    public void centerOnscreen() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Rectangle rectangle = new Rectangle(dimension);
        int width = rectangle.width * 3 / 4;
        int height = rectangle.height * 4 / 5;
        if (width > 800) {
            width = 800;
        }
        if (height > 600) {
            height = 600;
        }
        this.setSize(width, height);
        this.center(rectangle);
    }

    private void setupWindowListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                ViewFrame.this.setWindowActive(true);
            }

            public void windowClosing(WindowEvent windowEvent) {
                ViewFrame.this.closeWindow();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                ViewFrame.this.setWindowActive(false);
            }
        });
    }

    public ViewFrame(String title) {
        super(title);
        this.setupWindowListener();
    }

    public ViewFrame() {
        this.setupWindowListener();
    }

    protected void setWindowActive(boolean flag) {
        this.windowActive = flag;
    }

    public boolean windowActive() {
        return this.windowActive;
    }

    public void closeWindow() {
        this.dispose();
    }

    public TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    protected void setGeneSelection(TreeSelectionI newSelection) {
        this.geneSelection = newSelection;
    }

    public TreeSelectionI getArraySelection() {
        return this.arraySelection;
    }

    protected void setArraySelection(TreeSelectionI newSelection) {
        this.arraySelection = newSelection;
    }

    public abstract void setLoaded(boolean var1);

    public abstract double noData();

    public abstract boolean getLoaded();

    public abstract DataModel getDataModel();

    public abstract void setDataModel(DataModel var1);

    public abstract void scrollToGene(int var1);

    public abstract void scrollToArray(int var1);

    public void deselectAll() {
        this.geneSelection.deselectAllIndexes();
        this.arraySelection.deselectAllIndexes();
    }

    public void seekGene(int i) {
        this.geneSelection.deselectAllIndexes();
        this.geneSelection.setIndex(i, true);
        this.geneSelection.notifyObservers();
        this.scrollToGene(i);
    }

    public void seekArray(int i) {
        this.arraySelection.deselectAllIndexes();
        this.arraySelection.setIndex(i, true);
        this.arraySelection.notifyObservers();
        this.scrollToArray(i);
    }

    public void extendRange(int i) {
        if (this.geneSelection.getMinIndex() == -1) {
            this.seekGene(i);
        }
        this.geneSelection.setIndex(i, true);
        this.geneSelection.notifyObservers();
        this.scrollToGene(i);
    }

    public boolean geneIsSelected(int i) {
        return this.getGeneSelection().isIndexSelected(i);
    }

    public abstract TreeViewApp getApp();

    protected int getKey(int i) {
        switch (i) {
            case 0: {
                return 48;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
        }
        return 0;
    }

    public void showSubDataModel(int[] indexes, String source, String name) {
        if (indexes.length == 0) {
            JOptionPane.showMessageDialog(this, "No Genes to show summary of!");
            return;
        }
        ReorderedDataModel dataModel = new ReorderedDataModel(this.getDataModel(), indexes);
        if (source != null) {
            dataModel.setSource(source);
        }
        if (name != null) {
            dataModel.setName(name);
        }
        ViewFrame window = this.getApp().openNew();
        window.setDataModel(dataModel);
        window.setLoaded(true);
        window.setVisible(true);
    }
}

