/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public abstract class ArrayDrawer
extends Observable
implements Observer {
    private ConfigNode root;

    public abstract Color getColor(int var1, int var2);

    protected abstract void setDefaults();

    public abstract boolean isMissing(int var1, int var2);

    public abstract boolean isEmpty(int var1, int var2);

    public abstract String getSummary(int var1, int var2);

    public abstract int getNumRow();

    public abstract int getNumCol();

    public abstract void paint(int[] var1, Rectangle var2, Rectangle var3, int var4, int[] var5);

    public ArrayDrawer() {
        this.setDefaults();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public void paint(Graphics g, Rectangle source, Rectangle dest, int[] geneOrder) {
        int ynext = dest.y;
        for (int j = 0; j < source.height; ++j) {
            int ystart = ynext;
            ynext = dest.y + (dest.height + j * dest.height) / source.height;
            int xnext = dest.x;
            for (int i = 0; i < source.width; ++i) {
                int xstart = xnext;
                xnext = dest.x + (dest.width + i * dest.width) / source.width;
                int width = xnext - xstart;
                int height = ynext - ystart;
                if (width <= 0 || height <= 0) continue;
                try {
                    int actualGene = source.y + j;
                    if (geneOrder != null) {
                        actualGene = geneOrder[actualGene];
                    }
                    Color t_color = this.getColor(i + source.x, actualGene);
                    g.setColor(t_color);
                    g.fillRect(xstart, ystart, width, height);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
        }
    }

    public void paint(int[] pixels, Rectangle source, Rectangle dest, int scanSize) {
        this.paint(pixels, source, dest, scanSize, null);
    }

    public void paintPixel(Graphics g, MapContainer xmap, MapContainer ymap, int x, int y, int[] geneOrder) {
        try {
            int actualGene = ymap.getIndex(y);
            if (geneOrder != null) {
                actualGene = geneOrder[actualGene];
            }
            Color t_color = this.getColor(xmap.getIndex(x), actualGene);
            g.setColor(t_color);
            g.fillRect(x, y, 1, 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers();
    }

    public ConfigNode getRoot() {
        return this.root;
    }

    public void setRoot(ConfigNode root) {
        this.root = root;
    }
}

