/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TreeColorer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import javax.swing.JScrollPane;

public class ArrayNameView
extends ModelView
implements MouseListener,
ConfigNodePersistent {
    private final String d_face = "Lucida Sans Regular";
    private final int d_style = 0;
    private final int d_size = 12;
    protected HeaderInfo headerInfo = null;
    protected DataModel dataModel = null;
    private ConfigNode root = null;
    private String face;
    private int style;
    private int size;
    private MapContainer map;
    private int fontsize = 10;
    private int maxlength = 0;
    private boolean dragging = false;
    private boolean backBufferValid = false;
    private Image backBuffer;
    private JScrollPane scrollPane;
    private int oldHeight = 0;
    private HeaderSummary headerSummary;
    private TreeSelectionI arraySelection;

    public HeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setHeaderInfo(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
    }

    public void setDataModel(DataModel dataModel) {
        if (dataModel != null) {
            ((Observable)((Object)dataModel)).deleteObserver(this);
        }
        this.dataModel = dataModel;
        ((Observable)((Object)dataModel)).addObserver(this);
    }

    public String viewName() {
        return "ArrayNameView";
    }

    public String[] getHints() {
        String[] hints = new String[]{"Click and drag to scroll"};
        return hints;
    }

    public ArrayNameView(HeaderInfo hInfo) {
        this.headerInfo = hInfo;
        this.headerSummary = new HeaderSummary();
        this.headerSummary.setIncluded(new int[]{0});
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setBorder(null);
        this.panel = this.scrollPane;
        this.addMouseListener(this);
    }

    public void updateBuffer(Graphics g) {
        Rectangle rect = new Rectangle(0, 0, this.offscreenSize.width, this.offscreenSize.height);
        this.updateBuffer(g, rect);
    }

    public void updateBuffer(Image buf) {
        Rectangle rect = new Rectangle(0, 0, buf.getWidth(null), buf.getHeight(null));
        this.updateBuffer(buf.getGraphics(), rect);
    }

    public void updateBuffer(Graphics g, Rectangle offscreenRect) {
        int j;
        Color back;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.white);
        g2d.fillRect(offscreenRect.x, offscreenRect.y, offscreenRect.width, offscreenRect.height);
        g2d.setColor(Color.black);
        int start = this.map.getIndex(0);
        int end = this.map.getIndex(this.map.getUsedPixels()) - 1;
        int gidRow = this.headerInfo.getIndex("GID");
        if (gidRow == -1) {
            gidRow = 0;
        }
        int colorIndex = this.headerInfo.getIndex("FGCOLOR");
        g2d.setFont(new Font(this.face, this.style, this.size));
        FontMetrics metrics = this.getFontMetrics(g.getFont());
        int ascent = metrics.getAscent();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int bgColorIndex = this.headerInfo.getIndex("BGCOLOR");
        if (bgColorIndex > 0) {
            back = g.getColor();
            for (j = start; j <= end; ++j) {
                String[] strings = this.headerInfo.getHeader(j);
                try {
                    g2d.setColor(TreeColorer.getColor(strings[bgColorIndex]));
                }
                catch (Exception e) {
                    // empty catch block
                }
                g2d.fillRect(offscreenRect.x, offscreenRect.y + this.map.getMiddlePixel(j) - ascent / 2, offscreenRect.width, ascent);
            }
            g2d.setColor(back);
        }
        back = g2d.getColor();
        for (j = start; j <= end; ++j) {
            try {
                String out = this.headerSummary.getSummary(this.headerInfo, j);
                String[] headers = this.headerInfo.getHeader(j);
                if (out == null) continue;
                if (this.arraySelection == null || this.arraySelection.isIndexSelected(j)) {
                    if (colorIndex > 0) {
                        g2d.setColor(TreeColorer.getColor(headers[colorIndex]));
                    }
                    this.printRotatedString(g2d, out, offscreenRect.x, offscreenRect.y + offscreenRect.height, this.map.getMiddlePixel(j) + ascent / 2);
                    if (colorIndex <= 0) continue;
                    g.setColor(back);
                    continue;
                }
                g2d.setColor(Color.gray);
                this.printRotatedString(g2d, out, offscreenRect.x, offscreenRect.y + offscreenRect.height, this.map.getMiddlePixel(j) + ascent / 2);
                g2d.setColor(back);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }

    private void printRotatedString(Graphics2D g2d, String str, int x, int y, int offset) {
        g2d.translate(x, y);
        g2d.rotate(-1.570795);
        g2d.drawString(str, 0, offset - 2);
        g2d.rotate(1.570795);
        g2d.translate(-x, -y);
    }

    public void setMapping(MapContainer im) {
        if (this.map != null) {
            this.map.deleteObserver(this);
        }
        this.map = im;
        this.map.addObserver(this);
    }

    private void selectionChanged() {
        this.offscreenValid = false;
        this.backBufferValid = false;
        int start = this.map.getMinIndex();
        int end = this.map.getMaxIndex();
        int gidRow = this.headerInfo.getIndex("GID");
        if (gidRow == -1) {
            gidRow = 0;
        }
        this.size = this.map.getScale() <= 20.0 ? (int)this.map.getScale() : 20;
        FontMetrics fontMetrics = this.getFontMetrics(new Font(this.face, this.style, this.size));
        this.maxlength = 1;
        for (int j = start; j < end; ++j) {
            int length;
            String[] headers = this.headerInfo.getHeader(j);
            String out = this.headerSummary.getSummary(this.headerInfo, j);
            if (out == null || this.maxlength >= (length = fontMetrics.stringWidth(out))) continue;
            this.maxlength = length;
        }
        Rectangle visible = this.getVisibleRect();
        this.setPreferredSize(new Dimension(this.map.getUsedPixels(), this.maxlength));
        this.revalidate();
        this.repaint();
        if (this.maxlength > this.oldHeight) {
            visible.y += this.maxlength - this.oldHeight;
            this.scrollRectToVisible(visible);
        }
        this.oldHeight = this.maxlength;
    }

    public void update(Observable o, Object arg) {
        if (o == this.map || o == this.dataModel) {
            this.selectionChanged();
        } else if (o == this.arraySelection) {
            this.selectionChanged();
        } else {
            System.out.println("ArrayNameView got funny update!");
        }
    }

    public void mouseClicked(MouseEvent e) {
        int index = this.map.getIndex(e.getX());
        if (this.map.contains(index)) {
            // empty if block
        }
    }

    public String getFace() {
        return this.face;
    }

    public int getPoints() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public void setFace(String string) {
        if (this.face == null || !this.face.equals(string)) {
            this.face = string;
            if (this.root != null) {
                this.root.setAttribute("face", this.face, "Lucida Sans Regular");
            }
            this.setFont(new Font(this.face, this.style, this.size));
            this.backBufferValid = false;
            this.repaint();
        }
    }

    public void setPoints(int i) {
        if (this.size != i) {
            this.size = i;
            if (this.root != null) {
                this.root.setAttribute("size", this.size, 12);
            }
            this.setFont(new Font(this.face, this.style, this.size));
            this.backBufferValid = false;
            this.repaint();
        }
    }

    public void setStyle(int i) {
        if (this.style != i) {
            this.style = i;
            this.backBufferValid = false;
            if (this.root != null) {
                this.root.setAttribute("style", this.style, 0);
            }
            this.setFont(new Font(this.face, this.style, this.size));
            this.repaint();
        }
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        if (configNode.fetchFirst("ArraySummary") == null) {
            this.getHeaderSummary().bindConfig(configNode.create("ArraySummary"));
            this.getHeaderSummary().setIncluded(new int[]{0});
        } else {
            this.getHeaderSummary().bindConfig(configNode.fetchFirst("ArraySummary"));
        }
        this.setFace(this.root.getAttribute("face", "Lucida Sans Regular"));
        this.setStyle(this.root.getAttribute("style", 0));
        this.setPoints(this.root.getAttribute("size", 12));
    }

    public void setArraySelection(TreeSelectionI arraySelection) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver(this);
        }
        this.arraySelection = arraySelection;
        this.arraySelection.addObserver(this);
    }
}

