/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.CharColorExtractor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class CharArrayDrawer
extends ArrayDrawer {
    protected CharColorExtractor colorExtractor;
    protected HeaderInfo headerInfo;
    protected String headerName;

    public void setColorExtractor(CharColorExtractor colorExtractor) {
        if (this.colorExtractor != null) {
            this.colorExtractor.deleteObserver(this);
        }
        this.colorExtractor = colorExtractor;
        colorExtractor.addObserver(this);
        this.setChanged();
    }

    public CharColorExtractor getColorExtractor() {
        return this.colorExtractor;
    }

    public void setHeaderInfo(HeaderInfo info, String name) {
        if (this.headerInfo != info || this.headerName != name) {
            this.headerInfo = info;
            this.headerName = name;
            this.setChanged();
        }
    }

    public void paint(int[] pixels, Rectangle source, Rectangle dest, int scanSize, int[] geneOrder) {
        if (this.headerInfo == null) {
            System.out.println("header info wasn't set");
        }
        int ynext = dest.y;
        int geneFirst = 0;
        for (int gene = 0; gene < source.height; ++gene) {
            ynext = dest.y + (dest.height + gene * dest.height) / source.height;
            int ystart = ynext;
            if (ynext == ystart) continue;
            int xnext = dest.x;
            int arrayFirst = 0;
            for (int array = 0; array < source.width; ++array) {
                xnext = dest.x + (dest.width + array * dest.width) / source.width;
                int xstart = xnext;
                if (xnext == xstart) continue;
                try {
                    int t_color;
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int count = 0;
                    for (int i = geneFirst; i <= gene; ++i) {
                        for (int j = arrayFirst; j <= array; ++j) {
                            int actualGene = source.y + i;
                            if (geneOrder != null) {
                                actualGene = geneOrder[actualGene];
                            }
                            Color thisC = this.getColor(j + source.x, actualGene);
                            r += thisC.getRed();
                            g += thisC.getGreen();
                            b += thisC.getBlue();
                            ++count;
                        }
                    }
                    if (count == 0) {
                        t_color = this.getColorExtractor().getMissing().getRGB();
                    } else {
                        Color consensus = new Color(r / count, g / count, b / count);
                        t_color = consensus.getRGB();
                    }
                    for (int x = xstart; x < xnext; ++x) {
                        for (int y = ystart; y < ynext; ++y) {
                            pixels[x + y * scanSize] = t_color;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                arrayFirst = array + 1;
            }
            geneFirst = gene + 1;
        }
    }

    public void paintChars(Graphics g, MapContainer xmap, MapContainer ymap, Rectangle destRect) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (int row = ymap.getIndex(destRect.y); row < ymap.getIndex(destRect.height); ++row) {
            for (int col = xmap.getIndex(destRect.x); col < xmap.getIndex(destRect.width); ++col) {
                int overx = xmap.getPixel(col);
                int overy = ymap.getPixel(row + 1);
                g.drawString(this.getSummary(col, row), overx, overy);
            }
        }
    }

    public void paintChars(Graphics g, Rectangle sourceRect, Rectangle destRect) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        for (int row = 0; row < sourceRect.height; ++row) {
            for (int col = 0; col < sourceRect.width; ++col) {
                int overx = destRect.x + col * destRect.width / sourceRect.width;
                int overy = destRect.y + (row + 1) * destRect.height / sourceRect.height;
                int noverx = destRect.x + (col + 1) * destRect.width / sourceRect.width;
                int lovery = destRect.y + row * destRect.height / sourceRect.height;
                String summary = this.getSummary(col + sourceRect.x, row + sourceRect.y);
                int width = metrics.stringWidth(summary);
                int cx = (noverx - overx - width) / 2;
                int cy = (overy - lovery - ascent) / 2;
                g.drawString(summary, overx + cx, overy - cy);
            }
        }
    }

    public char getChar(int x, int y) {
        String aln = this.headerInfo.getHeader(y, this.headerName);
        try {
            if (aln != null) {
                return aln.charAt(x);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return '\u0000';
    }

    public String getSummary(int x, int y) {
        return "" + this.getChar(x, y);
    }

    public boolean isMissing(int x, int y) {
        String aln = this.headerInfo.getHeader(y, this.headerName);
        try {
            if (aln != null) {
                char c = aln.charAt(x);
            }
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return true;
        }
    }

    public boolean isEmpty(int x, int y) {
        return false;
    }

    public int getNumRow() {
        if (this.headerInfo != null && this.headerName != null) {
            return this.headerInfo.getNumHeaders();
        }
        return 0;
    }

    public int getNumCol() {
        try {
            if (this.headerInfo != null && this.headerName != null) {
                int max = 0;
                for (int i = 0; i < this.headerInfo.getNumHeaders(); ++i) {
                    int length;
                    String header = this.headerInfo.getHeader(i, this.headerName);
                    if (header == null || (length = header.length()) <= max) continue;
                    max = length;
                }
                return max;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public Color getColor(int x, int y) {
        return this.colorExtractor.getColor(this.getChar(x, y));
    }

    protected void setDefaults() {
        this.headerInfo = null;
    }
}

