/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.CharColorSet;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import java.awt.Color;
import java.util.Observable;

public class CharColorExtractor
extends Observable
implements ConfigNodePersistent {
    private static CharColorSet defaultColorSet = new CharColorSet();
    private final CharColorSet colorSet = new CharColorSet();
    private ConfigNode root;

    public CharColorExtractor() {
        this.colorSet.copyStateFrom(defaultColorSet);
    }

    public void setDefaultColorSet(CharColorSet set) {
        defaultColorSet = set;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        ConfigNode cand = this.root.fetchFirst("ColorSet");
        if (cand == null) {
            cand = this.root.create("CharColorSet");
        }
        this.colorSet.bindConfig(cand);
    }

    public Color getMissing() {
        return this.colorSet.getMissing();
    }

    public Color getEmpty() {
        return this.colorSet.getEmpty();
    }

    public void setColor(char c, String newString) {
        if (ColorSet.encodeColor(this.colorSet.getColor(c)).equals(newString)) {
            return;
        }
        this.colorSet.setColor(c, ColorSet.decodeColor(newString));
        this.setChanged();
    }

    public void setMissingColor(String newString) {
        if (ColorSet.encodeColor(this.colorSet.getMissing()).equals(newString)) {
            return;
        }
        this.colorSet.setMissing(ColorSet.decodeColor(newString));
        this.setChanged();
    }

    public void setEmptyColor(String newString) {
        if (newString == null) {
            return;
        }
        if (ColorSet.encodeColor(this.colorSet.getEmpty()).equals(newString)) {
            return;
        }
        this.colorSet.setEmpty(ColorSet.decodeColor(newString));
        this.setChanged();
    }

    public void setColor(char c, Color newColor) {
        if (this.colorSet.getColor(c).equals(newColor)) {
            return;
        }
        this.colorSet.setColor(c, newColor);
        this.setChanged();
    }

    public void setMissingColor(Color newColor) {
        if (this.colorSet.getMissing().equals(newColor)) {
            return;
        }
        this.colorSet.setMissing(newColor);
        this.setChanged();
    }

    public void setEmptyColor(Color newColor) {
        if (newColor == null) {
            return;
        }
        if (this.colorSet.getEmpty().equals(newColor)) {
            return;
        }
        this.colorSet.setEmpty(newColor);
        this.setChanged();
    }

    public Color getColor(char c) {
        return this.colorSet.getColor(c);
    }

    public float[] getFloatColor(char c) {
        return this.getColor(c).getComponents(null);
    }

    public void printSelf() {
        System.out.println("missingColor " + this.getMissing());
        System.out.println("emptyColor " + this.getEmpty());
    }

    public int getARGBColor(char c) {
        return this.getColor(c).getRGB();
    }

    public void setDefaults() {
        this.setMissingColor(ColorSet.encodeColor(defaultColorSet.getMissing()));
        this.setEmptyColor(ColorSet.encodeColor(defaultColorSet.getEmpty()));
        this.setChanged();
    }
}

