/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ContrastSelectable;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import java.awt.Color;
import java.util.Observable;

public class ColorExtractor
extends Observable
implements ConfigNodePersistent,
ContrastSelectable {
    private ColorSet defaultColorSet;
    private double default_contrast = 3.0;
    private final ColorSet colorSet = new ColorSet();
    private boolean m_logTranform = false;
    private double m_logCenter = 1.0;
    private double m_logBaseDivisor;
    private double m_logBase;
    private ConfigNode root;
    private double contrast = this.default_contrast;
    private double nodata;
    private double empty;
    private final float[] upColor = new float[3];
    private final float[] zeroColor = new float[3];
    private final float[] downColor = new float[3];
    private final float[] missingColor = new float[3];
    private final float[] emptyColor = new float[3];

    public ColorExtractor() {
        this.defaultColorSet = new ColorSet();
        this.defaultColorSet.setUp(ColorSet.decodeColor("#FEFF00"));
        this.defaultColorSet.setZero(ColorSet.decodeColor("#000000"));
        this.defaultColorSet.setDown(ColorSet.decodeColor("#1BB7E5"));
        this.defaultColorSet.setMissing(ColorSet.decodeColor("#909090"));
        this.defaultColorSet.setEmpty(ColorSet.decodeColor("#FFFFFF"));
        this.setDefaultColorSet(this.defaultColorSet);
        this.setLogBase(2.0);
    }

    public void setDefaultColorSet(ColorSet set) {
        this.defaultColorSet = set;
    }

    public void bindConfig(ConfigNode configNode) {
        if (this.root != configNode) {
            this.root = configNode;
            ConfigNode cand = this.root.fetchFirst("ColorSet");
            if (cand == null) {
                cand = this.root.create("ColorSet");
            }
            this.colorSet.bindConfig(cand);
            this.synchFloats();
            this.contrast = this.root.getAttribute("contrast", this.getContrast());
            this.setLogCenter(this.root.getAttribute("logcenter", 1.0));
            this.setLogBase(this.root.getAttribute("logbase", 2.0));
            this.m_logTranform = this.root.getAttribute("logtransform", 0) == 1;
            this.setChanged();
        }
    }

    public void setContrast(double contrastValue) {
        if (this.contrast != contrastValue) {
            this.contrast = contrastValue;
            if (this.root != null) {
                this.root.setAttribute("contrast", this.contrast, this.default_contrast);
            }
            this.setChanged();
        }
    }

    public void setLogTransform(boolean transform) {
        if (transform != this.m_logTranform) {
            this.m_logTranform = transform;
            if (this.root != null) {
                this.root.setAttribute("logtransform", transform ? 1 : 0, 0);
            }
            this.setChanged();
        }
    }

    public void setLogCenter(double center) {
        if (this.m_logCenter != center) {
            this.m_logCenter = center;
            if (this.root != null) {
                this.root.setAttribute("logcenter", center, 1.0);
            }
            this.setChanged();
        }
    }

    public double getLogCenter() {
        return this.m_logCenter;
    }

    public void setLogBase(double base) {
        if (this.m_logBase != base) {
            this.m_logBase = base;
            this.m_logBaseDivisor = Math.log(base);
            if (this.root != null) {
                this.root.setAttribute("logbase", base, 2.0);
            }
            this.setChanged();
        }
    }

    public double getLogBase() {
        return this.m_logBase;
    }

    public boolean getLogTransform() {
        return this.m_logTranform;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setMissing(double missing, double empty) {
        this.nodata = missing;
        this.empty = empty;
        this.setChanged();
    }

    public Color getUp() {
        return this.colorSet.getUp();
    }

    public Color getZero() {
        return this.colorSet.getZero();
    }

    public Color getDown() {
        return this.colorSet.getDown();
    }

    public Color getMissing() {
        return this.colorSet.getMissing();
    }

    public Color getEmpty() {
        return this.colorSet.getEmpty();
    }

    private void synchFloats() {
        this.synchFloats(this.colorSet.getUp(), this.upColor);
        this.synchFloats(this.colorSet.getZero(), this.zeroColor);
        this.synchFloats(this.colorSet.getDown(), this.downColor);
        this.synchFloats(this.colorSet.getMissing(), this.missingColor);
        this.synchFloats(this.colorSet.getEmpty(), this.emptyColor);
    }

    private void synchFloats(Color newColor, float[] comp) {
        comp[0] = (float)newColor.getRed() / 256.0f;
        comp[1] = (float)newColor.getGreen() / 256.0f;
        comp[2] = (float)newColor.getBlue() / 256.0f;
    }

    public void setUpColor(String newString) {
        if (ColorSet.encodeColor(this.colorSet.getUp()).equals(newString)) {
            return;
        }
        this.colorSet.setUp(ColorSet.decodeColor(newString));
        this.synchFloats(this.colorSet.getUp(), this.upColor);
        this.setChanged();
    }

    public void setZeroColor(String newString) {
        if (ColorSet.encodeColor(this.colorSet.getZero()).equals(newString)) {
            return;
        }
        this.colorSet.setZero(ColorSet.decodeColor(newString));
        this.synchFloats(this.colorSet.getZero(), this.zeroColor);
        this.setChanged();
    }

    public void setDownColor(String newString) {
        if (ColorSet.encodeColor(this.colorSet.getDown()).equals(newString)) {
            return;
        }
        this.colorSet.setDown(ColorSet.decodeColor(newString));
        this.synchFloats(this.colorSet.getDown(), this.downColor);
        this.setChanged();
    }

    public void setMissingColor(String newString) {
        if (ColorSet.encodeColor(this.colorSet.getMissing()).equals(newString)) {
            return;
        }
        this.colorSet.setMissing(ColorSet.decodeColor(newString));
        this.synchFloats(this.colorSet.getMissing(), this.missingColor);
        this.setChanged();
    }

    public void setEmptyColor(String newString) {
        if (newString == null) {
            return;
        }
        if (ColorSet.encodeColor(this.colorSet.getEmpty()).equals(newString)) {
            return;
        }
        this.colorSet.setEmpty(ColorSet.decodeColor(newString));
        this.synchFloats(this.colorSet.getEmpty(), this.emptyColor);
        this.setChanged();
    }

    public void setUpColor(Color newColor) {
        if (this.colorSet.getUp().equals(newColor)) {
            return;
        }
        this.colorSet.setUp(newColor);
        this.synchFloats(this.colorSet.getUp(), this.upColor);
        this.setChanged();
    }

    public void setZeroColor(Color newColor) {
        if (this.colorSet.getZero().equals(newColor)) {
            return;
        }
        this.colorSet.setZero(newColor);
        this.synchFloats(this.colorSet.getZero(), this.zeroColor);
        this.setChanged();
    }

    public void setDownColor(Color newColor) {
        if (this.colorSet.getDown().equals(newColor)) {
            return;
        }
        this.colorSet.setDown(newColor);
        this.synchFloats(this.colorSet.getDown(), this.downColor);
        this.setChanged();
    }

    public void setMissingColor(Color newColor) {
        if (this.colorSet.getMissing().equals(newColor)) {
            return;
        }
        this.colorSet.setMissing(newColor);
        this.synchFloats(this.colorSet.getMissing(), this.missingColor);
        this.setChanged();
    }

    public void setEmptyColor(Color newColor) {
        if (newColor == null) {
            return;
        }
        if (this.colorSet.getEmpty().equals(newColor)) {
            return;
        }
        this.colorSet.setEmpty(newColor);
        this.synchFloats(this.colorSet.getEmpty(), this.emptyColor);
        this.setChanged();
    }

    public Color getColor(double dval) {
        float[] comp = this.getFloatColor(dval);
        Color color = new Color(comp[0], comp[1], comp[2]);
        return color;
    }

    public float[] getFloatColor(double dval) {
        double factor;
        if (dval == this.nodata) {
            return this.missingColor;
        }
        if (dval == this.empty) {
            return this.emptyColor;
        }
        if (this.m_logTranform) {
            dval = Math.log(dval / this.m_logCenter) / this.m_logBaseDivisor;
        }
        if ((factor = dval < 0.0 ? -dval / this.contrast : dval / this.contrast) > 1.0) {
            factor = 1.0;
        }
        if (factor < 0.0) {
            factor = 0.0;
        }
        float ffactor = (float)factor;
        float ff1 = (float)(1.0 - factor);
        float[] comp = new float[3];
        if (dval < 0.0) {
            for (int i = 0; i < 3; ++i) {
                comp[i] = this.downColor[i] * ffactor + this.zeroColor[i] * ff1;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                comp[i] = this.upColor[i] * ffactor + this.zeroColor[i] * ff1;
            }
        }
        return comp;
    }

    public void printSelf() {
        System.out.println("upColor " + this.upColor[0] + ", " + this.upColor[1] + ", " + this.upColor[2]);
        System.out.println("downColor " + this.downColor[0] + ", " + this.downColor[1] + ", " + this.downColor[2]);
        System.out.println("zeroColor " + this.zeroColor[0] + ", " + this.zeroColor[1] + ", " + this.zeroColor[2]);
        System.out.println("missingColor " + this.missingColor[0] + ", " + this.missingColor[1] + ", " + this.missingColor[2]);
        System.out.println("emptyColor " + this.emptyColor[0] + ", " + this.emptyColor[1] + ", " + this.emptyColor[2]);
    }

    public int getARGBColor(double dval) {
        float[] comp = this.getFloatColor(dval);
        return 0xFF000000 | (int)(255.0f * comp[0]) << 16 | (int)(255.0f * comp[1]) << 8 | (int)(255.0f * comp[2]);
    }

    public void setDefaults() {
        this.setUpColor(ColorSet.encodeColor(this.defaultColorSet.getUp()));
        this.setZeroColor(ColorSet.encodeColor(this.defaultColorSet.getZero()));
        this.setDownColor(ColorSet.encodeColor(this.defaultColorSet.getDown()));
        this.setMissingColor(ColorSet.encodeColor(this.defaultColorSet.getMissing()));
        this.setEmptyColor(ColorSet.encodeColor(this.defaultColorSet.getEmpty()));
        this.setContrast(this.default_contrast);
        this.synchFloats();
        this.setChanged();
    }
}

