/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

class ColorExtractorEditor
extends JPanel {
    private static final int UP = 0;
    private static final int ZERO = 1;
    private static final int DOWN = 2;
    private static final int MISSING = 3;
    private ColorExtractor colorExtractor;
    private ColorPanel[] colorPanel = new ColorPanel[4];

    public ColorExtractorEditor(ColorExtractor colorExtractor) {
        this.colorExtractor = colorExtractor;
        for (int i = 0; i < 4; ++i) {
            this.colorPanel[i] = new ColorPanel(i);
            this.add(this.colorPanel[i]);
        }
    }

    public void copyStateFrom(ColorSet source) {
        this.colorPanel[0].setColor(source.getUp());
        this.colorPanel[1].setColor(source.getZero());
        this.colorPanel[2].setColor(source.getDown());
        this.colorPanel[3].setColor(source.getMissing());
    }

    public void copyStateTo(ColorSet dest) {
        dest.setUp(this.colorPanel[0].getColor());
        dest.setZero(this.colorPanel[1].getColor());
        dest.setDown(this.colorPanel[2].getColor());
        dest.setMissing(this.colorPanel[3].getColor());
    }

    class ColorIcon
    implements Icon {
        private int width;
        private int height;
        private Color color;

        ColorIcon(int x, int y, Color c) {
            this.width = x;
            this.height = y;
            this.color = c;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color old = g.getColor();
            g.setColor(this.color);
            g.fillRect(x, y, this.width, this.height);
            g.setColor(Color.black);
            g.drawRect(x, y, this.width, this.height);
            g.setColor(old);
        }
    }

    class ColorPanel
    extends JPanel {
        ColorIcon colorIcon;
        int type;

        ColorPanel(int i) {
            this.type = i;
            this.redoComps();
        }

        public void redoComps() {
            this.removeAll();
            this.colorIcon = new ColorIcon(10, 10, this.getColor());
            JButton pushButton = new JButton(this.getLabel(), this.colorIcon);
            pushButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Color trial = JColorChooser.showDialog(ColorExtractorEditor.this, "Pick Color for " + ColorPanel.this.getLabel(), ColorPanel.this.getColor());
                    if (trial != null) {
                        ColorPanel.this.setColor(trial);
                    }
                }
            });
            this.add(pushButton);
        }

        private void setColor(Color c) {
            switch (this.type) {
                case 0: {
                    ColorExtractorEditor.this.colorExtractor.setUpColor(c);
                    break;
                }
                case 1: {
                    ColorExtractorEditor.this.colorExtractor.setZeroColor(c);
                    break;
                }
                case 2: {
                    ColorExtractorEditor.this.colorExtractor.setDownColor(c);
                    break;
                }
                case 3: {
                    ColorExtractorEditor.this.colorExtractor.setMissingColor(c);
                }
            }
            this.colorIcon.setColor(this.getColor());
            ColorExtractorEditor.this.colorExtractor.notifyObservers();
            this.repaint();
        }

        private String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Positive";
                }
                case 1: {
                    return "Zero";
                }
                case 2: {
                    return "Negative";
                }
                case 3: {
                    return "Missing";
                }
            }
            return null;
        }

        private Color getColor() {
            switch (this.type) {
                case 0: {
                    return ColorExtractorEditor.this.colorExtractor.getUp();
                }
                case 1: {
                    return ColorExtractorEditor.this.colorExtractor.getZero();
                }
                case 2: {
                    return ColorExtractorEditor.this.colorExtractor.getDown();
                }
                case 3: {
                    return ColorExtractorEditor.this.colorExtractor.getMissing();
                }
            }
            return null;
        }
    }
}

