/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DummyConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.SettingsPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorPresets;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSetEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ColorPresetEditor
extends JPanel
implements SettingsPanel {
    private ColorPresets presets;
    private Window window;
    private String title = "Color Preset Editor";
    private PresetEditPanel presetEditPanel;

    public ColorPresetEditor(ColorPresets up) {
        this.presets = up;
        this.presetEditPanel = new PresetEditPanel();
        this.add(this.presetEditPanel);
    }

    public void showConfig(Frame f) {
        if (this.window == null) {
            Dialog d = new Dialog(f, this.getTitle(), true);
            d.setLayout(new BorderLayout());
            d.add(new JScrollPane(this.presetEditPanel));
            d.add((Component)new JLabel(this.getTitle()), "North");
            d.add((Component)new ButtonPanel(), "South");
            d.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    we.getWindow().dispose();
                }
            });
            d.pack();
            this.window = d;
        }
        this.window.setVisible(true);
    }

    public static void main(String[] argv) {
        ColorPresets p = new ColorPresets(new DummyConfigNode("ColorPresets"));
        ColorPresetEditor e = new ColorPresetEditor(p);
        Frame f = new Frame(e.getTitle());
        e.showConfig(f);
        System.out.println("on exit, presets were\n" + p.toString());
        System.exit(0);
    }

    public void addToFrame(Frame f) {
        f.setLayout(new BorderLayout());
        this.presetEditPanel = new PresetEditPanel();
        f.add(new JScrollPane(this.presetEditPanel));
        f.add((Component)new ButtonPanel(), "South");
        this.window = f;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void synchronizeFrom() {
        this.presetEditPanel.initialize();
        this.presetEditPanel.redoLayout();
    }

    public void synchronizeTo() {
        this.presetEditPanel.saveAll();
    }

    private class PresetEditPanel
    extends JPanel {
        private GridBagConstraints gbc;
        private JRadioButton[] defaultButtons;
        private JTextField[] presetNames;
        private ColorSet[] presetColors;
        private ButtonGroup bob = new ButtonGroup();

        PresetEditPanel() {
            this.initialize();
            this.redoLayout();
        }

        private void initialize() {
            int nPresets = ColorPresetEditor.this.presets.getNumPresets();
            this.defaultButtons = new JRadioButton[nPresets];
            this.presetNames = new JTextField[nPresets];
            this.presetColors = new ColorSet[nPresets];
            for (int i = 0; i < nPresets; ++i) {
                this.initializePreset(i);
                this.bob.add(this.defaultButtons[i]);
            }
            if (nPresets > 0) {
                if (ColorPresetEditor.this.presets.getDefaultIndex() == -1) {
                    this.defaultButtons[0].setSelected(true);
                } else {
                    this.defaultButtons[ColorPresetEditor.this.presets.getDefaultIndex()].setSelected(true);
                }
            }
        }

        private void initializePreset(int i) {
            JRadioButton set;
            final int index = i;
            ColorSet colorSet = new ColorSet();
            JTextField nameField = new JTextField();
            nameField.setText(ColorPresetEditor.this.presets.getPresetNames()[index]);
            this.presetNames[index] = nameField;
            colorSet.copyStateFrom(ColorPresetEditor.this.presets.getColorSet(index));
            this.presetColors[index] = colorSet;
            this.defaultButtons[index] = set = new JRadioButton();
            set.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorPresetEditor.this.presets.setDefaultIndex(index);
                }
            });
        }

        public void redoLayout() {
            int nPresets = this.defaultButtons.length - 1;
            this.removeAll();
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.weighty = 100.0;
            this.gbc.gridwidth = 1;
            this.gbc.fill = 2;
            this.gbc.anchor = 11;
            this.gbc.gridy = 0;
            this.gbc.gridx = 0;
            this.gbc.weighty = 100.0;
            this.add((Component)new JLabel("Modify Color Presets", 0), this.gbc);
            this.gbc.weighty = 0.0;
            this.gbc.gridy = 1;
            this.gbc.gridx = 0;
            this.add((Component)new JLabel("Name"), this.gbc);
            this.gbc.gridx = 1;
            this.add((Component)new JLabel("Colors"), this.gbc);
            this.gbc.gridx = 3;
            this.add((Component)new JLabel("Default?"), this.gbc);
            for (int i = 0; i < nPresets; ++i) {
                ++this.gbc.gridy;
                this.addPreset(i);
            }
            ++this.gbc.gridy;
            JButton addP = new JButton("Add New");
            addP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PresetEditPanel.this.createPreset();
                }
            });
            ++this.gbc.gridy;
            this.gbc.gridx = 2;
            this.add((Component)addP, this.gbc);
            JButton addS = new JButton("Add Standards");
            addS.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorSet[] toAdd = ColorPresets.defaultColorSets;
                    for (int i = 0; i < toAdd.length; ++i) {
                        PresetEditPanel.this.addPreset(toAdd[i]);
                    }
                }
            });
            ++this.gbc.gridy;
            this.gbc.gridx = 2;
            this.add((Component)addS, this.gbc);
            this.revalidate();
            this.repaint();
        }

        private void addPreset(int i) {
            final int index = i;
            this.gbc.gridx = 0;
            this.add((Component)this.presetNames[index], this.gbc);
            this.gbc.gridx = 1;
            this.gbc.weightx = 100.0;
            this.add((Component)new ColorSetEditor(this.presetColors[index]), this.gbc);
            this.gbc.gridx = 2;
            this.gbc.weightx = 0.0;
            JButton rem = new JButton("Remove");
            rem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PresetEditPanel.this.removePreset(index);
                }
            });
            this.add((Component)rem, this.gbc);
            this.gbc.gridx = 3;
            this.add((Component)this.defaultButtons[index], this.gbc);
        }

        private void saveAll() {
            int i;
            int o;
            int n = this.presetNames.length - 1;
            for (o = ColorPresetEditor.this.presets.getNumPresets(); n > o; ++o) {
                ColorSet temp = new ColorSet();
                temp.setName("Preset" + o);
                ColorPresetEditor.this.presets.addColorSet(temp);
            }
            while (o > n) {
                ColorPresetEditor.this.presets.removeColorSet(--o);
            }
            for (i = 0; i < n; ++i) {
                this.presetColors[i].setName(this.presetNames[i].getText());
            }
            for (i = 0; i < n; ++i) {
                ColorPresetEditor.this.presets.getColorSet(i).copyStateFrom(this.presetColors[i]);
            }
        }

        private void removePreset(int mark) {
            ColorSet[] tPresetColors = new ColorSet[this.presetColors.length - 1];
            JTextField[] tPresetNames = new JTextField[this.presetNames.length - 1];
            JRadioButton[] tDefaultButtons = new JRadioButton[this.defaultButtons.length - 1];
            for (int i = 0; i < tPresetColors.length; ++i) {
                int j = i;
                if (i >= mark) {
                    ++j;
                }
                tPresetColors[i] = this.presetColors[j];
                tPresetNames[i] = this.presetNames[j];
                tDefaultButtons[i] = this.defaultButtons[j];
            }
            this.bob.remove(this.defaultButtons[mark]);
            int selectedIndex = 0;
            for (int i = 0; i < this.defaultButtons.length; ++i) {
                if (this.defaultButtons[i] == null || !this.defaultButtons[i].isSelected()) continue;
                selectedIndex = i;
            }
            if (selectedIndex > tPresetNames.length - 2) {
                tDefaultButtons[tPresetNames.length - 2].setSelected(true);
            } else {
                tDefaultButtons[selectedIndex].setSelected(true);
            }
            this.presetNames = tPresetNames;
            this.presetColors = tPresetColors;
            this.defaultButtons = tDefaultButtons;
            this.redoLayout();
        }

        private void createPreset() {
            ColorSet toAdd = new ColorSet();
            this.addPreset(toAdd);
        }

        private void addPreset(ColorSet toAdd) {
            JRadioButton set;
            ColorSet[] tPresetColors = new ColorSet[this.presetColors.length + 1];
            JTextField[] tPresetNames = new JTextField[this.presetNames.length + 1];
            JRadioButton[] tDefaultButtons = new JRadioButton[this.defaultButtons.length + 1];
            for (int i = 0; i < this.presetColors.length; ++i) {
                tPresetColors[i] = this.presetColors[i];
                tPresetNames[i] = this.presetNames[i];
                tDefaultButtons[i] = this.defaultButtons[i];
            }
            final int newIndex = tPresetNames.length - 2;
            tPresetColors[newIndex + 1] = tPresetColors[newIndex];
            tPresetNames[newIndex + 1] = this.presetNames[newIndex];
            tDefaultButtons[newIndex + 1] = tDefaultButtons[newIndex];
            tPresetNames[newIndex] = new JTextField("Preset" + newIndex);
            tPresetColors[newIndex] = toAdd;
            tDefaultButtons[newIndex] = set = new JRadioButton();
            set.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorPresetEditor.this.presets.setDefaultIndex(newIndex);
                }
            });
            this.bob.add(set);
            this.presetNames = tPresetNames;
            this.presetColors = tPresetColors;
            this.defaultButtons = tDefaultButtons;
            this.redoLayout();
        }
    }

    private class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            JButton save_button = new JButton("Save");
            save_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorPresetEditor.this.synchronizeTo();
                    ColorPresetEditor.this.window.dispose();
                }
            });
            this.add(save_button);
            JButton cancel_button = new JButton("Cancel");
            cancel_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorPresetEditor.this.synchronizeFrom();
                    ColorPresetEditor.this.window.dispose();
                }
            });
            this.add(cancel_button);
        }
    }
}

