/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ColorIcon;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ColorSetEditor
extends JPanel {
    private static final int UP = 0;
    private static final int ZERO = 1;
    private static final int DOWN = 2;
    private static final int MISSING = 3;
    private ColorSet colorSet;

    public ColorSetEditor(ColorSet colorSet) {
        this.colorSet = colorSet;
        this.add(new ColorPanel(0));
        this.add(new ColorPanel(1));
        this.add(new ColorPanel(2));
        this.add(new ColorPanel(3));
    }

    public static final void main(String[] argv) {
        ColorSet temp = new ColorSet();
        ColorSetEditor cse = new ColorSetEditor(temp);
        JFrame frame = new JFrame("ColorSetEditor Test");
        frame.getContentPane().add(cse);
        frame.pack();
        frame.setVisible(true);
    }

    class ColorPanel
    extends JPanel {
        ColorIcon colorIcon;
        int type;

        ColorPanel(int i) {
            this.type = i;
            this.redoComps();
        }

        public void redoComps() {
            this.removeAll();
            this.colorIcon = new ColorIcon(10, 10, this.getColor());
            JButton pushButton = new JButton(this.getLabel(), this.colorIcon);
            pushButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Color trial = JColorChooser.showDialog(ColorSetEditor.this, "Pick Color for " + ColorPanel.this.getLabel(), ColorPanel.this.getColor());
                    if (trial != null) {
                        ColorPanel.this.setColor(trial);
                    }
                }
            });
            this.add(pushButton);
        }

        private void setColor(Color c) {
            switch (this.type) {
                case 0: {
                    ColorSetEditor.this.colorSet.setUp(c);
                    break;
                }
                case 1: {
                    ColorSetEditor.this.colorSet.setZero(c);
                    break;
                }
                case 2: {
                    ColorSetEditor.this.colorSet.setDown(c);
                    break;
                }
                case 3: {
                    ColorSetEditor.this.colorSet.setMissing(c);
                }
            }
            this.colorIcon.setColor(this.getColor());
            this.repaint();
        }

        private String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Positive";
                }
                case 1: {
                    return "Zero";
                }
                case 2: {
                    return "Negative";
                }
                case 3: {
                    return "Missing";
                }
            }
            return null;
        }

        private Color getColor() {
            switch (this.type) {
                case 0: {
                    return ColorSetEditor.this.colorSet.getUp();
                }
                case 1: {
                    return ColorSetEditor.this.colorSet.getZero();
                }
                case 2: {
                    return ColorSetEditor.this.colorSet.getDown();
                }
                case 3: {
                    return ColorSetEditor.this.colorSet.getMissing();
                }
            }
            return null;
        }
    }
}

