/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinearTransformation;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelViewBuffered;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.LeftTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;

public class GTRView
extends ModelViewBuffered
implements MouseListener,
KeyListener {
    private static final String[] hints = new String[]{"Click to select node", " - use arrow keys to navigate tree"};
    protected HeaderSummary headerSummary = new HeaderSummary();
    private TreeSelectionI geneSelection;
    private LinearTransformation xScaleEq;
    private LinearTransformation yScaleEq;
    private MapContainer map;
    private LeftTreeDrawer drawer = null;
    private TreeDrawerNode selectedNode = null;
    private Rectangle destRect = null;

    public GTRView() {
        this.panel = this;
        this.destRect = new Rectangle();
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public String[] getHints() {
        return hints;
    }

    public void setLeftTreeDrawer(LeftTreeDrawer d) {
        if (this.drawer != null) {
            this.drawer.deleteObserver(this);
        }
        this.drawer = d;
        this.drawer.addObserver(this);
    }

    public void setGeneSelection(TreeSelectionI geneSelection) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver(this);
        }
        this.geneSelection = geneSelection;
        this.geneSelection.addObserver(this);
    }

    public void setMap(MapContainer m) {
        if (this.map != null) {
            this.map.deleteObserver(this);
        }
        this.map = m;
        this.map.addObserver(this);
        this.offscreenValid = false;
        this.repaint();
    }

    private void synchMap() {
        if (this.selectedNode != null && this.geneSelection != null) {
            int start = (int)this.selectedNode.getLeftLeaf().getIndex();
            int end = (int)this.selectedNode.getRightLeaf().getIndex();
            this.geneSelection.deselectAllIndexes();
            this.geneSelection.selectIndexRange(start, end);
            this.geneSelection.setSelectedNode(this.selectedNode.getId());
            this.geneSelection.notifyObservers();
        }
        if (this.status != null && this.hasMouse) {
            this.status.setMessages(this.getStatus());
        }
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void setSelectedNode(TreeDrawerNode n) {
        if (this.selectedNode == n) {
            return;
        }
        if (this.getYScaleEq() != null) {
            if (this.selectedNode != null) {
                this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode, false);
            }
            this.selectedNode = n;
            if (this.selectedNode != null) {
                this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode, true);
            }
        } else {
            this.selectedNode = n;
        }
        this.synchMap();
        this.repaint();
    }

    private void selectParent() {
        TreeDrawerNode current = this.selectedNode;
        this.selectedNode = current.getParent();
        if (this.selectedNode == null) {
            this.selectedNode = current;
            return;
        }
        current = current == this.selectedNode.getLeft() ? this.selectedNode.getRight() : this.selectedNode.getLeft();
        this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, current, true);
        this.drawer.paintSingle(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode, true);
        this.synchMap();
        this.repaint();
    }

    private void selectRight() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode current = this.selectedNode;
        this.selectedNode = current.getRight();
        this.drawer.paintSingle(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, current, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, current.getLeft(), false);
        this.synchMap();
        this.repaint();
    }

    private void selectLeft() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode current = this.selectedNode;
        this.selectedNode = current.getLeft();
        this.drawer.paintSingle(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, current, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, current.getRight(), false);
        this.synchMap();
        this.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o == this.map) {
            this.offscreenValid = false;
            this.repaint();
        } else if (o == this.drawer) {
            this.offscreenValid = false;
            this.repaint();
        } else if (o == this.geneSelection) {
            TreeDrawerNode cand = null;
            if (this.geneSelection.getNSelectedIndexes() > 0) {
                if (this.geneSelection.getMinIndex() == this.geneSelection.getMaxIndex()) {
                    cand = this.drawer.getLeaf(this.geneSelection.getMinIndex());
                } else if (this.geneSelection.getMinIndex() == this.map.getMinIndex() && this.geneSelection.getMaxIndex() == this.map.getMaxIndex()) {
                    cand = this.drawer.getRootNode();
                }
            }
            if (cand != null && cand.getId() != this.geneSelection.getSelectedNode()) {
                String id = cand.getId();
                this.geneSelection.setSelectedNode(id);
                this.geneSelection.notifyObservers();
            } else {
                this.setSelectedNode(this.drawer.getNodeById(this.geneSelection.getSelectedNode()));
            }
        }
    }

    public void setZoomMap(MapContainer m) {
    }

    public String viewName() {
        return "GTRView";
    }

    public String[] getStatus() {
        String[] status;
        if (this.selectedNode != null) {
            if (this.selectedNode.isLeaf()) {
                status = new String[]{"Leaf Node " + this.selectedNode.getId(), "Pos " + this.selectedNode.getCorr()};
            } else {
                int[] nameIndex = this.getHeaderSummary().getIncluded();
                status = new String[nameIndex.length * 2];
                HeaderInfo gtrInfo = this.getViewFrame().getDataModel().getGtrHeaderInfo();
                String[] names = gtrInfo.getNames();
                for (int i = 0; i < nameIndex.length; ++i) {
                    status[2 * i] = names[nameIndex[i]] + ":";
                    status[2 * i + 1] = " " + gtrInfo.getHeader(gtrInfo.getHeaderIndex(this.selectedNode.getId()))[nameIndex[i]];
                }
            }
        } else {
            status = new String[]{"Select Node to ", "view annotation."};
        }
        return status;
    }

    public void updateBuffer(Graphics g) {
        if (this.offscreenChanged) {
            this.offscreenValid = false;
        }
        if (!this.offscreenValid && this.drawer != null) {
            this.map.setAvailablePixels(this.offscreenSize.height);
            g.setColor(Color.white);
            g.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
            g.setColor(Color.black);
            this.destRect.setBounds(0, 0, this.offscreenSize.width, this.map.getUsedPixels());
            this.setXScaleEq(new LinearTransformation(this.drawer.getCorrMin(), this.destRect.x, this.drawer.getCorrMax(), this.destRect.x + this.destRect.width));
            this.setYScaleEq(new LinearTransformation(this.map.getIndex(this.destRect.y), this.destRect.y, this.map.getIndex(this.destRect.y + this.destRect.height), this.destRect.y + this.destRect.height));
            this.drawer.paint(g, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        if (this.drawer != null && this.getXScaleEq() != null) {
            if (this.drawer == null) {
                // empty if block
            }
            if (this.getXScaleEq() == null) {
                // empty if block
            }
            this.setSelectedNode(this.drawer.getClosest(this.getYScaleEq().inverseTransform(e.getY()), this.getXScaleEq().inverseTransform(e.getX()), this.getXScaleEq().getSlope() / this.getYScaleEq().getSlope()));
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.selectedNode == null) {
            return;
        }
        int c = e.getKeyCode();
        switch (c) {
            case 38: {
                this.selectParent();
                break;
            }
            case 37: {
                if (this.selectedNode.isLeaf()) break;
                this.selectLeft();
                break;
            }
            case 39: {
                if (this.selectedNode.isLeaf()) break;
                this.selectRight();
                break;
            }
            case 40: {
                if (this.selectedNode.isLeaf()) break;
                TreeDrawerNode right = this.selectedNode.getRight();
                TreeDrawerNode left = this.selectedNode.getLeft();
                if (right.getRange() > left.getRange()) {
                    this.selectRight();
                    break;
                }
                this.selectLeft();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setXScaleEq(LinearTransformation xScaleEq) {
        this.xScaleEq = xScaleEq;
    }

    public LinearTransformation getXScaleEq() {
        return this.xScaleEq;
    }

    public void setYScaleEq(LinearTransformation yScaleEq) {
        this.yScaleEq = yScaleEq;
    }

    public LinearTransformation getYScaleEq() {
        return this.yScaleEq;
    }

    public void scrollToNode(String nodeName) {
        int index;
        TreeDrawerNode node = this.drawer.getNodeById(nodeName);
        if (node != null && !this.map.isVisible(index = (int)node.getIndex())) {
            this.map.scrollToIndex(index);
            this.map.notifyObservers();
        }
    }
}

