/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelViewProduced;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;

class GlobalView
extends ModelViewProduced
implements MouseMotionListener,
MouseListener,
KeyListener {
    private ArrayDrawer drawer;
    private Point startPoint = new Point();
    private Point endPoint = new Point();
    private Rectangle dragRect = new Rectangle();
    private Rectangle selectionRect = null;
    private Rectangle zoomRect = null;
    protected TreeSelectionI geneSelection;
    protected TreeSelectionI arraySelection;
    protected MapContainer xmap;
    protected MapContainer ymap;
    protected MapContainer zoomXmap;
    protected MapContainer zoomYmap;
    private static final String[] hints = new String[]{"use arrow keys to move selection", "click and drag to select genes", "- hold shift to select arrays too"};
    protected boolean hasDrawn = false;

    public GlobalView() {
        this.panel = this;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public Dimension getPreferredSize() {
        Dimension p = new Dimension(this.xmap.getRequiredPixels(), this.ymap.getRequiredPixels());
        return p;
    }

    public String[] getStatus() {
        String[] status = new String[4];
        if (this.geneSelection == null || this.arraySelection == null) {
            status[0] = "ERROR: GlobalView improperly configured";
            status[1] = " geneSelection is null";
            status[2] = " thus, gene selection will not work.";
            status[3] = "";
        } else {
            int sx = this.arraySelection.getMinIndex();
            int ex = this.arraySelection.getMaxIndex();
            int sy = this.geneSelection.getMinIndex();
            int ey = this.geneSelection.getMaxIndex();
            status[0] = ey - sy + 1 + " genes selected";
            status[1] = ex - sx + 1 + " arrays selected";
            status[2] = "Genes from " + sy + " to " + ey;
            status[3] = "Arrays from " + sx + " to " + ex;
        }
        return status;
    }

    public String[] getHints() {
        return hints;
    }

    public void setGeneSelection(TreeSelectionI geneSelection) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver(this);
        }
        this.geneSelection = geneSelection;
        this.geneSelection.addObserver(this);
    }

    public void setArraySelection(TreeSelectionI arraySelection) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver(this);
        }
        this.arraySelection = arraySelection;
        this.arraySelection.addObserver(this);
    }

    public void setArrayDrawer(ArrayDrawer arrayDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver(this);
        }
        this.drawer = arrayDrawer;
        this.drawer.addObserver(this);
    }

    public ArrayDrawer getArrayDrawer() {
        return this.drawer;
    }

    public void setXMap(MapContainer m) {
        if (this.xmap != null) {
            this.xmap.deleteObserver(this);
        }
        this.xmap = m;
        this.xmap.addObserver(this);
    }

    public void setYMap(MapContainer m) {
        if (this.ymap != null) {
            this.ymap.deleteObserver(this);
        }
        this.ymap = m;
        this.ymap.addObserver(this);
    }

    public MapContainer getXMap() {
        return this.xmap;
    }

    public MapContainer getYMap() {
        return this.ymap;
    }

    public void setZoomXMap(MapContainer m) {
        if (this.zoomXmap != null) {
            this.zoomXmap.deleteObserver(this);
        }
        this.zoomXmap = m;
        this.zoomXmap.addObserver(this);
    }

    public void setZoomYMap(MapContainer m) {
        if (this.zoomYmap != null) {
            this.zoomYmap.deleteObserver(this);
        }
        this.zoomYmap = m;
        this.zoomYmap.addObserver(this);
    }

    public String viewName() {
        return "GlobalView";
    }

    protected void updateBuffer(Graphics g) {
        if (this.offscreenChanged) {
            this.xmap.setAvailablePixels(this.offscreenSize.width);
            this.ymap.setAvailablePixels(this.offscreenSize.height);
            if (!this.hasDrawn) {
                this.xmap.recalculateScale();
                this.ymap.recalculateScale();
                this.hasDrawn = true;
            }
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!this.offscreenValid) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
            g.setColor(Color.black);
            Rectangle destRect = new Rectangle(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            Rectangle sourceRect = new Rectangle(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(destRect.width) - this.xmap.getIndex(0), this.ymap.getIndex(destRect.height) - this.ymap.getIndex(0));
            if (sourceRect.x >= 0 && sourceRect.y >= 0) {
                this.drawer.paint(g, sourceRect, destRect, null);
            }
        }
    }

    protected void updatePixels() {
        if (this.offscreenChanged) {
            this.offscreenValid = false;
            this.xmap.setAvailablePixels(this.offscreenSize.width);
            this.ymap.setAvailablePixels(this.offscreenSize.height);
            if (!this.hasDrawn) {
                this.xmap.recalculateScale();
                this.ymap.recalculateScale();
                this.hasDrawn = true;
            }
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!this.offscreenValid) {
            Rectangle destRect = new Rectangle(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            Rectangle sourceRect = new Rectangle(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(destRect.width) - this.xmap.getIndex(0), this.ymap.getIndex(destRect.height) - this.ymap.getIndex(0));
            if (sourceRect.x >= 0 && sourceRect.y >= 0) {
                this.drawer.paint(this.offscreenPixels, sourceRect, destRect, this.offscreenScanSize);
            }
            this.offscreenSource.newPixels();
        }
    }

    public synchronized void paintComposite(Graphics g) {
        if (this.selectionRect != null) {
            g.setColor(Color.white);
            g.drawRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
            g.setColor(Color.black);
            g.drawRect(this.selectionRect.x - 1, this.selectionRect.y - 1, this.selectionRect.width + 2, this.selectionRect.height + 2);
            if (this.zoomRect != null) {
                g.setColor(Color.magenta);
                g.drawRect(this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height);
                g.drawRect(this.zoomRect.x - 1, this.zoomRect.y - 1, this.zoomRect.width + 2, this.zoomRect.height + 2);
                g.setColor(Color.black);
                g.drawRect(this.zoomRect.x - 2, this.zoomRect.y - 2, this.zoomRect.width + 4, this.zoomRect.height + 4);
            }
        }
    }

    private void repaintRect(Graphics g, Rectangle r) {
        int i;
        if (r == null) {
            return;
        }
        for (i = 0; i <= r.width; ++i) {
            this.drawer.paintPixel(g, this.xmap, this.ymap, i + r.x, r.y, null);
            this.drawer.paintPixel(g, this.xmap, this.ymap, i + r.x, r.y + r.height, null);
        }
        for (i = 1; i < r.height; ++i) {
            this.drawer.paintPixel(g, this.xmap, this.ymap, r.x, i + r.y, null);
            this.drawer.paintPixel(g, this.xmap, this.ymap, r.x + r.width, i + r.y, null);
        }
    }

    protected void recalculateOverlay() {
        if (this.geneSelection == null || this.arraySelection == null) {
            return;
        }
        int spx = this.xmap.getPixel(this.arraySelection.getMinIndex());
        int epx = this.xmap.getPixel(this.arraySelection.getMaxIndex() + 1) - 1;
        int spy = this.ymap.getPixel(this.geneSelection.getMinIndex());
        int epy = this.ymap.getPixel(this.geneSelection.getMaxIndex() + 1) - 1;
        if (epy < spy) {
            epy = spy;
        }
        if (this.selectionRect == null) {
            this.selectionRect = new Rectangle(spx, spy, epx - spx, epy - spy);
        } else {
            this.selectionRect.setBounds(spx, spy, epx - spx, epy - spy);
        }
    }

    protected void recalculateZoom() {
        int epy;
        int spy;
        int epx;
        int spx;
        if (this.selectionRect == null) {
            return;
        }
        try {
            spx = this.xmap.getPixel(this.zoomXmap.getIndex(0));
            epx = this.xmap.getPixel(this.zoomXmap.getIndex(this.zoomXmap.getUsedPixels())) - 1;
            spy = this.ymap.getPixel(this.zoomYmap.getIndex(0));
            epy = this.ymap.getPixel(this.zoomYmap.getIndex(this.zoomYmap.getUsedPixels())) - 1;
        }
        catch (ArithmeticException e) {
            return;
        }
        if (this.zoomRect == null) {
            this.zoomRect = new Rectangle(spx, spy, epx - spx, epy - spy);
        } else {
            this.zoomRect.setBounds(spx, spy, epx - spx, epy - spy);
        }
    }

    public void update(Observable o, Object arg) {
        if (o == this.geneSelection) {
            if (this.arraySelection.getNSelectedIndexes() == 0 && this.geneSelection.getNSelectedIndexes() != 0) {
                this.arraySelection.selectAllIndexes();
                this.arraySelection.notifyObservers();
                return;
            }
            this.recalculateOverlay();
        } else if (o == this.arraySelection) {
            if (this.geneSelection.getNSelectedIndexes() == 0 && this.arraySelection.getNSelectedIndexes() != 0) {
                this.geneSelection.selectAllIndexes();
                this.geneSelection.notifyObservers();
                return;
            }
            this.recalculateOverlay();
        } else if (o == this.xmap || o == this.ymap) {
            this.recalculateZoom();
            this.recalculateOverlay();
            this.offscreenValid = false;
        } else if (o == this.zoomYmap || o == this.zoomXmap) {
            this.recalculateZoom();
            if (this.status != null && this.hasMouse) {
                this.status.setMessages(this.getStatus());
            }
        } else if (o == this.drawer) {
            this.offscreenValid = false;
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        this.startPoint.setLocation(this.xmap.getIndex(e.getX()), this.ymap.getIndex(e.getY()));
        this.endPoint.setLocation(this.startPoint.x, this.startPoint.y);
        this.dragRect.setLocation(this.startPoint.x, this.startPoint.y);
        this.dragRect.setSize(this.endPoint.x - this.dragRect.x, this.endPoint.y - this.dragRect.y);
        this.drawBand(this.dragRect);
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        this.mouseDragged(e);
        this.drawBand(this.dragRect);
        if (e.isShiftDown()) {
            this.selectRectangle(this.startPoint, this.endPoint);
        } else {
            Point start = new Point(this.xmap.getMinIndex(), this.startPoint.y);
            Point end = new Point(this.xmap.getMaxIndex(), this.endPoint.y);
            this.selectRectangle(start, end);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.drawBand(this.dragRect);
        this.endPoint.setLocation(this.xmap.getIndex(e.getX()), this.ymap.getIndex(e.getY()));
        if (e.isShiftDown()) {
            this.dragRect.setLocation(this.startPoint.x, this.startPoint.y);
            this.dragRect.setSize(0, 0);
            this.dragRect.add(this.endPoint.x, this.endPoint.y);
        } else {
            this.dragRect.setLocation(this.xmap.getMinIndex(), this.startPoint.y);
            this.dragRect.setSize(0, 0);
            this.dragRect.add(this.xmap.getMaxIndex(), this.endPoint.y);
        }
        this.drawBand(this.dragRect);
    }

    private void drawBand(Rectangle l) {
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        int x = this.xmap.getPixel(l.x);
        int y = this.ymap.getPixel(l.y);
        int w = this.xmap.getPixel(l.x + l.width + 1) - x;
        int h = this.ymap.getPixel(l.y + l.height + 1) - y;
        g.drawRect(x, y, w, h);
        g.setPaintMode();
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        switch (c) {
            case '+': {
                this.xmap.setScale(this.xmap.getScale() * 2.0);
                this.ymap.setScale(this.ymap.getScale() * 2.0);
                break;
            }
            case '-': {
                double xScale = this.xmap.getScale() / 2.0;
                double yScale = this.ymap.getScale() / 2.0;
                if (xScale >= 1.0) {
                    this.xmap.setScale(xScale);
                }
                if (!(yScale >= 1.0)) break;
                this.ymap.setScale(yScale);
                break;
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        block18: {
            int c;
            block17: {
                c = e.getKeyCode();
                this.startPoint.setLocation(this.arraySelection.getMinIndex(), this.geneSelection.getMinIndex());
                this.endPoint.setLocation(this.arraySelection.getMaxIndex(), this.geneSelection.getMaxIndex());
                if (!e.isControlDown()) break block17;
                switch (c) {
                    case 38: {
                        this.startPoint.translate(0, -1);
                        this.endPoint.translate(0, 1);
                        break block18;
                    }
                    case 40: {
                        this.startPoint.translate(0, 1);
                        this.endPoint.translate(0, -1);
                        break block18;
                    }
                    case 37: {
                        this.startPoint.translate(1, 0);
                        this.endPoint.translate(-1, 0);
                        break block18;
                    }
                    case 39: {
                        this.startPoint.translate(-1, 0);
                        this.endPoint.translate(1, 0);
                        break block18;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (c) {
                case 38: {
                    this.startPoint.translate(0, -1);
                    this.endPoint.translate(0, -1);
                    break;
                }
                case 40: {
                    this.startPoint.translate(0, 1);
                    this.endPoint.translate(0, 1);
                    break;
                }
                case 37: {
                    this.startPoint.translate(-1, 0);
                    this.endPoint.translate(-1, 0);
                    break;
                }
                case 39: {
                    this.startPoint.translate(1, 0);
                    this.endPoint.translate(1, 0);
                    break;
                }
                case 16: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
        int overx = 0;
        int overy = 0;
        if (this.startPoint.x < this.xmap.getMinIndex()) {
            overx += this.startPoint.x - this.xmap.getMinIndex();
        }
        if (this.startPoint.y < this.ymap.getMinIndex()) {
            overy += this.startPoint.y - this.ymap.getMinIndex();
        }
        if (this.endPoint.x > this.xmap.getMaxIndex()) {
            overx += this.endPoint.x - this.xmap.getMaxIndex();
        }
        if (this.startPoint.y < this.ymap.getMinIndex()) {
            overy += this.startPoint.y - this.ymap.getMinIndex();
        }
        this.startPoint.x -= overx;
        this.endPoint.x -= overx;
        this.startPoint.y -= overy;
        this.endPoint.y -= overy;
        this.selectRectangle(this.startPoint, this.endPoint);
    }

    private void selectRectangle(Point start, Point end) {
        int i;
        if (end.x < start.x) {
            int x = end.x;
            end.x = start.x;
            start.x = x;
        }
        if (end.y < start.y) {
            int y = end.y;
            end.y = start.y;
            start.y = y;
        }
        this.geneSelection.setSelectedNode(null);
        this.geneSelection.deselectAllIndexes();
        for (i = start.y; i <= end.y; ++i) {
            this.geneSelection.setIndex(i, true);
        }
        this.arraySelection.setSelectedNode(null);
        this.arraySelection.deselectAllIndexes();
        for (i = start.x; i <= end.x; ++i) {
            this.arraySelection.setIndex(i, true);
        }
        this.geneSelection.notifyObservers();
        this.arraySelection.notifyObservers();
    }
}

