/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinearTransformation;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.SettingsPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayNameView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.CharArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DendroView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.InvertedTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.LeftTreeDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TextView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TreeColorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class GraphicsExportPanel
extends JPanel
implements SettingsPanel {
    private ConfigNode root;
    private String[] formats = new String[]{"png", "jpg", "bmp", "pdf", "svg", "eps"};
    private DendroView view;
    private DataModel model;
    private HeaderInfo arrayHeaderInfo;
    private HeaderInfo geneHeaderInfo;
    private TreeSelectionI geneSelection;
    private TreeSelectionI arraySelection;
    private InvertedTreeDrawer arrayTreeDrawer;
    private LeftTreeDrawer geneTreeDrawer;
    private ArrayDrawer arrayDrawer;
    private MapContainer geneMap;
    private MapContainer arrayMap;
    private FilePanel filePanel;
    private InclusionPanel inclusionPanel;
    private HeaderSelectionPanel headerSelectionPanel;
    private JComboBox formatPullDown;
    private JCheckBox appendExt;
    int borderPixels = 5;
    private static int textSpacing = 2;
    boolean hasChar = false;
    private Font geneFont = new Font("Lucida Sans Regular", 0, 12);
    private Font arrayFont = new Font("Lucida Sans Regular", 0, 12);
    JCheckBox selectionBox;

    public GraphicsExportPanel(DendroView view) {
        this.view = view;
        this.model = view.getDataModel();
        this.arrayHeaderInfo = this.model.getArrayHeaderInfo();
        this.geneHeaderInfo = this.model.getGeneHeaderInfo();
        this.geneSelection = view.getGeneSelection();
        this.arraySelection = view.getArraySelection();
        this.arrayTreeDrawer = view.getArrayTreeDrawer();
        this.geneTreeDrawer = view.getGeneTreeDrawer();
        this.arrayDrawer = view.getArrayDrawer();
        if (this.geneSelection.getNSelectedIndexes() != 0 || this.arraySelection.getNSelectedIndexes() != 0) {
            this.arrayMap = view.getZoomXmap();
            this.geneMap = view.getZoomYmap();
        } else {
            this.arrayMap = view.getGlobalXmap();
            this.geneMap = view.getGlobalYmap();
        }
        this.setupWidgets();
        this.inclusionPanel.synchSelected();
        this.inclusionPanel.synchEnabled();
    }

    protected HeaderInfo getArrayHeaderInfo() {
        return this.arrayHeaderInfo;
    }

    protected HeaderInfo getGeneHeaderInfo() {
        return this.geneHeaderInfo;
    }

    protected TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    protected TreeSelectionI getArraySelection() {
        return this.arraySelection;
    }

    protected ArrayDrawer getArrayDrawer() {
        return this.arrayDrawer;
    }

    public void synchronizeTo() {
        String format = (String)this.formatPullDown.getSelectedItem();
        if (format.equals("png") || format.equals("jpg") || format.equals("bmp")) {
            this.bitmapSave(format);
        } else if (format.equals("pdf")) {
            this.pdfSave(format);
        } else if (format.equals("eps")) {
            this.epsSave(format);
        } else if (format.equals("svg")) {
            this.svgSave(format);
        }
    }

    public void synchronizeFrom() {
    }

    public void setBorderPixels(int border) {
        this.borderPixels = border;
    }

    public int getBorderPixels() {
        return this.borderPixels;
    }

    protected boolean hasBbox() {
        return true;
    }

    protected boolean hasChar() {
        return this.hasChar;
    }

    protected Font getGeneFont() {
        return this.geneFont;
    }

    public void setGeneFont(Font f) {
        if (f != null) {
            this.geneFont = f;
        }
    }

    protected Font getArrayFont() {
        return this.arrayFont;
    }

    public void setArrayFont(Font f) {
        if (f != null) {
            this.arrayFont = f;
        }
    }

    protected boolean includeBbox() {
        return this.inclusionPanel.useBbox();
    }

    protected double getMinGeneCorr() {
        if (this.drawSelected()) {
            TreeSelectionI selection = this.getGeneSelection();
            String selectedId = selection.getSelectedNode();
            TreeDrawerNode selectedNode = this.geneTreeDrawer.getNodeById(selectedId);
            return selectedNode.getCorr();
        }
        return this.geneTreeDrawer.getCorrMin();
    }

    protected double getMinArrayCorr() {
        if (this.drawSelected()) {
            return this.arrayTreeDrawer.getNodeById(this.getArraySelection().getSelectedNode()).getCorr();
        }
        return this.arrayTreeDrawer.getCorrMin();
    }

    protected int getYmapPixel(double geneIndex) {
        double dp = this.geneMap.getPixel(geneIndex) - this.geneMap.getPixel(0);
        double ret = (int)(dp * this.getYscale() / this.geneMap.getScale());
        return (int)ret;
    }

    protected int getXmapPixel(double geneIndex) {
        double dp = this.arrayMap.getPixel(geneIndex) - this.arrayMap.getPixel(0);
        int ret = (int)(dp * this.getXscale() / this.arrayMap.getScale());
        return ret;
    }

    protected boolean geneAnnoInside() {
        return this.headerSelectionPanel.geneAnnoInside();
    }

    protected boolean arrayAnnoInside() {
        return this.headerSelectionPanel.arrayAnnoInside();
    }

    protected String getGeneAnno(int i) {
        return this.headerSelectionPanel.getGeneAnno(i);
    }

    protected String getArrayAnno(int i) {
        return this.headerSelectionPanel.getArrayAnno(i);
    }

    private Color getFgColor(HeaderInfo headerInfo, int index) {
        int colorIndex = headerInfo.getIndex("FGCOLOR");
        if (colorIndex > 0) {
            String[] headers = headerInfo.getHeader(index);
            return TreeColorer.getColor(headers[colorIndex]);
        }
        return null;
    }

    private Color getBgColor(HeaderInfo headerInfo, int index) {
        int colorIndex = headerInfo.getIndex("BGCOLOR");
        if (colorIndex > 0) {
            String[] headers = headerInfo.getHeader(index);
            return TreeColorer.getColor(headers[colorIndex]);
        }
        return null;
    }

    protected Color getGeneFgColor(int i) {
        return this.getFgColor(this.geneHeaderInfo, i);
    }

    protected Color getArrayFgColor(int i) {
        return this.getFgColor(this.arrayHeaderInfo, i);
    }

    protected Color getGeneBgColor(int i) {
        return this.getBgColor(this.geneHeaderInfo, i);
    }

    protected Color getArrayBgColor(int i) {
        return this.getBgColor(this.arrayHeaderInfo, i);
    }

    protected TreeDrawerNode getGeneNode() {
        if (this.inclusionPanel.drawSelected()) {
            return this.geneTreeDrawer.getNodeById(this.geneSelection.getSelectedNode());
        }
        return this.getGeneRootNode();
    }

    protected TreeDrawerNode getArrayNode() {
        if (this.inclusionPanel.drawSelected()) {
            return this.arrayTreeDrawer.getNodeById(this.arraySelection.getSelectedNode());
        }
        return this.getArrayRootNode();
    }

    protected File getFile() {
        if (this.appendExt.isSelected()) {
            this.appendExtension();
        }
        return this.filePanel.getFile();
    }

    public String getFilePath() {
        if (this.appendExt.isSelected()) {
            this.appendExtension();
        }
        return this.filePanel.getFilePath();
    }

    public void setFilePath(String newFile) {
        this.filePanel.setFilePath(newFile);
    }

    protected TreeDrawerNode getGeneRootNode() {
        if (this.geneTreeDrawer == null) {
            return null;
        }
        return this.geneTreeDrawer.getRootNode();
    }

    protected TreeDrawerNode getArrayRootNode() {
        if (this.arrayTreeDrawer == null) {
            return null;
        }
        return this.arrayTreeDrawer.getRootNode();
    }

    protected String getInitialExtension() {
        return ".png";
    }

    protected String getInitialFilePath() {
        String defaultPath = System.getProperty("user.home");
        String fileSep = System.getProperty("file.separator");
        String file = this.model.getSource();
        if (this.root == null) {
            return defaultPath + fileSep + file;
        }
        return this.root.getAttribute("file", defaultPath) + fileSep + file;
    }

    public void setIncludedGeneHeaders(int[] newSelected) {
        this.headerSelectionPanel.geneList.setSelectedIndices(newSelected);
        this.headerSelectionPanel.setupSelected();
    }

    public void setIncludedArrayHeaders(int[] newSelected) {
        this.headerSelectionPanel.arrayList.setSelectedIndices(newSelected);
        this.headerSelectionPanel.setupSelected();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public ConfigNode createSubNode() {
        return this.root.create("File");
    }

    private void setupWidgets() {
        Box upperPanel = new Box(0);
        this.headerSelectionPanel = new HeaderSelectionPanel();
        upperPanel.add(this.headerSelectionPanel);
        this.inclusionPanel = new InclusionPanel();
        upperPanel.add(this.inclusionPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(upperPanel);
        this.filePanel = new FilePanel(this.getInitialFilePath());
        this.add(this.filePanel);
        JPanel formatPanel = new JPanel();
        this.formatPullDown = new JComboBox<String>(this.formats);
        this.appendExt = new JCheckBox("Append Extension?", true);
        formatPanel.add(new JLabel("Graphics Format:"));
        formatPanel.add(this.formatPullDown);
        formatPanel.add(this.appendExt);
        this.add(formatPanel);
    }

    private void appendExtension() {
        int dirIndex;
        String fileName = this.filePanel.getFilePath();
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex > (dirIndex = fileName.lastIndexOf(File.separatorChar))) {
            this.setFilePath(fileName.substring(0, extIndex) + "." + this.formatPullDown.getSelectedItem());
        } else {
            this.setFilePath(fileName + "." + this.formatPullDown.getSelectedItem());
        }
    }

    protected boolean includeAtr() {
        return this.inclusionPanel.includeAtr();
    }

    protected void includeAtr(boolean flag) {
        this.inclusionPanel.includeAtr(flag);
    }

    protected boolean includeGtr() {
        return this.inclusionPanel.includeGtr();
    }

    protected void includeGtr(boolean flag) {
        this.inclusionPanel.includeGtr(flag);
    }

    protected boolean includeData() {
        return this.inclusionPanel.includeData();
    }

    private boolean includeChar() {
        return this.inclusionPanel.includeChar();
    }

    protected void includeData(boolean flag) {
        this.inclusionPanel.includeData(flag);
    }

    protected boolean drawSelected() {
        return this.inclusionPanel.drawSelected();
    }

    protected boolean includeGeneMap() {
        return this.includeGtr() || this.includeData() || this.numGeneHeaders() > 0;
    }

    protected boolean includeArrayMap() {
        return this.includeAtr() || this.includeData() || this.numArrayHeaders() > 0;
    }

    public double getXmapWidth() {
        return (int)((double)(this.arrayMap.getPixel(this.maxArray() + 1) - this.arrayMap.getPixel(this.minArray())) * this.getXscale() / this.arrayMap.getScale());
    }

    public double getGtrWidth() {
        return 200.0 * this.getXscale() / this.arrayMap.getScale();
    }

    public double getXscale() {
        return this.inclusionPanel.getXscale();
    }

    public double getYmapHeight() {
        double ret = (double)(this.geneMap.getPixel(this.maxGene() + 1) - this.geneMap.getPixel(this.minGene())) * this.getYscale() / this.geneMap.getScale();
        return ret;
    }

    public double getAtrHeight() {
        return 100.0;
    }

    public double getYscale() {
        return this.inclusionPanel.getYscale();
    }

    public int getBboxWidth() {
        return this.inclusionPanel.getBboxWidth();
    }

    public int getBboxHeight() {
        return this.inclusionPanel.getBboxHeight();
    }

    public int minGene() {
        if (this.inclusionPanel.drawSelected()) {
            return this.geneSelection.getMinIndex();
        }
        return 0;
    }

    public int minArray() {
        if (this.inclusionPanel.drawSelected()) {
            return this.arraySelection.getMinIndex();
        }
        return 0;
    }

    public int maxGene() {
        if (this.inclusionPanel.drawSelected()) {
            return this.geneSelection.getMaxIndex();
        }
        return this.geneHeaderInfo.getNumHeaders() - 1;
    }

    public int maxArray() {
        if (this.inclusionPanel.drawSelected()) {
            return this.arraySelection.getMaxIndex();
        }
        return this.arrayHeaderInfo.getNumHeaders() - 1;
    }

    public int estimateHeight() {
        int height = 2 * this.getBorderPixels();
        if (this.includeGeneMap()) {
            height += (int)this.getYmapHeight();
        }
        if (this.includeAtr()) {
            height += (int)this.getAtrHeight();
        }
        return height += this.getArrayAnnoLength();
    }

    public int estimateWidth() {
        int width = 2 * this.getBorderPixels();
        if (this.includeArrayMap()) {
            width += (int)this.getXmapWidth();
        }
        if (this.includeGtr()) {
            width += (int)this.getGtrWidth();
        }
        return width += this.getGeneAnnoLength();
    }

    protected int getGeneAnnoLength() {
        if (this.inclusionPanel == null || !this.inclusionPanel.useBbox()) {
            return this.headerSelectionPanel.geneMaxLength() + textSpacing;
        }
        return this.getBboxWidth();
    }

    protected int getArrayAnnoLength() {
        if (this.inclusionPanel == null || !this.inclusionPanel.useBbox()) {
            return this.headerSelectionPanel.arrayMaxLength() + textSpacing;
        }
        return this.getBboxHeight();
    }

    public int numArrayHeaders() {
        return this.headerSelectionPanel.numArrayHeaders();
    }

    public int numGeneHeaders() {
        return this.headerSelectionPanel.numGeneHeaders();
    }

    public void deselectHeaders() {
        this.headerSelectionPanel.deselectHeaders();
    }

    protected int getDataX() {
        int dataX = this.getBorderPixels();
        if (this.includeGtr()) {
            dataX = (int)((double)dataX + this.getGtrWidth());
        }
        return dataX;
    }

    protected int getDataY() {
        int dataY = this.getBorderPixels();
        if (this.includeAtr()) {
            dataY = (int)((double)dataY + this.getAtrHeight());
        }
        return dataY += this.getArrayAnnoLength();
    }

    public void drawAll(Graphics g, double scale) {
        int width = this.estimateWidth();
        int height = this.estimateHeight();
        if (width == 0 || height == 0) {
            return;
        }
        int dataX = (int)(scale * (double)this.getDataX());
        int dataY = (int)(scale * (double)this.getDataY());
        int scaleP = (int)(scale * (double)this.getBorderPixels());
        this.drawGtr(g, scaleP, dataY, scale);
        if (this.includeAtr()) {
            if (this.arrayAnnoInside()) {
                this.drawAtr(g, dataX, scaleP, scale);
                this.drawArrayAnno(g, dataX, scaleP + (int)(scale * this.getAtrHeight()), scale);
            } else {
                this.drawArrayAnno(g, dataX, scaleP, scale);
                this.drawAtr(g, dataX, dataY - (int)(scale * this.getAtrHeight()), scale);
            }
        } else {
            this.drawArrayAnno(g, dataX, scaleP, scale);
        }
        this.drawData(g, dataX, dataY, scale);
        if (this.includeArrayMap()) {
            this.drawGeneAnno(g, dataX + (int)(this.getXmapWidth() * scale), dataY, scale);
        } else {
            this.drawGeneAnno(g, dataX, dataY, scale);
        }
    }

    protected void drawGtr(Graphics g, int x, int y, double scale) {
        if (!this.includeGtr()) {
            return;
        }
        int width = (int)(this.getGtrWidth() * scale);
        int height = (int)(this.getYmapHeight() * scale);
        if (height == 0 || width == 0) {
            return;
        }
        g.setColor(Color.black);
        java.awt.Rectangle destRect = new java.awt.Rectangle();
        destRect.setBounds(x, y, width, height);
        double minCorr = this.getMinGeneCorr();
        LinearTransformation xScaleEq = new LinearTransformation(minCorr, destRect.x, this.geneTreeDrawer.getCorrMax(), destRect.x + destRect.width);
        LinearTransformation yScaleEq = new LinearTransformation(this.minGene(), destRect.y, this.maxGene() + 1, destRect.y + destRect.height);
        this.geneTreeDrawer.paintSubtree(g, xScaleEq, yScaleEq, destRect, this.getGeneNode(), false);
    }

    protected void drawAtr(Graphics g, int x, int y, double scale) {
        if (!this.includeAtr()) {
            return;
        }
        int width = (int)(this.getXmapWidth() * scale);
        int height = (int)(this.getAtrHeight() * scale);
        if (height == 0 || width == 0) {
            return;
        }
        g.setColor(Color.black);
        java.awt.Rectangle destRect = new java.awt.Rectangle();
        destRect.setBounds(x, y, width, height);
        LinearTransformation xScaleEq = new LinearTransformation(this.minArray(), destRect.x, this.maxArray() + 1, destRect.x + destRect.width);
        double minCorr = this.arrayTreeDrawer.getCorrMin();
        if (this.drawSelected()) {
            minCorr = this.arrayTreeDrawer.getNodeById(this.getArraySelection().getSelectedNode()).getCorr();
        }
        LinearTransformation yScaleEq = new LinearTransformation(minCorr, destRect.y, this.arrayTreeDrawer.getCorrMax(), destRect.y + destRect.height);
        this.arrayTreeDrawer.paintSubtree(g, xScaleEq, yScaleEq, destRect, this.getArrayNode(), false);
    }

    protected void drawGeneAnnoBox(Graphics g, int x, int y, double scale) {
        int width = (int)((double)this.getGeneAnnoLength() * scale);
        int height = (int)(this.getYmapHeight() * scale);
        g.setColor(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(this.getGeneFont());
        int geneHeight = (int)((double)fontMetrics.getAscent() * scale);
        int min = this.minGene();
        int max = this.maxGene();
        double spacing = (double)height / (double)(max - min + 1);
        for (int i = min; i <= max; ++i) {
            int geneWidth = width;
            g.fillRect(x, y + (int)((double)(i - min) * spacing + (spacing - (double)geneHeight) / 2.0), geneWidth, geneHeight);
        }
    }

    public void drawArrayAnnoBox(Graphics g, int x, int y, double scale) {
        int height = (int)((double)this.getArrayAnnoLength() * scale);
        int width = (int)(this.getXmapWidth() * scale);
        g.setColor(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(this.getArrayFont());
        int arrayWidth = (int)((double)fontMetrics.getAscent() * scale);
        int min = this.minArray();
        int max = this.maxArray();
        double spacing = (double)width / (double)(max - min + 1);
        for (int i = min; i <= max; ++i) {
            int arrayHeight = height;
            int thisx = x + (int)((double)(i - min) * spacing + (spacing - (double)arrayWidth) / 2.0);
            int thisy = y + height - arrayHeight;
            if (this.headerSelectionPanel.arrayAnnoInside()) {
                thisy = y;
            }
            g.fillRect(thisx, thisy, arrayWidth, arrayHeight);
        }
    }

    protected void drawGeneAnno(Graphics g, int x, int y, double scale) {
        int width = (int)((double)this.getGeneAnnoLength() * scale);
        int height = (int)(this.getYmapHeight() * scale);
        if (height == 0 || width == 0) {
            return;
        }
        int min = this.minGene();
        int max = this.maxGene();
        double spacing = (double)height / (double)(max - min + 1);
        MapContainer tempMap = new MapContainer("Fixed");
        tempMap.setScale(spacing);
        tempMap.setIndexRange(min, max);
        tempMap.setAvailablePixels(height + this.getBorderPixels());
        TextView anv = new TextView(this.geneHeaderInfo);
        anv.setMap(tempMap);
        anv.setHeaderSummary(this.headerSelectionPanel.getGeneSummary());
        anv.setFace(this.getGeneFont().getName());
        anv.setStyle(this.getGeneFont().getStyle());
        anv.setPoints((int)spacing);
        anv.updateBuffer(g, new java.awt.Rectangle(x + textSpacing, y, width + this.getBorderPixels(), height + this.getBorderPixels()));
    }

    public void drawArrayAnno(Graphics real, int x, int y, double scale) {
        int height = (int)((double)this.getArrayAnnoLength() * scale);
        int width = (int)(this.getXmapWidth() * scale);
        if (height == 0 || width == 0) {
            return;
        }
        int min = this.minArray();
        int max = this.maxArray();
        double spacing = (double)width / (double)(max - min + 1);
        MapContainer tempMap = new MapContainer("Fixed");
        tempMap.setScale(spacing);
        tempMap.setIndexRange(min, max);
        tempMap.setAvailablePixels(width + this.getBorderPixels());
        ArrayNameView anv = new ArrayNameView(this.arrayHeaderInfo);
        anv.setFace(this.getArrayFont().getName());
        anv.setStyle(this.getArrayFont().getStyle());
        anv.setPoints((int)spacing);
        anv.setHeaderSummary(this.headerSelectionPanel.getArraySummary());
        anv.setMapping(tempMap);
        anv.updateBuffer(real, new java.awt.Rectangle(x, y - this.getBorderPixels() - textSpacing, width + this.getBorderPixels(), height + this.getBorderPixels()));
    }

    public void drawData(Graphics g, int x, int y, double scale) {
        if (!this.includeData()) {
            return;
        }
        int height = (int)(this.getYmapHeight() * scale);
        int width = (int)(this.getXmapWidth() * scale);
        java.awt.Rectangle sourceRect = new java.awt.Rectangle();
        sourceRect.setBounds(this.minArray(), this.minGene(), this.maxArray() + 1 - this.minArray(), this.maxGene() + 1 - this.minGene());
        java.awt.Rectangle destRect = new java.awt.Rectangle();
        destRect.setBounds(0, 0, width, height);
        int[] pixels = new int[width * height];
        this.arrayDrawer.paint(pixels, sourceRect, destRect, width);
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image image = this.createImage(source);
        g.drawImage(image, x, y, null);
        if (this.includeChar()) {
            try {
                Image cimage = this.createImage(width, height);
                cimage.getGraphics().drawImage(image, 0, 0, null);
                ((CharArrayDrawer)this.arrayDrawer).paintChars(cimage.getGraphics(), sourceRect, destRect);
                g.drawImage(cimage, x, y, null);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Problem drawing Sequence data:" + e);
                g.drawImage(image, x, y, null);
            }
        } else {
            g.drawImage(image, x, y, null);
        }
    }

    public boolean getDrawSelected() {
        return this.selectionBox.isSelected();
    }

    public void setDrawSelected(boolean bool) {
        this.selectionBox.setSelected(bool);
    }

    private void bitmapSave(String format) {
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            int extraWidth = this.getBorderPixels();
            int extraHeight = this.getBorderPixels();
            java.awt.Rectangle destRect = new java.awt.Rectangle(0, 0, this.estimateWidth(), this.estimateHeight());
            BufferedImage i = new BufferedImage(destRect.width + extraWidth, destRect.height + extraHeight, 2);
            Graphics g = i.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, destRect.width + 1 + extraWidth, destRect.height + 1 + extraHeight);
            g.setColor(Color.black);
            g.translate(extraHeight / 2, extraWidth / 2);
            this.drawAll(g, 1.0);
            ImageIO.write((RenderedImage)i, format, output);
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new JTextArea("Graphics export had problem " + e));
        }
    }

    private void pdfSave(String format) {
        Rectangle pageSize = PageSize.LETTER;
        Document document = new Document(pageSize);
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)output);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g = cb.createGraphics(pageSize.getWidth(), pageSize.getHeight(), (FontMapper)new DefaultFontMapper());
            double imageScale = Math.min((double)pageSize.getWidth() / ((double)this.estimateWidth() + (double)this.getBorderPixels()), (double)pageSize.getHeight() / ((double)this.estimateHeight() + (double)this.getBorderPixels()));
            g.scale(imageScale, imageScale);
            this.drawAll(g, 1.0);
            g.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new JTextArea("Dendrogram export had problem " + e));
        }
        document.close();
    }

    private void epsSave(String format) {
        Rectangle pageSize = PageSize.LETTER;
        Properties p = new Properties();
        p.setProperty(PSGraphics2D.PAGE_SIZE, "Letter");
        p.setProperty("org.freehep.graphicsio.AbstractVectorGraphicsIO.TEXT_AS_SHAPES", Boolean.toString(false));
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            PSGraphics2D g = new PSGraphics2D((OutputStream)output, (Component)this.view);
            double imageScale = Math.min((double)pageSize.getWidth() / ((double)this.estimateWidth() + (double)this.getBorderPixels()), (double)pageSize.getHeight() / ((double)this.estimateHeight() + (double)this.getBorderPixels()));
            g.setMultiPage(false);
            g.setProperties(p);
            g.startExport();
            g.scale(imageScale, imageScale);
            this.drawAll((Graphics)g, 1.0);
            g.endExport();
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new JTextArea("Dendrogram export had problem " + e));
        }
    }

    private void svgSave(String format) {
        Rectangle pageSize = PageSize.LETTER;
        Properties p = new Properties();
        p.setProperty(PSGraphics2D.PAGE_SIZE, "Letter");
        p.setProperty("org.freehep.graphicsio.AbstractVectorGraphicsIO.TEXT_AS_SHAPES", Boolean.toString(false));
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            SVGGraphics2D g = new SVGGraphics2D((OutputStream)output, (Component)this.view);
            double imageScale = Math.min((double)pageSize.getWidth() / ((double)this.estimateWidth() + (double)this.getBorderPixels()), (double)pageSize.getHeight() / ((double)this.estimateHeight() + (double)this.getBorderPixels()));
            g.setProperties(p);
            g.startExport();
            g.scale(imageScale, imageScale);
            this.drawAll((Graphics)g, 1.0);
            g.endExport();
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new JTextArea("Dendrogram export had problem " + e));
        }
    }

    class FilePanel
    extends JPanel {
        private JTextField fileField;

        String getFilePath() {
            return this.fileField.getText();
        }

        File getFile() {
            return new File(this.getFilePath());
        }

        void setFilePath(String fp) {
            this.fileField.setText(fp);
            this.fileField.invalidate();
            this.fileField.revalidate();
            this.fileField.repaint();
        }

        public FilePanel(String initial) {
            this.add(new JLabel("Export To: "));
            this.fileField = new JTextField(initial);
            this.add(this.fileField);
            JButton chooseButton = new JButton("Browse");
            chooseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JFileChooser chooser = new JFileChooser();
                        int returnVal = chooser.showSaveDialog(GraphicsExportPanel.this);
                        if (returnVal == 0) {
                            FilePanel.this.fileField.setText(chooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.add(chooseButton);
        }
    }

    class HeaderSelectionPanel
    extends JPanel {
        private JCheckBox geneAnnoInside;
        private JCheckBox arrayAnnoInside;
        private HeaderSummary geneSummary = new HeaderSummary();
        private HeaderSummary arraySummary = new HeaderSummary();
        public JList geneList;
        public JList arrayList;

        public HeaderSummary getGeneSummary() {
            return this.geneSummary;
        }

        public HeaderSummary getArraySummary() {
            return this.arraySummary;
        }

        public String getGeneAnno(int i) {
            return this.geneSummary.getSummary(GraphicsExportPanel.this.geneHeaderInfo, i);
        }

        public String getArrayAnno(int i) {
            return this.arraySummary.getSummary(GraphicsExportPanel.this.arrayHeaderInfo, i);
        }

        public int arrayMaxLength() {
            if (GraphicsExportPanel.this.inclusionPanel == null) {
                return 100;
            }
            FontMetrics fontMetrics = this.getFontMetrics(GraphicsExportPanel.this.getArrayFont());
            int max = 0;
            boolean drawSelected = GraphicsExportPanel.this.inclusionPanel.drawSelected();
            for (int i = GraphicsExportPanel.this.minArray(); i < GraphicsExportPanel.this.maxArray(); ++i) {
                int length;
                String anno;
                if (drawSelected && !GraphicsExportPanel.this.arraySelection.isIndexSelected(i) || (anno = this.getArrayAnno(i)) == null || (length = fontMetrics.stringWidth(anno)) <= max) continue;
                max = length;
            }
            return max;
        }

        public int geneMaxLength() {
            if (GraphicsExportPanel.this.inclusionPanel == null) {
                return 100;
            }
            FontMetrics fontMetrics = this.getFontMetrics(GraphicsExportPanel.this.getGeneFont());
            int max = 0;
            boolean drawSelected = GraphicsExportPanel.this.inclusionPanel.drawSelected();
            for (int i = GraphicsExportPanel.this.minGene(); i < GraphicsExportPanel.this.maxGene(); ++i) {
                int length;
                if (this.getGeneAnno(i) == null || (length = fontMetrics.stringWidth(this.getGeneAnno(i))) <= max) continue;
                max = length;
            }
            return max;
        }

        public int getLength(String txt) {
            if (txt == null) {
                return 0;
            }
            FontMetrics fontMetrics = this.getFontMetrics(GraphicsExportPanel.this.getGeneFont());
            return fontMetrics.stringWidth(txt);
        }

        public int numArrayHeaders() {
            return this.arrayList.getSelectedIndices().length;
        }

        public int numGeneHeaders() {
            return this.geneList.getSelectedIndices().length;
        }

        public void deselectHeaders() {
            this.arrayList.clearSelection();
            this.geneList.clearSelection();
        }

        public boolean geneAnnoInside() {
            return this.geneAnnoInside.isSelected();
        }

        public boolean arrayAnnoInside() {
            return this.arrayAnnoInside.isSelected();
        }

        public void addNotify() {
            super.addNotify();
            GraphicsExportPanel.this.inclusionPanel.recalculateBbox();
        }

        HeaderSelectionPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel("Gene Headers"));
            String[] geneHeaders = GraphicsExportPanel.this.geneHeaderInfo.getNames();
            this.geneList = geneHeaders == null ? new JList<String>(new String[0]) : new JList<String>(geneHeaders);
            this.geneList.setVisibleRowCount(5);
            this.add(new JScrollPane(this.geneList));
            this.geneAnnoInside = new JCheckBox("Right of Tree?");
            this.add(new JLabel("Array Headers"));
            String[] arrayHeaders = GraphicsExportPanel.this.arrayHeaderInfo.getNames();
            this.arrayList = arrayHeaders == null ? new JList<String>(new String[0]) : new JList<String>(arrayHeaders);
            this.arrayList.setVisibleRowCount(5);
            this.add(new JScrollPane(this.arrayList));
            this.arrayAnnoInside = new JCheckBox("Below Tree?");
            this.arrayAnnoInside.setSelected(true);
            this.arrayAnnoInside.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GraphicsExportPanel.this.inclusionPanel.updateSize();
                }
            });
            this.add(this.arrayAnnoInside);
            ListSelectionListener tmp = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (GraphicsExportPanel.this.inclusionPanel != null) {
                        GraphicsExportPanel.this.inclusionPanel.recalculateBbox();
                        GraphicsExportPanel.this.inclusionPanel.updateSize();
                        HeaderSelectionPanel.this.geneSummary.setIncluded(HeaderSelectionPanel.this.geneList.getSelectedIndices());
                        HeaderSelectionPanel.this.arraySummary.setIncluded(HeaderSelectionPanel.this.arrayList.getSelectedIndices());
                    }
                }
            };
            this.geneList.addListSelectionListener(tmp);
            this.arrayList.addListSelectionListener(tmp);
            this.arrayList.setSelectedIndex(0);
            this.geneList.setSelectedIndex(1);
            this.setupSelected();
        }

        public void setupSelected() {
            this.geneSummary.setIncluded(this.geneList.getSelectedIndices());
            this.arraySummary.setIncluded(this.arrayList.getSelectedIndices());
            if (GraphicsExportPanel.this.inclusionPanel != null) {
                GraphicsExportPanel.this.inclusionPanel.updateSize();
            }
        }
    }

    class InclusionPanel
    extends JPanel {
        JCheckBox gtrBox;
        JCheckBox atrBox;
        JCheckBox dataBox;
        JCheckBox bboxBox;
        JCheckBox charBox;
        JTextField xScaleField;
        JTextField yScaleField;
        JTextField borderField;
        BboxRow bboxRow;
        SizeRow sizeRow;
        DocumentListener documentListener = null;

        public boolean useBbox() {
            return this.bboxBox.isSelected();
        }

        public boolean includeAtr() {
            return this.atrBox.isSelected();
        }

        public void includeAtr(boolean flag) {
            this.atrBox.setSelected(flag);
        }

        public boolean includeGtr() {
            return this.gtrBox.isSelected();
        }

        public void includeGtr(boolean flag) {
            this.gtrBox.setSelected(flag);
        }

        public boolean includeData() {
            return this.dataBox.isSelected();
        }

        public boolean includeChar() {
            if (this.charBox == null) {
                return false;
            }
            boolean isSelected = this.charBox.isSelected();
            return isSelected;
        }

        public void includeData(boolean flag) {
            this.dataBox.setSelected(flag);
        }

        public double getXscale() {
            return this.extractDouble(this.xScaleField.getText());
        }

        public double getYscale() {
            return this.extractDouble(this.yScaleField.getText());
        }

        public int getBorderPixels() {
            return (int)this.extractDouble(this.borderField.getText());
        }

        private double extractDouble(String text) {
            try {
                Double tmp = new Double(text);
                return tmp;
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        public int getBboxWidth() {
            return this.bboxRow.xSize();
        }

        public int getBboxHeight() {
            return this.bboxRow.ySize();
        }

        public boolean drawSelected() {
            return GraphicsExportPanel.this.selectionBox.isSelected();
        }

        public void synchEnabled() {
            GraphicsExportPanel.this.selectionBox.setEnabled(GraphicsExportPanel.this.geneSelection.getNSelectedIndexes() != 0 || GraphicsExportPanel.this.arraySelection.getNSelectedIndexes() != 0);
            this.bboxRow.setEnabled(this.bboxBox.isSelected());
            if (GraphicsExportPanel.this.getArrayRootNode() == null) {
                this.atrBox.setSelected(false);
                this.atrBox.setEnabled(false);
            } else if (GraphicsExportPanel.this.selectionBox.isSelected()) {
                if (GraphicsExportPanel.this.arraySelection.getSelectedNode() == null) {
                    this.atrBox.setSelected(false);
                    this.atrBox.setEnabled(false);
                } else {
                    this.atrBox.setEnabled(true);
                }
            } else {
                this.atrBox.setEnabled(true);
            }
            if (GraphicsExportPanel.this.getGeneRootNode() == null) {
                this.gtrBox.setSelected(false);
                this.gtrBox.setEnabled(false);
            } else if (GraphicsExportPanel.this.selectionBox.isSelected()) {
                if (GraphicsExportPanel.this.geneSelection.getSelectedNode() == null) {
                    this.gtrBox.setSelected(false);
                    this.gtrBox.setEnabled(false);
                } else {
                    this.gtrBox.setEnabled(true);
                }
            } else {
                this.gtrBox.setEnabled(true);
            }
            if (GraphicsExportPanel.this.arrayDrawer == null) {
                this.dataBox.setSelected(false);
                this.dataBox.setEnabled(false);
            }
            this.updateSize();
        }

        public void synchSelected() {
            GraphicsExportPanel.this.selectionBox.setSelected(GraphicsExportPanel.this.geneSelection.getNSelectedIndexes() != 0 || GraphicsExportPanel.this.arraySelection.getNSelectedIndexes() != 0);
            if (GraphicsExportPanel.this.selectionBox.isSelected()) {
                this.atrBox.setSelected(GraphicsExportPanel.this.arraySelection.getSelectedNode() != null);
                this.gtrBox.setSelected(GraphicsExportPanel.this.geneSelection.getSelectedNode() != null);
            } else {
                this.atrBox.setSelected(GraphicsExportPanel.this.getArrayRootNode() != null);
                this.gtrBox.setSelected(GraphicsExportPanel.this.getGeneRootNode() != null);
            }
            this.dataBox.setSelected(GraphicsExportPanel.this.arrayDrawer != null);
            this.updateSize();
        }

        public void recalculateBbox() {
            if (GraphicsExportPanel.this.headerSelectionPanel == null) {
                this.bboxRow.setXsize(2);
                this.bboxRow.setYsize(2);
            } else {
                this.bboxRow.setXsize(GraphicsExportPanel.this.headerSelectionPanel.geneMaxLength());
                this.bboxRow.setYsize(GraphicsExportPanel.this.headerSelectionPanel.arrayMaxLength());
            }
        }

        public void updateSize() {
            try {
                this.sizeRow.setXsize(GraphicsExportPanel.this.estimateWidth());
                this.sizeRow.setYsize(GraphicsExportPanel.this.estimateHeight());
                GraphicsExportPanel.this.setBorderPixels(this.getBorderPixels());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        InclusionPanel() {
            this.documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    InclusionPanel.this.updateSize();
                }

                public void insertUpdate(DocumentEvent e) {
                    InclusionPanel.this.updateSize();
                }

                public void removeUpdate(DocumentEvent e) {
                    InclusionPanel.this.updateSize();
                }
            };
            this.setupWidgets();
            this.recalculateBbox();
        }

        private void setupWidgets() {
            this.setLayout(new BoxLayout(this, 1));
            ActionListener syncher = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InclusionPanel.this.synchEnabled();
                }
            };
            this.add(new JLabel("Include"));
            GraphicsExportPanel.this.selectionBox = new JCheckBox("Selection Only     ");
            GraphicsExportPanel.this.selectionBox.addActionListener(syncher);
            JPanel outputPanel = new JPanel();
            outputPanel.add(GraphicsExportPanel.this.selectionBox);
            this.add(outputPanel);
            this.gtrBox = !GraphicsExportPanel.this.model.isSymmetrical() ? new JCheckBox("Node Tree     ") : new JCheckBox("Left Node Tree");
            this.gtrBox.addActionListener(syncher);
            outputPanel = new JPanel();
            outputPanel.add(this.gtrBox);
            this.add(outputPanel);
            this.atrBox = !GraphicsExportPanel.this.model.isSymmetrical() ? new JCheckBox("Attribute Tree") : new JCheckBox("Top Node Tree ");
            this.atrBox.addActionListener(syncher);
            outputPanel = new JPanel();
            outputPanel.add(this.atrBox);
            this.add(outputPanel);
            this.dataBox = new JCheckBox("Heat Map       ");
            this.dataBox.addActionListener(syncher);
            outputPanel = new JPanel();
            outputPanel.add(this.dataBox);
            this.add(outputPanel);
            if (GraphicsExportPanel.this.hasChar) {
                this.charBox = new JCheckBox("Sequence");
                this.charBox.addActionListener(syncher);
                outputPanel = new JPanel();
                outputPanel.add(this.charBox);
                this.add(outputPanel);
            }
            JPanel scalePanel = new JPanel();
            scalePanel.setLayout(new BoxLayout(scalePanel, 1));
            JPanel Xsub = new JPanel();
            this.xScaleField = new JTextField(Double.toString(GraphicsExportPanel.this.arrayMap.getScale()));
            Xsub.add(new JLabel("x scale"));
            Xsub.add(this.xScaleField);
            scalePanel.add(Xsub);
            double yScale = GraphicsExportPanel.this.geneMap.getScale();
            this.yScaleField = new JTextField(Double.toString(yScale));
            JPanel Ysub = new JPanel();
            Ysub.add(new JLabel("y scale"));
            Ysub.add(this.yScaleField);
            scalePanel.add(Ysub);
            this.borderField = new JTextField(Double.toString(GraphicsExportPanel.this.getBorderPixels()));
            JPanel Bsub = new JPanel();
            Bsub.add(new JLabel("Border "));
            Bsub.add(this.borderField);
            scalePanel.add(Bsub);
            scalePanel.add(new JLabel("Use apple key to select multiple headers"));
            this.add(scalePanel);
            this.xScaleField.getDocument().addDocumentListener(this.documentListener);
            this.yScaleField.getDocument().addDocumentListener(this.documentListener);
            this.borderField.getDocument().addDocumentListener(this.documentListener);
            this.bboxBox = new JCheckBox("Bounding Box?", GraphicsExportPanel.this.hasBbox());
            this.bboxBox.addActionListener(syncher);
            outputPanel = new JPanel();
            outputPanel.add(this.bboxBox);
            this.bboxRow = new BboxRow();
            if (GraphicsExportPanel.this.hasBbox()) {
                this.add(outputPanel);
                this.add(this.bboxRow);
            }
            this.sizeRow = new SizeRow();
            this.add(this.sizeRow);
        }

        class SizeRow
        extends JPanel {
            JTextField xSize;
            JTextField ySize;
            double conversionFactor = 1.0;

            public SizeRow() {
                this.setupWidgets();
            }

            protected void setupWidgets() {
                this.add(new JLabel("Total Size:"));
                this.xSize = new JTextField("2", 5);
                this.ySize = new JTextField("2", 5);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(pixels)"));
            }

            int xSize() {
                return (int)(InclusionPanel.this.extractDouble(this.xSize.getText()) * this.conversionFactor);
            }

            int ySize() {
                return (int)(InclusionPanel.this.extractDouble(this.ySize.getText()) * this.conversionFactor);
            }

            void setXsize(int points) {
                this.xSize.setText(this.convert(points));
            }

            void setYsize(int points) {
                this.ySize.setText(this.convert(points));
            }

            private String convert(int points) {
                Double inch = new Double(Math.rint((double)points * 100.0 / this.conversionFactor) / 100.0);
                return inch.toString();
            }

            public void setEnabled(boolean flag) {
                super.setEnabled(flag);
                this.xSize.setEnabled(flag);
                this.ySize.setEnabled(flag);
            }
        }

        class BboxRow
        extends SizeRow {
            BboxRow() {
            }

            protected void setupWidgets() {
                DocumentListener documentListener = new DocumentListener(){

                    public void changedUpdate(DocumentEvent e) {
                        InclusionPanel.this.updateSize();
                    }

                    public void insertUpdate(DocumentEvent e) {
                        InclusionPanel.this.updateSize();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        InclusionPanel.this.updateSize();
                    }
                };
                this.add(new JLabel("BBox size:"));
                this.xSize = new JTextField("2", 4);
                this.ySize = new JTextField("2", 4);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(pixels)"));
                this.xSize.getDocument().addDocumentListener(documentListener);
                this.ySize.getDocument().addDocumentListener(documentListener);
            }
        }
    }
}

