/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DummyConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.FillMap;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.FixedMap;

public abstract class IntegerMap
implements ConfigNodePersistent {
    protected int availablepixels = 0;
    protected int maxindex = -1;
    protected int minindex = -1;
    protected ConfigNode root = new DummyConfigNode(this.type());

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.root.setAttribute("type", this.type(), null);
    }

    IntegerMap createMap(String string) {
        if (string.equals("Fixed")) {
            return new FixedMap();
        }
        if (string.equals("Fill")) {
            return new FillMap();
        }
        System.out.println(string + " not found");
        return null;
    }

    public int getAvailablePixels() {
        return this.availablepixels;
    }

    public abstract int getIndex(int var1);

    public int getMaxIndex() {
        return this.maxindex;
    }

    public int getMinIndex() {
        return this.minindex;
    }

    public boolean contains(int i) {
        if (i < this.getMinIndex()) {
            return false;
        }
        return i <= this.getMaxIndex();
    }

    public abstract int getPixel(int var1);

    public int getPixel(double indval) {
        double base = Math.rint(indval);
        double residual = indval - base + 0.5;
        int ibase = (int)base;
        int map = (int)((double)this.getPixel(ibase) * (1.0 - residual) + residual * (double)this.getPixel(ibase + 1));
        return map;
    }

    public int getRequiredPixels() {
        return (int)((double)(this.maxindex - this.minindex + 1) * this.getScale());
    }

    public abstract double getScale();

    public abstract int getUsedPixels();

    public abstract int getViewableIndexes();

    public void setAvailablePixels(int i) {
        this.availablepixels = i;
    }

    public void setIndexRange(int i, int j) {
        this.minindex = i;
        this.maxindex = j;
    }

    public abstract String type();
}

