/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DoubleArrayDrawer;
import java.awt.Rectangle;

public class KnnArrayDrawer
extends DoubleArrayDrawer {
    public void recalculateContrast() {
        double mean = 0.0;
        int count = 0;
        int nRow = this.dataMatrix.getNumRow();
        int nCol = this.dataMatrix.getNumCol();
        for (int row = 0; row < nRow; ++row) {
            for (int col = 0; col < nCol; ++col) {
                double val = this.dataMatrix.getValue(row, col);
                if (val == -1.0E7 || val == -2.0E7) continue;
                mean += Math.abs(val);
                ++count;
            }
        }
        this.colorExtractor.setContrast((mean /= (double)count) * 4.0);
        this.colorExtractor.notifyObservers();
    }

    public void paint(int[] pixels, Rectangle source, Rectangle dest, int scanSize, int[] geneOrder) {
        if (this.dataMatrix == null) {
            System.out.println("data matrix wasn't set");
        }
        int ynext = dest.y;
        int geneFirst = 0;
        for (int gene = 0; gene < source.height; ++gene) {
            ynext = dest.y + (dest.height + gene * dest.height) / source.height;
            int ystart = ynext;
            if (ynext == ystart) continue;
            int xnext = dest.x;
            int arrayFirst = 0;
            for (int array = 0; array < source.width; ++array) {
                xnext = dest.x + (dest.width + array * dest.width) / source.width;
                int xstart = xnext;
                if (xnext == xstart) continue;
                try {
                    double val = 0.0;
                    int count = 0;
                    for (int i = geneFirst; i <= gene; ++i) {
                        for (int j = arrayFirst; j <= array; ++j) {
                            double thisVal;
                            int actualGene = source.y + i;
                            if (geneOrder != null) {
                                actualGene = geneOrder[actualGene];
                            }
                            if ((thisVal = this.dataMatrix.getValue(j + source.x, actualGene)) == -2.0E7) {
                                val = -2.0E7;
                                count = 1;
                                break;
                            }
                            if (thisVal == -1.0E7) continue;
                            ++count;
                            val += thisVal;
                        }
                        if (val == -2.0E7) break;
                    }
                    val = count == 0 ? -1.0E7 : (val /= (double)count);
                    int t_color = this.colorExtractor.getARGBColor(val);
                    for (int x = xstart; x < xnext; ++x) {
                        for (int y = ystart; y < ynext; ++y) {
                            pixels[x + y * scanSize] = t_color;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                arrayFirst = array + 1;
            }
            geneFirst = gene + 1;
        }
    }
}

