/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinearTransformation;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TreeDrawer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Stack;

public class LeftTreeDrawer
extends TreeDrawer {
    public void paint(Graphics graphics, LinearTransformation xScaleEq, LinearTransformation yScaleEq, Rectangle dest, TreeDrawerNode selected) {
        if (this.getRootNode() == null || this.getRootNode().isLeaf()) {
            System.out.println("Root node is null or leaf!");
        } else {
            NodeDrawer nd = new NodeDrawer(graphics, xScaleEq, yScaleEq, selected, dest);
            nd.draw(this.getRootNode());
        }
    }

    public void paintSubtree(Graphics graphics, LinearTransformation xScaleEq, LinearTransformation yScaleEq, Rectangle dest, TreeDrawerNode root, boolean isSelected) {
        if (root == null || root.isLeaf()) {
            return;
        }
        if (yScaleEq == null) {
            Exception e = new Exception();
            e.printStackTrace();
        }
        NodeDrawer nd = new NodeDrawer(graphics, xScaleEq, yScaleEq, null, dest);
        nd.isSelected = isSelected;
        nd.draw(root);
    }

    public void paintSubtree(Graphics graphics, LinearTransformation xScaleEq, LinearTransformation yScaleEq, Rectangle dest, TreeDrawerNode root, TreeDrawerNode selected) {
        if (root == null || root.isLeaf()) {
            return;
        }
        NodeDrawer nd = new NodeDrawer(graphics, xScaleEq, yScaleEq, selected, dest);
        nd.draw(root);
    }

    public void paintSingle(Graphics graphics, LinearTransformation xScaleEq, LinearTransformation yScaleEq, Rectangle dest, TreeDrawerNode root, boolean isSelected) {
        if (root == null || root.isLeaf()) {
            return;
        }
        NodeDrawer nd = new NodeDrawer(graphics, xScaleEq, yScaleEq, null, dest);
        nd.isSelected = isSelected;
        if (!root.isLeaf()) {
            nd.drawSingle(root);
        } else {
            System.err.println("Root was leaf?");
        }
    }

    class NodeDrawer {
        boolean isSelected = false;
        private Color sel_color = Color.red;
        private Color node_color = Color.blue;
        private Graphics graphics;
        private TreeDrawerNode selected;
        private LinearTransformation xT;
        private LinearTransformation yT;
        private double minInd;
        private double maxInd;
        private Rectangle dest;

        public NodeDrawer(Graphics g, LinearTransformation xScaleEq, LinearTransformation yScaleEq, TreeDrawerNode sel, Rectangle d) {
            if (yScaleEq == null) {
                return;
            }
            this.graphics = g;
            this.selected = sel;
            this.xT = xScaleEq;
            this.yT = yScaleEq;
            this.dest = d;
            if (this.dest != null) {
                this.minInd = (int)yScaleEq.inverseTransform(this.dest.y);
                this.maxInd = (int)yScaleEq.inverseTransform(this.dest.y + this.dest.height) + 1;
            }
        }

        public void draw(TreeDrawerNode startNode) {
            Stack<TreeDrawerNode> remaining = new Stack<TreeDrawerNode>();
            remaining.push(startNode);
            while (!remaining.empty()) {
                TreeDrawerNode node = (TreeDrawerNode)remaining.pop();
                if (node.getMaxIndex() < this.minInd || node.getMinIndex() > this.maxInd) continue;
                if (node == this.selected) {
                    if (!this.isSelected) {
                        this.isSelected = true;
                        remaining.push(this.selected);
                    } else {
                        this.isSelected = false;
                        continue;
                    }
                }
                TreeDrawerNode left = node.getLeft();
                TreeDrawerNode right = node.getRight();
                if (!left.isLeaf()) {
                    remaining.push(left);
                }
                if (!right.isLeaf()) {
                    remaining.push(right);
                }
                this.drawSingle(node);
            }
        }

        private void drawSingle(TreeDrawerNode node) {
            TreeDrawerNode left = node.getLeft();
            TreeDrawerNode right = node.getRight();
            if (this.xT == null) {
                System.err.println("xt was null");
            }
            if (right == null) {
                System.err.println("right was null");
            }
            int rx = (int)this.xT.transform(right.getCorr());
            int lx = (int)this.xT.transform(left.getCorr());
            int tx = (int)this.xT.transform(node.getCorr());
            int ry = (int)this.yT.transform(right.getIndex() + 0.5);
            int ly = (int)this.yT.transform(left.getIndex() + 0.5);
            int ty = (int)this.yT.transform(node.getIndex() + 0.5);
            if (this.isSelected) {
                this.graphics.setColor(this.sel_color);
            } else {
                this.graphics.setColor(node.getColor());
            }
            this.graphics.drawPolyline(new int[]{rx, tx, tx, lx}, new int[]{ry, ry, ly, ly}, 4);
        }
    }
}

