/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNodePersistent;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.FillMap;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.FixedMap;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.IntegerMap;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.NullMap;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollBar;

public class MapContainer
extends Observable
implements Observer,
AdjustmentListener,
ConfigNodePersistent {
    private String default_map = "Fixed";
    private double default_scale = 10.0;
    private IntegerMap current = null;
    private FixedMap fixedMap = new FixedMap();
    private FillMap fillMap = new FillMap();
    private NullMap nullMap = new NullMap();
    private JScrollBar scrollbar = null;
    private TreeDrawerNode selected = null;
    private ConfigNode root = null;

    public MapContainer() {
        this.current = this.nullMap;
    }

    public MapContainer(String type) {
        this();
        this.setMap(type);
    }

    private ConfigNode fetchOrCreateNode(String name) {
        ConfigNode ret = this.root.fetchFirst(name);
        if (ret == null) {
            ret = this.root.create(name);
        }
        return ret;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.fixedMap.bindConfig(this.fetchOrCreateNode("FixedMap"));
        this.fillMap.bindConfig(this.fetchOrCreateNode("FillMap"));
        this.nullMap.bindConfig(this.fetchOrCreateNode("NullMap"));
        this.setMap(this.root.getAttribute("current", this.default_map));
    }

    public void setDefaultScale(double d) {
        this.default_scale = d;
        this.fixedMap.setDefaultScale(d);
    }

    public void recalculateScale() {
        if (this.root.fetchFirst("FixedMap").hasAttribute("scale") && this.getScale() < (double)this.getAvailablePixels()) {
            return;
        }
        int range = this.getMaxIndex() - this.getMinIndex() + 1;
        double requiredScale = this.getAvailablePixels() / range;
        if (requiredScale > this.default_scale) {
            this.setScale(requiredScale);
        } else {
            this.setScale(this.default_scale);
        }
    }

    public void setScrollbar(JScrollBar scrollbar) {
        if (this.scrollbar != null) {
            this.scrollbar.removeAdjustmentListener(this);
        }
        this.scrollbar = scrollbar;
        if (this.scrollbar != null) {
            this.scrollbar.addAdjustmentListener(this);
            this.setupScrollbar();
        }
    }

    public IntegerMap setMap(String string) {
        if (this.current.type().equals(string)) {
            return this.current;
        }
        IntegerMap newMap = null;
        if (this.nullMap.type().equals(string)) {
            newMap = this.nullMap;
        }
        if (this.fillMap.type().equals(string)) {
            newMap = this.fillMap;
        }
        if (this.fixedMap.type().equals(string)) {
            newMap = this.fixedMap;
        }
        if (newMap == null) {
            newMap = this.fixedMap;
        }
        this.switchMap(newMap);
        return this.current;
    }

    public void scrollToIndex(int i) {
        int j = this.scrollbar.getValue();
        this.scrollbar.setValue(i - this.scrollbar.getVisibleAmount() / 2);
        if (j != this.scrollbar.getValue()) {
            this.setChanged();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setChanged();
        this.notifyObservers(this.scrollbar);
    }

    private void setupScrollbar() {
        if (this.scrollbar != null) {
            int max;
            int extent;
            int value = this.scrollbar.getValue();
            if (value + (extent = this.current.getViewableIndexes()) > (max = this.current.getMaxIndex() - this.current.getMinIndex() + 1)) {
                value = max - extent;
            }
            if (value < 0) {
                value = 0;
            }
            this.scrollbar.setValues(value, extent, 0, max);
            this.scrollbar.setBlockIncrement(this.current.getViewableIndexes());
        }
    }

    public void update(Observable observable, Object object) {
        System.out.println(new StringBuffer("MapContainer Got an update from unknown ").append(observable).toString());
        this.notifyObservers(object);
    }

    public void underlyingChanged() {
        this.setupScrollbar();
        this.setChanged();
    }

    public boolean contains(int i) {
        return this.current.contains(i);
    }

    public double getScale() {
        return this.current.getScale();
    }

    public int getPixel(double d) {
        int offset = 0;
        if (this.scrollbar != null) {
            offset = this.scrollbar.getValue();
        }
        return this.current.getPixel(d - (double)offset);
    }

    public int getPixel(int i) {
        int offset = 0;
        if (this.scrollbar != null) {
            offset = this.scrollbar.getValue();
        }
        return this.current.getPixel(i - offset);
    }

    public int getIndex(int pix) {
        int index = 0;
        if (this.current != null) {
            index = this.current.getIndex(pix);
        }
        if (this.scrollbar != null) {
            index += this.scrollbar.getValue();
        }
        return index;
    }

    public boolean isVisible(int i) {
        int min = this.getIndex(0);
        int max = this.getIndex(this.getAvailablePixels());
        if (i < min) {
            return false;
        }
        return i <= max;
    }

    public int getRequiredPixels() {
        return this.current.getRequiredPixels();
    }

    public int getUsedPixels() {
        return this.current.getUsedPixels();
    }

    public void setAvailablePixels(int i) {
        int j = this.current.getUsedPixels();
        this.current.setAvailablePixels(i);
        this.setupScrollbar();
        if (j != this.current.getUsedPixels()) {
            this.setChanged();
        }
    }

    public void setIndexRange(int i, int j) {
        if (i > j) {
            int k = i;
            i = j;
            j = k;
        }
        if (this.current.getMinIndex() != i || this.current.getMaxIndex() != j) {
            this.current.setIndexRange(i, j);
            this.setupScrollbar();
            this.setChanged();
        }
    }

    public void setScale(double d) {
        if (this.fixedMap.getScale() != d) {
            this.fixedMap.setScale(d);
            this.setupScrollbar();
            this.setChanged();
        }
    }

    public int getMiddlePixel(int i) {
        return (this.getPixel(i) + this.getPixel(i + 1)) / 2;
    }

    public int getMaxIndex() {
        return this.current.getMaxIndex();
    }

    public int getMinIndex() {
        return this.current.getMinIndex();
    }

    public TreeDrawerNode getSelectedNode() {
        return this.selected;
    }

    public void setSelectedNode(TreeDrawerNode treeDrawerNode) {
        if (this.selected != treeDrawerNode) {
            this.selected = treeDrawerNode;
            this.setChanged();
        }
    }

    public IntegerMap getCurrent() {
        return this.current;
    }

    public int getAvailablePixels() {
        return this.current.getAvailablePixels();
    }

    private void switchMap(IntegerMap integerMap) {
        if (this.current != integerMap) {
            if (this.root != null) {
                this.root.setAttribute("current", integerMap.type(), this.default_map);
            }
            integerMap.setAvailablePixels(this.current.getAvailablePixels());
            integerMap.setIndexRange(this.current.getMinIndex(), this.current.getMaxIndex());
            this.current = integerMap;
            this.setupScrollbar();
            this.setChanged();
        }
    }
}

