/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.SettingsPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorExtractorEditor;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorPresets;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ColorSet;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ContrastSelector;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PixelSettingsSelector
extends JPanel
implements SettingsPanel {
    ScalePanel m_xscale;
    ScalePanel m_yscale;
    ScalePanel m_xZscale;
    ScalePanel m_yZscale;
    ContrastSelector m_contrast;
    LogScaleSelector m_logscale;
    MapContainer m_xmap;
    MapContainer m_ymap;
    MapContainer m_xZmap;
    MapContainer m_yZmap;
    ColorExtractor m_drawer;
    ColorPresets m_presets;
    ColorExtractorEditor colorExtractorEditor;
    ColorPresetsPanel colorPresetsPanel;

    public PixelSettingsSelector(MapContainer xmap, MapContainer ymap, MapContainer xZmap, MapContainer yZmap, ConfigNode config, ColorExtractor drawer, ColorPresets colorPresets) {
        this(xmap, ymap, xZmap, yZmap, drawer, colorPresets);
    }

    public PixelSettingsSelector(MapContainer xmap, MapContainer ymap, MapContainer xZmap, MapContainer yZmap, ColorExtractor drawer, ColorPresets colorPresets) {
        this.setLayout(new BoxLayout(this, 1));
        this.m_xmap = xmap;
        this.m_ymap = ymap;
        this.m_xZmap = xZmap;
        this.m_yZmap = yZmap;
        this.m_drawer = drawer;
        this.m_presets = colorPresets;
        this.setupWidgets();
    }

    private void setupWidgets() {
        this.removeAll();
        Border border = BorderFactory.createEtchedBorder();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Global:"), gbc);
        JPanel t = new JPanel();
        t.setBorder(border);
        this.m_xscale = new ScalePanel(this.m_xmap, "X:");
        t.add(this.m_xscale);
        this.m_yscale = new ScalePanel(this.m_ymap, "Y:");
        t.add(this.m_yscale);
        gbc.gridy = 0;
        gbc.gridx = 1;
        this.add((Component)t, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Zoom:"), gbc);
        t = new JPanel();
        t.setBorder(border);
        this.m_xZscale = new ScalePanel(this.m_xZmap, "X:");
        t.add(this.m_xZscale);
        this.m_yZscale = new ScalePanel(this.m_yZmap, "Y:");
        t.add(this.m_yZscale);
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.add((Component)t, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        if (this.m_drawer != null) {
            this.add((Component)new JLabel("Contrast:"), gbc);
            this.m_contrast = new ContrastSelector(this.m_drawer);
            this.m_contrast.setBorder(border);
            gbc.gridx = 1;
            this.add((Component)this.m_contrast, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            this.add((Component)new JLabel("LogScale:"), gbc);
            this.m_logscale = new LogScaleSelector();
            this.m_logscale.setBorder(border);
            gbc.gridx = 1;
            this.add((Component)this.m_logscale, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            this.add((Component)new JLabel("Colors:"), gbc);
            JPanel temp2 = new JPanel();
            temp2.setBorder(border);
            temp2.setLayout(new BoxLayout(temp2, 1));
            this.colorExtractorEditor = new ColorExtractorEditor(this.m_drawer);
            temp2.add(this.colorExtractorEditor);
            temp2.add(new CEEButtons());
            this.colorPresetsPanel = new ColorPresetsPanel();
            JScrollPane colorScrollPane = new JScrollPane(this.colorPresetsPanel, 21, 32);
            colorScrollPane.setMinimumSize(new Dimension(100, 60));
            temp2.add(colorScrollPane);
            gbc.gridx = 1;
            this.add((Component)temp2, gbc);
        }
    }

    public void synchronizeFrom() {
        this.setupWidgets();
    }

    public void synchronizeTo() {
    }

    public JDialog showDialog(JFrame f, String title) {
        final JDialog d = new JDialog((Frame)f, title);
        d.setLayout(new BorderLayout());
        d.add((Component)this, "Center");
        final JButton display_button = new JButton("Close");
        display_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == display_button) {
                    PixelSettingsSelector.this.synchronizeTo();
                    d.dispose();
                }
            }
        });
        JPanel p = new JPanel();
        p.add(display_button);
        d.add((Component)p, "South");
        d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                PixelSettingsSelector.this.synchronizeTo();
                d.dispose();
            }
        });
        d.pack();
        return d;
    }

    class ColorPresetsPanel
    extends JPanel {
        ColorPresetsPanel() {
            this.redoLayout();
        }

        public void redoLayout() {
            this.removeAll();
            int nPresets = PixelSettingsSelector.this.m_presets.getNumPresets();
            JButton[] buttons = new JButton[nPresets];
            int i = 0;
            while (i < nPresets) {
                JButton presetButton = new JButton(PixelSettingsSelector.this.m_presets.getPresetNames()[i]);
                final int index = i++;
                presetButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PixelSettingsSelector.this.colorExtractorEditor.copyStateFrom(PixelSettingsSelector.this.m_presets.getColorSet(index));
                    }
                });
                this.add(presetButton);
                buttons[index] = presetButton;
            }
        }
    }

    class LogScaleSelector
    extends JPanel {
        private JTextField logTextField;
        private JCheckBox logCheckBox = new JCheckBox("Log (base 2)");

        LogScaleSelector() {
            this.logCheckBox.setSelected(PixelSettingsSelector.this.m_drawer.getLogTransform());
            this.logCheckBox.addActionListener(new ActionListener(){

                public void stateChanged(ChangeEvent arg0) {
                    PixelSettingsSelector.this.m_drawer.setLogTransform(LogScaleSelector.this.logCheckBox.isSelected());
                    LogScaleSelector.this.logTextField.setEnabled(LogScaleSelector.this.logCheckBox.isSelected());
                    PixelSettingsSelector.this.m_drawer.notifyObservers();
                }

                public void actionPerformed(ActionEvent arg0) {
                    PixelSettingsSelector.this.m_drawer.setLogTransform(LogScaleSelector.this.logCheckBox.isSelected());
                    LogScaleSelector.this.logTextField.setEnabled(LogScaleSelector.this.logCheckBox.isSelected());
                    PixelSettingsSelector.this.m_drawer.setLogBase(2.0);
                    PixelSettingsSelector.this.m_drawer.notifyObservers();
                }
            });
            this.add(this.logCheckBox);
            this.logTextField = new JTextField(10);
            this.logTextField.setText("" + PixelSettingsSelector.this.m_drawer.getLogCenter());
            this.add(new JLabel("Center:"));
            this.logTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    LogScaleSelector.this.textBoxChanged();
                }

                public void insertUpdate(DocumentEvent e) {
                    LogScaleSelector.this.textBoxChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    LogScaleSelector.this.textBoxChanged();
                }
            });
            this.add(this.logTextField);
            this.logTextField.setEnabled(this.logCheckBox.isSelected());
        }

        private void textBoxChanged() {
            try {
                Double d = new Double(this.logTextField.getText());
                PixelSettingsSelector.this.m_drawer.setLogCenter(d);
                PixelSettingsSelector.this.m_drawer.notifyObservers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ColorSelector
    extends JPanel {
        private ColorSet colorSet;

        ColorSelector() {
            this.add(new ColorExtractorEditor(PixelSettingsSelector.this.m_drawer));
        }
    }

    class CEEButtons
    extends JPanel {
        CEEButtons() {
            JButton loadButton = new JButton("Load...");
            loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showOpenDialog(CEEButtons.this);
                    if (returnVal == 0) {
                        File f = chooser.getSelectedFile();
                        try {
                            ColorSet temp = new ColorSet();
                            temp.loadEisen(f);
                            PixelSettingsSelector.this.colorExtractorEditor.copyStateFrom(temp);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(CEEButtons.this, "Could not load from " + f.toString() + "\n" + ex);
                        }
                    }
                }
            });
            this.add(loadButton);
            JButton saveButton = new JButton("Save...");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    int returnVal = chooser.showSaveDialog(CEEButtons.this);
                    if (returnVal == 0) {
                        File f = chooser.getSelectedFile();
                        try {
                            ColorSet temp = new ColorSet();
                            PixelSettingsSelector.this.colorExtractorEditor.copyStateTo(temp);
                            temp.saveEisen(f);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(CEEButtons.this, "Could not save to " + f.toString() + "\n" + ex);
                        }
                    }
                }
            });
            this.add(saveButton);
            JButton makeButton = new JButton("Make Preset");
            makeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorSet temp = new ColorSet();
                    PixelSettingsSelector.this.colorExtractorEditor.copyStateTo(temp);
                    temp.setName("UserDefined");
                    PixelSettingsSelector.this.m_presets.addColorSet(temp);
                    PixelSettingsSelector.this.colorPresetsPanel.redoLayout();
                    PixelSettingsSelector.this.colorPresetsPanel.invalidate();
                    PixelSettingsSelector.this.colorPresetsPanel.revalidate();
                    PixelSettingsSelector.this.colorPresetsPanel.repaint();
                }
            });
            this.add(makeButton);
        }
    }

    class ScalePanel
    extends JPanel {
        private ButtonGroup type;
        private JRadioButton fixed;
        private JRadioButton fill;
        private JTextField value;
        private MapContainer ymap;

        public ScalePanel(MapContainer xmc, String title) {
            this.ymap = xmc;
            this.setLayout(new GridLayout(3, 2));
            this.add(new JLabel(title));
            this.add(new JPanel());
            this.type = new ButtonGroup();
            this.fixed = new JRadioButton("Fixed Scale");
            this.type.add(this.fixed);
            this.add(this.fixed);
            this.value = new JTextField(Double.toString(this.ymap.getScale()), 5);
            this.add(this.value);
            this.fill = new JRadioButton("Fill");
            this.type.add(this.fill);
            this.add(this.fill);
            if (xmc.getCurrent().type().equals("Fixed")) {
                this.fixed.setSelected(true);
            } else {
                this.fill.setSelected(true);
            }
            this.fill.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    ScalePanel.this.updateCheck();
                }
            });
            this.fixed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    ScalePanel.this.updateCheck();
                }
            });
            this.value.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    ScalePanel.this.updateValue();
                }

                public void insertUpdate(DocumentEvent e) {
                    ScalePanel.this.updateValue();
                }

                public void removeUpdate(DocumentEvent e) {
                    ScalePanel.this.updateValue();
                }
            });
        }

        public void updateCheck() {
            if (this.fixed.isSelected()) {
                this.ymap.setMap("Fixed");
                this.value.setEnabled(true);
            } else {
                this.ymap.setMap("Fill");
                this.value.setEnabled(false);
            }
            this.value.setText(Double.toString(this.ymap.getScale()));
            this.ymap.notifyObservers();
        }

        public void updateValue() {
            if (this.fixed.isSelected()) {
                try {
                    Double d = new Double(this.value.getText());
                    this.ymap.setScale(d);
                    this.ymap.notifyObservers();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

