/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderSummary;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelView;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.TreeColorer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class TextView
extends ModelView
implements KeyListener,
AdjustmentListener,
MouseListener,
MouseMotionListener {
    private final int scrollstep = 5;
    private final String d_face = "Lucida Sans Regular";
    private final int d_style = 0;
    private final int d_size = 12;
    protected HeaderInfo headerInfo = null;
    protected HeaderSummary headerSummary = new HeaderSummary();
    private ConfigNode root = null;
    private String face;
    private int style;
    private int size;
    private TreeSelectionI geneSelection;
    private MapContainer map;
    private JScrollBar scrollbar;
    private int maxlength = 0;
    private int xstart_pos;
    private int xoff_pos;
    private int col;
    private boolean dragging = false;
    private JScrollPane scrollPane;

    public String[] getHints() {
        String[] hints = new String[]{"Click and drag to scroll"};
        return hints;
    }

    public TextView(HeaderInfo hI) {
        this.headerInfo = hI;
        this.col = -1;
        int GIDIndex = this.headerInfo.getIndex("GID");
        if (GIDIndex == -1) {
            this.headerSummary.setIncluded(new int[]{1});
        } else {
            this.headerSummary.setIncluded(new int[]{2});
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setBorder(null);
        this.panel = this.scrollPane;
    }

    public TextView(HeaderInfo hI, int col) {
        this.headerInfo = hI;
        this.col = col;
        int GIDIndex = this.headerInfo.getIndex("GID");
        if (GIDIndex == -1) {
            this.headerSummary.setIncluded(new int[]{1});
        } else {
            this.headerSummary.setIncluded(new int[]{2});
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setBorder(null);
        this.panel = this.scrollPane;
    }

    public String viewName() {
        return "TextView";
    }

    public void updateBuffer(Graphics g) {
        Rectangle rect = new Rectangle(0, 0, this.offscreenSize.width, this.offscreenSize.height);
        this.updateBuffer(g, rect);
    }

    public void updateBuffer(Image buf) {
        Rectangle rect = new Rectangle(0, 0, buf.getWidth(null), buf.getHeight(null));
        this.updateBuffer(buf.getGraphics(), rect);
    }

    public void updateBuffer(Graphics g, Rectangle offscreenRect) {
        g.setColor(Color.white);
        g.fillRect(offscreenRect.x, offscreenRect.y, offscreenRect.width, offscreenRect.height);
        g.setColor(Color.black);
        if (this.map.getMinIndex() >= 0 && offscreenRect.height > 0) {
            int j;
            int start = this.map.getIndex(0);
            int end = this.map.getIndex(this.map.getUsedPixels());
            g.setFont(new Font(this.face, this.style, this.size));
            FontMetrics metrics = this.getFontMetrics(g.getFont());
            int ascent = metrics.getAscent();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int bgColorIndex = this.headerInfo.getIndex("BGCOLOR");
            if (bgColorIndex > 0) {
                Color back = g.getColor();
                for (j = start; j < end; ++j) {
                    if (this.geneSelection != null && !this.geneSelection.isIndexSelected(j)) continue;
                    String[] strings = this.headerInfo.getHeader(j);
                    try {
                        g.setColor(TreeColorer.getColor(strings[bgColorIndex]));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    g.fillRect(offscreenRect.x, offscreenRect.y + this.map.getMiddlePixel(j) - ascent / 2, offscreenRect.width, ascent);
                }
                g.setColor(back);
            }
            int fgColorIndex = this.headerInfo.getIndex("FGCOLOR");
            for (j = start; j < end; ++j) {
                String out = null;
                if (this.col == -1) {
                    out = this.headerSummary.getSummary(this.headerInfo, j);
                } else {
                    String[] summaryArray = this.headerSummary.getSummaryArray(this.headerInfo, j);
                    if (summaryArray != null && this.col < summaryArray.length) {
                        out = summaryArray[this.col];
                    }
                }
                if (out == null) continue;
                Color back = g.getColor();
                if (this.geneSelection == null || this.geneSelection.isIndexSelected(j)) {
                    String[] strings = this.headerInfo.getHeader(j);
                    if (fgColorIndex > 0) {
                        g.setColor(TreeColorer.getColor(strings[fgColorIndex]));
                    }
                    g.drawString(out, offscreenRect.x, offscreenRect.y + this.map.getMiddlePixel(j) + ascent / 2);
                    if (fgColorIndex <= 0) continue;
                    g.setColor(back);
                    continue;
                }
                g.setColor(Color.gray);
                g.drawString(out, offscreenRect.x, offscreenRect.y + this.map.getMiddlePixel(j) + ascent / 2);
                g.setColor(back);
            }
        }
    }

    public void setGeneSelection(TreeSelectionI geneSelection) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver(this);
        }
        this.geneSelection = geneSelection;
        this.geneSelection.addObserver(this);
    }

    public void setMap(MapContainer im) {
        if (this.map != null) {
            this.map.deleteObserver(this);
        }
        this.map = im;
        if (this.map != null) {
            this.map.addObserver(this);
        }
    }

    private void selectionChanged() {
        this.size = this.map.getScale() <= 20.0 ? (int)this.map.getScale() : 20;
        this.maxlength = 1;
        FontMetrics fontMetrics = this.getFontMetrics(new Font(this.face, this.style, this.size));
        int start = this.map.getIndex(0);
        int end = this.map.getIndex(this.map.getUsedPixels());
        for (int j = start; j < end; ++j) {
            int length;
            int actualGene = j;
            String out = this.headerSummary.getSummary(this.headerInfo, actualGene);
            if (out == null || this.maxlength >= (length = fontMetrics.stringWidth(out))) continue;
            this.maxlength = length;
        }
        this.setPreferredSize(new Dimension(this.maxlength, this.map.getUsedPixels()));
        this.revalidate();
        this.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o == this.map) {
            this.selectionChanged();
        } else if (o == this.geneSelection) {
            this.selectionChanged();
        } else if (o == this.headerSummary) {
            this.selectionChanged();
        } else {
            System.out.println("Textview got funny update!");
        }
    }

    public void mouseClicked(MouseEvent e) {
        int index = this.map.getIndex(e.getY());
        if (!this.map.contains(index) || this.col != -1) {
            // empty if block
        }
    }

    public void mousePressed(MouseEvent e) {
        this.dragging = true;
        this.xstart_pos = e.getX();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            int n = e.getX() * (this.maxlength - this.offscreenSize.width) / this.offscreenSize.width;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
    }

    public void keyPressed(KeyEvent e) {
        int xoff = 0;
        int c = e.getKeyCode();
        switch (c) {
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 37: {
                xoff -= 5;
                break;
            }
            case 39: {
                xoff += 5;
                break;
            }
            default: {
                return;
            }
        }
        this.adjustScrollbar(xoff);
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.offscreenValid = false;
        this.repaint();
    }

    private void adjustScrollbar(int offset) {
        this.offscreenValid = false;
        this.repaint();
    }

    public String getFace() {
        return this.face;
    }

    public int getPoints() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public void setFace(String string) {
        if (this.face == null || !this.face.equals(string)) {
            this.face = string;
            if (this.root != null) {
                this.root.setAttribute("face", this.face, "Lucida Sans Regular");
            }
            this.setFont(new Font(this.face, this.style, this.size));
            this.repaint();
        }
    }

    public void setPoints(int i) {
        if (this.size != i) {
            this.size = i;
            if (this.root != null) {
                this.root.setAttribute("size", this.size, 12);
            }
            this.setFont(new Font(this.face, this.style, this.size));
            this.repaint();
        }
    }

    public void setStyle(int i) {
        if (this.style != i) {
            this.style = i;
            if (this.root != null) {
                this.root.setAttribute("style", this.style, 0);
            }
            this.setFont(new Font(this.face, this.style, this.size));
            this.repaint();
        }
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.setFace(this.root.getAttribute("face", "Lucida Sans Regular"));
        this.setStyle(this.root.getAttribute("style", 0));
        this.setPoints(this.root.getAttribute("size", 12));
        this.getHeaderSummary().bindConfig(this.root.fetchOrCreate("GeneSummary"));
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }
}

