/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LinearTransformation;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeDrawerNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.DendroException;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;

abstract class TreeDrawer
extends Observable
implements Observer {
    private HeaderInfo nodeInfo = null;
    private double corrMin;
    private double corrMax;
    public static final int CORRELATION = 0;
    public static final int TIME = 1;
    public static final double EPSILON = 1.0E-8;
    private TreeDrawerNode[] leafList;
    private TreeDrawerNode rootNode;
    private Hashtable id2node;

    public TreeDrawer() {
        this.setDefaults();
    }

    public void update(Observable o, Object arg) {
        if (o == this.nodeInfo) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public TreeDrawerNode getRootNode() {
        return this.rootNode;
    }

    public double getCorrMin() {
        return this.corrMin;
    }

    public void setCorrMin(double corrMin) {
        this.corrMin = corrMin;
    }

    public double getCorrMax() {
        return this.corrMax;
    }

    public void setCorrMax(double corrMax) {
        this.corrMax = corrMax;
    }

    public TreeDrawerNode getLeaf(int i) {
        if (this.leafList != null) {
            try {
                return this.leafList[i];
            }
            catch (Exception e) {
                System.out.println("Got exception " + e);
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setData(HeaderInfo nodeInfo, HeaderInfo rowInfo) throws DendroException {
        if (nodeInfo == null) {
            this.setDefaults();
            return;
        }
        if (this.nodeInfo != null) {
            this.nodeInfo.deleteObserver(this);
        }
        this.nodeInfo = nodeInfo;
        nodeInfo.addObserver(this);
        this.leafList = new TreeDrawerNode[rowInfo.getNumHeaders()];
        this.id2node = new Hashtable(nodeInfo.getNumHeaders() * 4 / 3 / 2, 0.75f);
        int nodeIndex = nodeInfo.getIndex("NODEID");
        if (nodeIndex == -1) {
            throw new DendroException("Could not find header NODEID in tree header info");
        }
        for (int j = 0; j < nodeInfo.getNumHeaders(); ++j) {
            int val;
            String newId = nodeInfo.getHeader(j, nodeIndex);
            String leftId = nodeInfo.getHeader(j, "LEFT");
            String rightId = nodeInfo.getHeader(j, "RIGHT");
            TreeDrawerNode newn = (TreeDrawerNode)this.id2node.get(newId);
            TreeDrawerNode leftn = (TreeDrawerNode)this.id2node.get(leftId);
            TreeDrawerNode rightn = (TreeDrawerNode)this.id2node.get(rightId);
            if (newn != null) {
                System.out.println("Symbol '" + newn + "' appeared twice, building weird tree");
            }
            if (leftn == null) {
                val = rowInfo.getHeaderIndex(leftId);
                if (val == -1) {
                    throw new DendroException("Identifier " + leftId + " from tree file not found in CDT.");
                }
                this.leafList[val] = leftn = new TreeDrawerNode(leftId, 1.0, val);
                this.id2node.put(leftId, leftn);
            }
            if (rightn == null) {
                val = rowInfo.getHeaderIndex(rightId);
                if (val == -1) {
                    throw new DendroException("Identifier " + rightId + " from tree file not found in CDT!");
                }
                this.leafList[val] = rightn = new TreeDrawerNode(rightId, 1.0, val);
                this.id2node.put(rightId, rightn);
            }
            if (leftn.getIndex() > rightn.getIndex()) {
                TreeDrawerNode swap = leftn;
                leftn = rightn;
                rightn = swap;
            }
            this.rootNode = new TreeDrawerNode(newId, 0.0, leftn, rightn);
            leftn.setParent(this.rootNode);
            rightn.setParent(this.rootNode);
            this.id2node.put(newId, this.rootNode);
        }
        this.setBranchHeights(nodeInfo, rowInfo);
        this.setChanged();
    }

    public void setBranchHeights(HeaderInfo nodeInfo, HeaderInfo rowInfo) {
        if (this.rootNode == null) {
            return;
        }
        int nameIndex = nodeInfo.getIndex("TIME");
        int type = 1;
        if (nameIndex == -1) {
            nameIndex = nodeInfo.getIndex("CORRELATION");
            type = 0;
        }
        this.setBranchHeightsIter(nodeInfo, nameIndex, type, this.rootNode);
        if (type == 0) {
            this.setCorrMin(this.rootNode.getMinCorr());
            this.setCorrMax(1.0);
            for (int i = 0; i < this.leafList.length; ++i) {
                if (this.leafList[i] == null) continue;
                this.leafList[i].setCorr(this.getCorrMax());
            }
        } else {
            double leaf;
            int i;
            for (i = 0; i < this.leafList.length; ++i) {
                leaf = this.rootNode.getCorr();
                try {
                    leaf = TreeDrawer.parseDouble(rowInfo.getHeader((int)this.leafList[i].getIndex(), "LEAF"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.leafList[i].setCorr(leaf);
            }
            this.setCorrMin(this.rootNode.getMinCorr());
            this.setCorrMax(this.rootNode.getMaxCorr());
            for (i = 0; i < this.leafList.length; ++i) {
                leaf = this.getCorrMax();
                try {
                    leaf = TreeDrawer.parseDouble(rowInfo.getHeader((int)this.leafList[i].getIndex(), "LEAF"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.leafList[i].setCorr(leaf);
            }
        }
    }

    public void setBranchHeightsIter(HeaderInfo nodeInfo, int nameIndex, int type, TreeDrawerNode start) {
        Stack<TreeDrawerNode> remaining = new Stack<TreeDrawerNode>();
        remaining.push(start);
        while (!remaining.empty()) {
            TreeDrawerNode current = (TreeDrawerNode)remaining.pop();
            if (current.isLeaf()) continue;
            int j = nodeInfo.getHeaderIndex(current.getId());
            Double d = new Double(nodeInfo.getHeader(j)[nameIndex]);
            double corr = d;
            if (type == 0) {
                if (corr > 1.0) {
                    corr = 1.0;
                } else if (corr < -1.0) {
                    corr = -1.0;
                }
                current.setCorr(corr);
            } else {
                current.setCorr(corr);
            }
            remaining.push(current.getLeft());
            remaining.push(current.getRight());
        }
    }

    public abstract void paint(Graphics var1, LinearTransformation var2, LinearTransformation var3, Rectangle var4, TreeDrawerNode var5);

    public TreeDrawerNode getClosest(double index, double corr, double weight) {
        if (this.rootNode == null) {
            return null;
        }
        IterativeClosestFinder rcf = new IterativeClosestFinder(index, corr, weight);
        return rcf.find(this.rootNode);
    }

    public TreeDrawerNode getNodeById(String id) {
        if (id == null) {
            return null;
        }
        return (TreeDrawerNode)this.id2node.get(id);
    }

    private void setDefaults() {
        this.id2node = null;
        this.rootNode = null;
        this.leafList = null;
        if (this.nodeInfo != null) {
            this.nodeInfo.deleteObserver(this);
        }
        this.nodeInfo = null;
        this.setChanged();
    }

    public static double parseDouble(String string) {
        Double val = Double.valueOf(string);
        return val;
    }

    class IterativeClosestFinder {
        private double index;
        private double correlation;
        private double weight;

        public IterativeClosestFinder(double ind, double corr, double wei) {
            this.index = ind;
            this.correlation = corr;
            this.weight = wei;
        }

        public TreeDrawerNode find(TreeDrawerNode startNode) {
            if (startNode.isLeaf()) {
                return startNode;
            }
            TreeDrawerNode closest = startNode;
            Stack<TreeDrawerNode> remaining = new Stack<TreeDrawerNode>();
            remaining.push(startNode);
            while (!remaining.empty()) {
                TreeDrawerNode testN = (TreeDrawerNode)remaining.pop();
                if (testN.getDist(this.index, this.correlation, this.weight) < closest.getDist(this.index, this.correlation, this.weight)) {
                    closest = testN;
                }
                TreeDrawerNode left = testN.getLeft();
                TreeDrawerNode right = testN.getRight();
                if (!left.isLeaf()) {
                    remaining.push(left);
                }
                if (right.isLeaf()) continue;
                remaining.push(right);
            }
            return closest;
        }
    }
}

