/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ModelViewProduced;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.ArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.CharArrayDrawer;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import javax.swing.JOptionPane;

class ZoomView
extends ModelViewProduced
implements MouseMotionListener {
    private int overx;
    private int overy;
    private static final String[] hints = new String[]{"Mouse over to get info"};
    boolean showVal = false;
    protected TreeSelectionI geneSelection;
    protected TreeSelectionI arraySelection;
    private ArrayDrawer drawer;
    private String[] statustext = new String[]{"Mouseover Selection", "", ""};
    private Rectangle sourceRect = new Rectangle();
    private Rectangle destRect = new Rectangle();
    private MapContainer xmap;
    private MapContainer ymap;
    private HeaderInfo arrayHI;
    private HeaderInfo geneHI;

    public ZoomView() {
        this.panel = this;
        this.setToolTipText("This Turns Tooltips On");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public String[] getHints() {
        return hints;
    }

    public boolean getShowVal() {
        return this.showVal;
    }

    public void setShowVal(boolean showVal) {
        this.showVal = showVal;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xmap.getRequiredPixels(), this.ymap.getRequiredPixels());
    }

    public void setGeneSelection(TreeSelectionI geneSelection) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver(this);
        }
        this.geneSelection = geneSelection;
        if (this.geneSelection != null) {
            this.geneSelection.addObserver(this);
        }
    }

    public void setArraySelection(TreeSelectionI arraySelection) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver(this);
        }
        this.arraySelection = arraySelection;
        if (this.arraySelection != null) {
            this.arraySelection.addObserver(this);
        }
    }

    public void setArrayDrawer(ArrayDrawer arrayDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver(this);
        }
        this.drawer = arrayDrawer;
        if (this.drawer != null) {
            this.drawer.addObserver(this);
        }
    }

    public ArrayDrawer getArrayDrawer() {
        return this.drawer;
    }

    public void setXMap(MapContainer m) {
        if (this.xmap != null) {
            this.xmap.deleteObserver(this);
        }
        this.xmap = m;
        if (this.xmap != null) {
            this.xmap.addObserver(this);
        }
    }

    public void setYMap(MapContainer m) {
        if (this.ymap != null) {
            this.ymap.deleteObserver(this);
        }
        this.ymap = m;
        if (this.ymap != null) {
            this.ymap.addObserver(this);
        }
    }

    public MapContainer getXMap() {
        return this.xmap;
    }

    public MapContainer getZoomXmap() {
        return this.xmap;
    }

    public MapContainer getYMap() {
        return this.ymap;
    }

    public MapContainer getZoomYmap() {
        return this.ymap;
    }

    public String viewName() {
        return "ZoomView";
    }

    public String[] getStatus() {
        try {
            if (this.xmap.contains(this.overx) && this.ymap.contains(this.overy)) {
                this.statustext[0] = "Row:    " + (this.overy + 1);
                if (this.geneHI != null && this.overy >= 0) {
                    int realGene = this.overy;
                    this.statustext[0] = this.statustext[0] + " (" + this.geneHI.getHeader(realGene, 1) + ")";
                }
                this.statustext[1] = "Column: " + (this.overx + 1);
                if (this.arrayHI != null && this.overx >= 0) {
                    this.statustext[1] = this.statustext[1] + " (" + this.arrayHI.getHeader(this.overx, 0) + ")";
                }
                this.statustext[2] = this.drawer.isMissing(this.overx, this.overy) ? "Value:  No Data" : (this.drawer.isEmpty(this.overx, this.overy) ? "" : "Value:  " + this.drawer.getSummary(this.overx, this.overy));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return this.statustext;
    }

    public void updateBuffer(Graphics g) {
        if (this.offscreenChanged) {
            this.xmap.setAvailablePixels(this.offscreenSize.width);
            this.ymap.setAvailablePixels(this.offscreenSize.height);
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!this.offscreenValid) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
            g.setColor(Color.black);
            this.destRect.setBounds(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            this.sourceRect.setBounds(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(this.destRect.width) - this.xmap.getIndex(0), this.ymap.getIndex(this.destRect.height) - this.ymap.getIndex(0));
            if (this.sourceRect.x >= 0 && this.sourceRect.y >= 0) {
                this.drawer.paint(g, this.sourceRect, this.destRect, null);
            }
        }
    }

    public void paintComposite(Graphics g) {
        if (this.getShowVal()) {
            try {
                ((CharArrayDrawer)this.drawer).paintChars(g, this.xmap, this.ymap, this.destRect);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "ZoomView had trouble compositing:" + e);
                this.setShowVal(false);
            }
        }
    }

    public void updatePixels() {
        if (this.offscreenChanged) {
            this.xmap.setAvailablePixels(this.offscreenSize.width);
            this.ymap.setAvailablePixels(this.offscreenSize.height);
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!this.offscreenValid) {
            this.destRect.setBounds(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            this.sourceRect.setBounds(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(this.destRect.width) - this.xmap.getIndex(0), this.ymap.getIndex(this.destRect.height) - this.ymap.getIndex(0));
            if (this.sourceRect.x >= 0 && this.sourceRect.y >= 0) {
                this.drawer.paint(this.offscreenPixels, this.sourceRect, this.destRect, this.offscreenScanSize);
            }
            this.offscreenSource.newPixels();
        }
    }

    public void update(Observable o, Object arg) {
        if (o == this.drawer) {
            this.offscreenValid = false;
        } else if (o == this.xmap || o == this.ymap) {
            this.offscreenValid = false;
        } else if (o == this.geneSelection || o == this.arraySelection) {
            MapContainer zoomXmap = this.getZoomXmap();
            MapContainer zoomYmap = this.getZoomYmap();
            zoomYmap.setIndexRange(this.geneSelection.getMinIndex(), this.geneSelection.getMaxIndex());
            zoomXmap.setIndexRange(this.arraySelection.getMinIndex(), this.arraySelection.getMaxIndex());
            zoomXmap.notifyObservers();
            zoomYmap.notifyObservers();
        }
        if (!this.offscreenValid) {
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        int ooverx = this.overx;
        int oovery = this.overy;
        this.overx = this.xmap.getIndex(e.getX());
        this.overy = this.ymap.getIndex(e.getY());
        if ((oovery != this.overy || ooverx != this.overx) && this.status != null) {
            this.status.setMessages(this.getStatus());
        }
    }

    public String getToolTipText(MouseEvent e) {
        Object ret = "";
        if (this.drawer != null) {
            int geneRow = this.overy;
            if (this.xmap.contains(this.overx) && this.ymap.contains(this.overy)) {
                ret = this.drawer.isMissing(this.overx, geneRow) ? "No data" : (this.drawer.isEmpty(this.overx, geneRow) ? null : "" + this.drawer.getSummary(this.overx, geneRow));
            }
        }
        return ret;
    }

    public void setHeaders(HeaderInfo ghi, HeaderInfo ahi) {
        this.geneHI = ghi;
        this.arrayHI = ahi;
    }
}

