/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.model;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.FileSet;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.DataMatrixWriter;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.HeaderInfoWriter;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

public class DataModelWriter {
    DataModel dataModel;

    public DataModelWriter(DataModel source) {
        this.dataModel = source;
    }

    public void writeAll(FileSet fileSet) {
        this.writeAtr(fileSet.getAtr());
        this.writeGtr(fileSet.getGtr());
        this.writeCdt(fileSet.getCdt());
    }

    public void writeIncremental(FileSet fileSet) {
        if (this.dataModel.aidFound() && this.dataModel.getAtrHeaderInfo().getModified()) {
            this.writeAtr(fileSet.getAtr());
        }
        if (this.dataModel.gidFound() && this.dataModel.getGtrHeaderInfo().getModified()) {
            this.writeGtr(fileSet.getGtr());
        }
    }

    public void writeAtr(String atr) {
        this.writeTree(this.dataModel.getAtrHeaderInfo(), atr);
    }

    public void writeGtr(String gtr) {
        this.writeTree(this.dataModel.getGtrHeaderInfo(), gtr);
    }

    public void writeCdt(String cdt) {
        HeaderInfo geneHeaderInfo = this.dataModel.getGeneHeaderInfo();
        HeaderInfo arrayHeaderInfo = this.dataModel.getArrayHeaderInfo();
        DataMatrix dataMatrix = this.dataModel.getDataMatrix();
        DataMatrixWriter writer = new DataMatrixWriter(dataMatrix, geneHeaderInfo, arrayHeaderInfo);
        try {
            String spool = cdt + ".spool";
            writer.write(cdt);
            File f = new File(spool);
            f.renameTo(new File(cdt));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error writing " + cdt + " " + e, "Save Error", 0);
            e.printStackTrace();
        }
    }

    private void writeTree(HeaderInfo info, String file) {
        HeaderInfoWriter writer = new HeaderInfoWriter(info);
        try {
            String spool = file + ".spool";
            writer.write(file);
            File f = new File(spool);
            if (f.renameTo(new File(file))) {
                info.setModified(false);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error writing " + file + " " + e, "Save Error", 0);
            e.printStackTrace();
        }
    }
}

