/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.model;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TreeViewModel;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;

public class KnnViewModel
extends TreeViewModel {
    private String[] clusterHeaders = new String[]{"NODEID", "GROUP"};

    public KnnViewModel(TaskMonitor monitor, CyNetwork network, CyNetworkView view, ClusterManager clusterManager) {
        super(monitor, network, view, clusterManager);
        int row;
        if (this.gidFound()) {
            HeaderInfo geneHeader = this.getGeneHeaderInfo();
            HeaderInfo gtrHeader = this.getGtrHeaderInfo();
            geneHeader.addName("GROUP", geneHeader.getNumNames());
            for (row = 0; row < geneHeader.getNumHeaders(); ++row) {
                geneHeader.setHeader(row, "GROUP", gtrHeader.getHeader(row, "GROUP"));
            }
            this.gidFound(false);
        }
        if (this.aidFound()) {
            HeaderInfo arrayHeader = this.getArrayHeaderInfo();
            HeaderInfo atrHeader = this.getAtrHeaderInfo();
            arrayHeader.addName("GROUP", arrayHeader.getNumNames());
            for (row = 0; row < arrayHeader.getNumHeaders(); ++row) {
                arrayHeader.setHeader(row, "GROUP", atrHeader.getHeader(row, "GROUP"));
            }
            this.aidFound(false);
        }
    }

    protected String[] getClusterHeaders() {
        return new String[]{"NODEID", "GROUP"};
    }
}

