/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.model;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DummyConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import java.util.Observable;
import java.util.Observer;

public class ReorderedDataModel
extends Observable
implements DataModel {
    private HeaderInfo GtrHeaderInfo;
    private HeaderInfo GeneHeaderInfo;
    private HeaderInfo AtrHeaderInfo;
    private HeaderInfo ArrayHeaderInfo;
    private DataMatrix subDataMatrix = new SubDataMatrix();
    private DataModel parent;
    private int[] geneIndex;
    private int[] arrayIndex;
    private ConfigNode documentConfig = new DummyConfigNode("SubDataModel");
    String source;
    String name;

    public ReorderedDataModel(DataModel source, int[] geneIndex) {
        this(source, geneIndex, null);
    }

    public ReorderedDataModel(DataModel source, int[] geneIndex, int[] arrayIndex) {
        this.geneIndex = geneIndex;
        this.arrayIndex = arrayIndex;
        if (geneIndex != null) {
            this.GeneHeaderInfo = new ReorderedHeaderInfo(source.getGeneHeaderInfo(), geneIndex);
            this.GtrHeaderInfo = new ReorderedHeaderInfo(source.getGtrHeaderInfo(), geneIndex);
        }
        if (arrayIndex != null) {
            this.ArrayHeaderInfo = new ReorderedHeaderInfo(source.getArrayHeaderInfo(), arrayIndex);
            this.AtrHeaderInfo = new ReorderedHeaderInfo(source.getAtrHeaderInfo(), arrayIndex);
        }
        this.parent = source;
        this.source = "Subset " + this.parent.getSource();
        this.name = "Subset of " + this.parent.getName();
    }

    public ConfigNode getDocumentConfig() {
        return this.documentConfig;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setModelForCompare(DataModel dm) {
    }

    public HeaderInfo getGeneHeaderInfo() {
        if (this.GeneHeaderInfo == null) {
            return this.parent.getGeneHeaderInfo();
        }
        return this.GeneHeaderInfo;
    }

    public HeaderInfo getArrayHeaderInfo() {
        if (this.ArrayHeaderInfo == null) {
            return this.parent.getArrayHeaderInfo();
        }
        return this.ArrayHeaderInfo;
    }

    public HeaderInfo getGtrHeaderInfo() {
        if (this.GtrHeaderInfo == null) {
            return this.parent.getGtrHeaderInfo();
        }
        return this.GtrHeaderInfo;
    }

    public HeaderInfo getAtrHeaderInfo() {
        if (this.AtrHeaderInfo == null) {
            return this.parent.getAtrHeaderInfo();
        }
        return this.AtrHeaderInfo;
    }

    public String getType() {
        return "ReorderedDataModel";
    }

    public DataMatrix getDataMatrix() {
        return this.subDataMatrix;
    }

    public void append(DataModel m) {
    }

    public void removeAppended() {
    }

    public boolean aidFound() {
        return this.parent.aidFound();
    }

    public boolean gidFound() {
        return false;
    }

    public boolean getModified() {
        return false;
    }

    public boolean isLoaded() {
        return true;
    }

    public boolean isSymmetrical() {
        return this.parent.isSymmetrical();
    }

    private class ReorderedHeaderInfo
    implements HeaderInfo {
        private HeaderInfo parentHeaderInfo;
        int[] reorderedIndex;

        private ReorderedHeaderInfo(HeaderInfo hi, int[] ri) {
            this.parentHeaderInfo = hi;
            this.reorderedIndex = ri;
        }

        public String[] getHeader(int i) {
            int index = this.reorderedIndex[i];
            if (index == -1) {
                return null;
            }
            return this.parentHeaderInfo.getHeader(index);
        }

        public String getHeader(int i, String name) {
            int index = this.reorderedIndex[i];
            if (index == -1) {
                return null;
            }
            return this.parentHeaderInfo.getHeader(index, name);
        }

        public String getHeader(int rowIndex, int columnIndex) {
            String[] header = this.getHeader(rowIndex);
            if (header != null) {
                return header[columnIndex];
            }
            return "";
        }

        public String[] getNames() {
            return this.parentHeaderInfo.getNames();
        }

        public int getNumNames() {
            return this.parentHeaderInfo.getNumNames();
        }

        public int getNumHeaders() {
            return this.reorderedIndex.length;
        }

        public int getIndex(String name) {
            return this.parentHeaderInfo.getIndex(name);
        }

        public int getHeaderIndex(String id) {
            int parentIndex = this.parentHeaderInfo.getHeaderIndex(id);
            if (this.reorderedIndex[parentIndex] == parentIndex) {
                return parentIndex;
            }
            for (int i = 0; i < this.reorderedIndex.length; ++i) {
                if (this.reorderedIndex[i] != parentIndex) continue;
                return i;
            }
            return -1;
        }

        public void addObserver(Observer o) {
            this.parentHeaderInfo.addObserver(o);
        }

        public void deleteObserver(Observer o) {
            this.parentHeaderInfo.deleteObserver(o);
        }

        public boolean addName(String name, int location) {
            return false;
        }

        public boolean setHeader(int i, String name, String value) {
            return false;
        }

        public boolean getModified() {
            return false;
        }

        public void setModified(boolean mod) {
        }
    }

    private class ReorderedTrHeaderInfo
    implements HeaderInfo {
        private HeaderInfo parentHeaderInfo;
        private int[] reorderedIndex;

        private ReorderedTrHeaderInfo(HeaderInfo hi, int[] ri) {
            this.parentHeaderInfo = hi;
            this.reorderedIndex = ri;
        }

        public String[] getHeader(int i) {
            int index = this.reorderedIndex[i];
            if (index == -1) {
                return null;
            }
            return this.parentHeaderInfo.getHeader(index);
        }

        public String getHeader(int i, String name) {
            int index = this.reorderedIndex[i];
            if (index == -1) {
                return null;
            }
            return this.parentHeaderInfo.getHeader(index, name);
        }

        public String getHeader(int rowIndex, int columnIndex) {
            return this.getHeader(rowIndex)[columnIndex];
        }

        public String[] getNames() {
            return this.parentHeaderInfo.getNames();
        }

        public int getNumNames() {
            return this.parentHeaderInfo.getNumNames();
        }

        public int getNumHeaders() {
            return this.reorderedIndex.length;
        }

        public int getIndex(String name) {
            return this.parentHeaderInfo.getIndex(name);
        }

        public int getHeaderIndex(String id) {
            int parentIndex = this.parentHeaderInfo.getHeaderIndex(id);
            for (int i = 0; i < this.reorderedIndex.length; ++i) {
                if (this.reorderedIndex[i] != parentIndex) continue;
                return i;
            }
            return -1;
        }

        public void addObserver(Observer o) {
            this.parentHeaderInfo.addObserver(o);
        }

        public void deleteObserver(Observer o) {
            this.parentHeaderInfo.deleteObserver(o);
        }

        public boolean addName(String name, int location) {
            return false;
        }

        public boolean setHeader(int i, String name, String value) {
            return false;
        }

        public boolean getModified() {
            return false;
        }

        public void setModified(boolean mod) {
        }
    }

    private class SubDataMatrix
    implements DataMatrix {
        private SubDataMatrix() {
        }

        public double getValue(int col, int row) {
            if (ReorderedDataModel.this.geneIndex != null) {
                row = ReorderedDataModel.this.geneIndex[row];
            }
            if (ReorderedDataModel.this.arrayIndex != null) {
                col = ReorderedDataModel.this.arrayIndex[col];
            }
            if (row == -1 || col == -1) {
                return -2.0E7;
            }
            return ReorderedDataModel.this.parent.getDataMatrix().getValue(col, row);
        }

        public void setValue(double value, int col, int row) {
            if (ReorderedDataModel.this.geneIndex != null) {
                row = ReorderedDataModel.this.geneIndex[row];
            }
            if (ReorderedDataModel.this.arrayIndex != null) {
                col = ReorderedDataModel.this.arrayIndex[col];
            }
            if (row == -1 || col == -1) {
                return;
            }
            ReorderedDataModel.this.parent.getDataMatrix().setValue(value, col, row);
        }

        public int getNumRow() {
            if (ReorderedDataModel.this.geneIndex != null) {
                return ReorderedDataModel.this.geneIndex.length;
            }
            return ReorderedDataModel.this.parent.getDataMatrix().getNumRow();
        }

        public int getNumCol() {
            if (ReorderedDataModel.this.arrayIndex != null) {
                return ReorderedDataModel.this.arrayIndex.length;
            }
            return ReorderedDataModel.this.parent.getDataMatrix().getNumCol();
        }

        public int getNumUnappendedCol() {
            return ReorderedDataModel.this.parent.getDataMatrix().getNumUnappendedCol();
        }

        public double getMinValue() {
            return ReorderedDataModel.this.parent.getDataMatrix().getMinValue();
        }

        public double getMaxValue() {
            return ReorderedDataModel.this.parent.getDataMatrix().getMaxValue();
        }
    }
}

