/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.treeview.model;

import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ConfigNode;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.DataModel;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.FileSet;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.LoadException;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Observable;

public class TVModel
extends Observable
implements DataModel {
    boolean loaded = false;
    TVModel compareModel = null;
    int extraCompareExpr = 0;
    int appendIndex = -1;
    protected Frame frame;
    protected FileSet source = null;
    protected String dir = null;
    protected String root;
    protected TVDataMatrix dataMatrix;
    protected IntHeaderInfo arrayHeaderInfo;
    protected GeneHeaderInfo geneHeaderInfo = new GeneHeaderInfo();
    protected IntHeaderInfo atrHeaderInfo;
    protected IntHeaderInfo gtrHeaderInfo;
    protected boolean aidFound = false;
    protected boolean gidFound = false;
    protected boolean eweightFound = false;
    protected boolean gweightFound = false;
    protected PropertyConfig documentConfig;

    public String getType() {
        return "TVModel";
    }

    public void setModelForCompare(DataModel m) {
        if (m == null) {
            this.compareModel = null;
            this.extraCompareExpr = 0;
        } else {
            this.compareModel = (TVModel)m;
            this.extraCompareExpr = this.compareModel.nExpr() + 2;
        }
        this.hasChanged();
    }

    public HeaderInfo getGeneHeaderInfo() {
        return this.geneHeaderInfo;
    }

    public HeaderInfo getArrayHeaderInfo() {
        return this.arrayHeaderInfo;
    }

    public DataMatrix getDataMatrix() {
        if (this.compareModel != null) {
            // empty if block
        }
        return this.dataMatrix;
    }

    public HeaderInfo getAtrHeaderInfo() {
        return this.atrHeaderInfo;
    }

    public HeaderInfo getGtrHeaderInfo() {
        return this.gtrHeaderInfo;
    }

    public boolean gweightFound() {
        return this.gweightFound;
    }

    public int nGene() {
        return this.geneHeaderInfo.getNumHeaders();
    }

    public int nExpr() {
        return this.arrayHeaderInfo.getNumHeaders() + this.extraCompareExpr;
    }

    public void setExprData(double[] newData) {
        this.dataMatrix.setExprData(newData);
    }

    public double getValue(int x, int y) {
        int nexpr = this.nExpr();
        int ngene = this.nGene();
        if (x >= nexpr + 2) {
            if (this.compareModel != null) {
                return this.compareModel.getValue(x - (nexpr + 2), y);
            }
        } else if (x >= nexpr && y < ngene) {
            return 0.0;
        }
        if (x < nexpr && y < ngene && x >= 0 && y >= 0) {
            return this.dataMatrix.getValue(x, y);
        }
        return -1.0E7;
    }

    public boolean aidFound() {
        return this.aidFound;
    }

    public void aidFound(boolean newVal) {
        this.aidFound = newVal;
    }

    public boolean gidFound() {
        return this.gidFound;
    }

    public void gidFound(boolean newVal) {
        this.gidFound = newVal;
    }

    public void setSource(FileSet source) {
        this.source = source;
        this.setChanged();
    }

    public String getSource() {
        if (this.source == null) {
            return "No Data Loaded";
        }
        return this.source.getCdt();
    }

    public String getName() {
        return this.getFileSet().getRoot();
    }

    public FileSet getFileSet() {
        return this.source;
    }

    public ConfigNode getDocumentConfig() {
        return this.documentConfig.getRoot();
    }

    public void setDocumentConfig(PropertyConfig newVal) {
        this.documentConfig = newVal;
    }

    public TVModel() {
        this.arrayHeaderInfo = new IntHeaderInfo();
        this.atrHeaderInfo = new IntHeaderInfo();
        this.gtrHeaderInfo = new IntHeaderInfo();
        this.dataMatrix = new TVDataMatrix();
    }

    public void setFrame(Frame f) {
        this.frame = f;
    }

    public Frame getFrame() {
        return this.frame;
    }

    protected void hashAIDs() {
        this.arrayHeaderInfo.hashIDs("AID");
    }

    protected void hashGIDs() {
        this.geneHeaderInfo.hashIDs("GID");
    }

    protected void hashATRs() {
        this.atrHeaderInfo.hashIDs("NODEID");
    }

    protected void hashGTRs() {
        this.gtrHeaderInfo.hashIDs("NODEID");
    }

    protected Hashtable populateHash(HeaderInfo source, String headerName, Hashtable target) {
        int indexCol = source.getIndex(headerName);
        return this.populateHash(source, indexCol, target);
    }

    protected Hashtable populateHash(HeaderInfo source, int indexCol, Hashtable target) {
        if (target == null) {
            target = new Hashtable<String, Integer>(source.getNumHeaders() * 4 / 3, 0.75f);
        } else {
            target.clear();
        }
        if (indexCol < 0) {
            indexCol = 0;
        }
        for (int i = 0; i < source.getNumHeaders(); ++i) {
            target.put(source.getHeader(i)[indexCol], new Integer(i));
        }
        return target;
    }

    public void reorderArrays(int[] ordering) {
        int i;
        if (ordering == null || ordering.length != this.dataMatrix.getNumUnappendedCol()) {
            return;
        }
        DataMatrix data = this.getDataMatrix();
        for (int j = 0; j < data.getNumRow(); ++j) {
            double[] temp = new double[data.getNumUnappendedCol()];
            for (i = 0; i < ordering.length; ++i) {
                temp[i] = data.getValue(ordering[i], j);
            }
            for (i = 0; i < ordering.length; ++i) {
                data.setValue(temp[i], i, j);
            }
        }
        String[][] aHeaders = this.arrayHeaderInfo.headerArray;
        String[][] temp2 = new String[aHeaders.length][];
        for (i = 0; i < aHeaders.length; ++i) {
            temp2[i] = i < ordering.length ? aHeaders[ordering[i]] : aHeaders[i];
        }
        this.setArrayHeaders(temp2);
        this.hashAIDs();
        this.setChanged();
    }

    public void clearOrder() {
        ConfigNode order = this.documentConfig.getNode("ArrayOrder");
        for (int i = 0; i < this.arrayHeaderInfo.getNumHeaders(); ++i) {
            order.setAttribute("Position" + i, i, i);
        }
    }

    public void saveOrder(int[] ordering) {
        int i;
        ConfigNode order = this.documentConfig.getNode("ArrayOrder");
        int prevVal = 0;
        int[] temp = new int[this.arrayHeaderInfo.getNumHeaders()];
        for (i = 0; i < this.dataMatrix.getNumUnappendedCol(); ++i) {
            prevVal = order.getAttribute("Position" + ordering[i], -1);
            temp[i] = prevVal == -1 ? ordering[i] : prevVal;
        }
        for (i = 0; i < this.dataMatrix.getNumUnappendedCol(); ++i) {
            order.setAttribute("Position" + i, temp[i], -1);
        }
    }

    public void loadOrder() {
        if (this.documentConfig == null) {
            return;
        }
        ConfigNode order = this.documentConfig.getNode("ArrayOrder");
        int[] ordering = new int[this.dataMatrix.getNumUnappendedCol()];
        boolean prevVal = false;
        for (int i = 0; i < ordering.length; ++i) {
            ordering[i] = order.getAttribute("Position" + i, i);
        }
        this.reorderArrays(ordering);
    }

    public void resetState() {
        this.documentConfig = null;
        this.setLoaded(false);
        this.aidFound = false;
        this.gidFound = false;
        this.source = null;
        this.eweightFound = false;
        this.gweightFound = false;
        this.geneHeaderInfo.clear();
        this.arrayHeaderInfo.clear();
        this.atrHeaderInfo.clear();
        this.gtrHeaderInfo.clear();
        this.dataMatrix.clear();
    }

    public String toString() {
        String[] strings = this.toStrings();
        String msg = "";
        for (int i = 0; i < strings.length; ++i) {
            msg = msg + strings[i] + "\n";
        }
        return msg;
    }

    public String[] toStrings() {
        String[] msg = new String[]{"Selected TVModel Stats", "Source = " + this.getSource(), "Nexpr   = " + this.nExpr(), "NGeneHeader = " + this.getGeneHeaderInfo().getNumNames(), "Ngene   = " + this.nGene(), "eweight  = " + this.eweightFound, "gweight  = " + this.gweightFound, "aid  = " + this.aidFound, "gid  = " + this.gidFound};
        return msg;
    }

    public void removeAppended() {
        if (this.appendIndex == -1) {
            return;
        }
        int ngene = this.nGene();
        int nexpr = this.nExpr();
        double[] temp = new double[ngene * this.appendIndex];
        int i = 0;
        for (int g = 0; g < this.dataMatrix.getNumRow(); ++g) {
            for (int e = 0; e < nexpr; ++e) {
                if (e >= this.appendIndex) continue;
                temp[i++] = this.getValue(e, g);
            }
        }
        this.dataMatrix.setExprData(temp);
        String[][] tempS = new String[this.appendIndex][];
        for (int j = 0; j < this.appendIndex; ++j) {
            tempS[j] = this.arrayHeaderInfo.getHeader(j);
        }
        this.arrayHeaderInfo.setHeaderArray(tempS);
        nexpr = this.appendIndex;
        this.appendIndex = -1;
        this.setChanged();
    }

    public void append(DataModel m) {
        int j;
        int ngene = this.nGene();
        int nexpr = this.nExpr();
        if (m == null || m.getDataMatrix().getNumRow() != ngene || this.appendIndex != -1) {
            System.out.println("Could not compare.");
            return;
        }
        double[] temp = new double[this.getDataMatrix().getNumRow() * this.getDataMatrix().getNumCol() + m.getDataMatrix().getNumRow() * (m.getDataMatrix().getNumCol() + 1)];
        int i = 0;
        for (int g = 0; g < m.getDataMatrix().getNumRow(); ++g) {
            for (int e = 0; e < nexpr + m.getDataMatrix().getNumCol() + 1; ++e) {
                temp[i++] = e < nexpr ? this.getValue(e, g) : (e < nexpr + 1 ? -1.0E7 : m.getDataMatrix().getValue(e - nexpr - 1, g));
            }
        }
        String[][] tempS = new String[this.getArrayHeaderInfo().getNumHeaders() + m.getArrayHeaderInfo().getNumHeaders() + 1][];
        i = 0;
        for (j = 0; j < this.getArrayHeaderInfo().getNumHeaders(); ++j) {
            tempS[i++] = this.getArrayHeaderInfo().getHeader(j);
        }
        tempS[i] = new String[this.getArrayHeaderInfo().getNumNames()];
        for (j = 0; j < tempS[i].length; ++j) {
            tempS[i][j] = "-----------------------";
        }
        ++i;
        for (j = 0; j < this.getArrayHeaderInfo().getNumHeaders(); ++j) {
            tempS[i++] = this.getArrayHeaderInfo().getHeader(j);
        }
        this.arrayHeaderInfo.setHeaderArray(tempS);
        this.appendIndex = nexpr;
        nexpr += m.getDataMatrix().getNumCol() + 1;
        this.dataMatrix.setExprData(temp);
        this.setChanged();
    }

    public void setAtrHeaders(String[][] atrHeaders) {
        this.atrHeaderInfo.setHeaderArray(atrHeaders);
    }

    public void setAtrPrefix(String[] atrPrefix) {
        this.atrHeaderInfo.setPrefixArray(atrPrefix);
    }

    public void setGtrHeaders(String[][] gtrHeaders) {
        this.gtrHeaderInfo.setHeaderArray(gtrHeaders);
    }

    public void setGtrPrefix(String[] gtrPrefix) {
        this.gtrHeaderInfo.setPrefixArray(gtrPrefix);
    }

    public void setArrayHeaders(String[][] newHeaders) {
        this.arrayHeaderInfo.setHeaderArray(newHeaders);
    }

    public void setArrayPrefix(String[] newPrefix) {
        this.arrayHeaderInfo.setPrefixArray(newPrefix);
    }

    public void setGenePrefix(String[] newVal) {
        this.geneHeaderInfo.setPrefixArray(newVal);
    }

    public void setGeneHeaders(String[][] newVal) {
        this.geneHeaderInfo.setHeaderArray(newVal);
    }

    public void loadNew(FileSet fileSet) throws LoadException {
    }

    public void loadNewNW(FileSet fileSet) throws LoadException {
    }

    public void setEweightFound(boolean b) {
        this.eweightFound = b;
    }

    public void setGweightFound(boolean b) {
        this.gweightFound = b;
    }

    public boolean getModified() {
        return this.getGtrHeaderInfo().getModified() || this.getAtrHeaderInfo().getModified();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isSymmetrical() {
        return false;
    }

    class IntHeaderInfo
    extends Observable
    implements HeaderInfo {
        private String[] prefixArray = new String[0];
        private String[][] headerArray = new String[0][];
        private Hashtable id2row = new Hashtable();
        private boolean modified = false;

        IntHeaderInfo() {
        }

        public void hashIDs(String header) {
            int index = this.getIndex(header);
            this.id2row = TVModel.this.populateHash((HeaderInfo)this, index, this.id2row);
        }

        public void clear() {
            this.prefixArray = new String[0];
            this.headerArray = new String[0][];
            this.id2row.clear();
        }

        public void setPrefixArray(String[] newVal) {
            this.prefixArray = newVal;
        }

        public void setHeaderArray(String[][] newVal) {
            this.headerArray = newVal;
        }

        public String[] getNames() {
            return this.prefixArray;
        }

        public int getNumNames() {
            return this.prefixArray.length;
        }

        public int getNumHeaders() {
            return this.headerArray.length;
        }

        public String[] getHeader(int gene) {
            try {
                if (this.headerArray[gene] == null) {
                    return new String[0];
                }
                return this.headerArray[gene];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("error: tried to retrieve header for  index " + gene + " but max is " + this.headerArray.length);
                e.printStackTrace();
                return new String[0];
            }
        }

        public String getHeader(int gene, String col) {
            int index = this.getIndex(col);
            if (index == -1) {
                return null;
            }
            return this.getHeader(gene, index);
        }

        public String getHeader(int rowIndex, int columnIndex) {
            return this.getHeader(rowIndex)[columnIndex];
        }

        public int getIndex(String header) {
            for (int i = 0; i < this.prefixArray.length; ++i) {
                if (!header.equalsIgnoreCase(this.prefixArray[i])) continue;
                return i;
            }
            return -1;
        }

        public int getHeaderIndex(String id) {
            Object ind = this.id2row.get(id);
            if (ind == null) {
                return -1;
            }
            return (Integer)ind;
        }

        public boolean addName(String name, int index) {
            int col;
            int existing = this.getIndex(name);
            if (existing != -1) {
                return false;
            }
            int newNumNames = this.getNumNames() + 1;
            for (int row = 0; row < this.getNumHeaders(); ++row) {
                int col2;
                String[] from = this.headerArray[row];
                String[] to = new String[newNumNames];
                for (col2 = 0; col2 < index; ++col2) {
                    to[col2] = from[col2];
                }
                for (col2 = index + 1; col2 < newNumNames; ++col2) {
                    to[col2] = from[col2 - 1];
                }
                this.headerArray[row] = to;
            }
            String[] newPrefix = new String[newNumNames];
            for (col = 0; col < index; ++col) {
                newPrefix[col] = this.prefixArray[col];
            }
            newPrefix[index] = name;
            for (col = index + 1; col < newNumNames; ++col) {
                newPrefix[col] = this.prefixArray[col - 1];
            }
            this.prefixArray = newPrefix;
            this.setModified(true);
            return true;
        }

        public boolean setHeader(int i, String name, String value) {
            if (this.headerArray.length < i) {
                return false;
            }
            int nameIndex = this.getIndex(name);
            if (nameIndex == -1) {
                return false;
            }
            if (this.headerArray[i][nameIndex] == value) {
                return false;
            }
            this.headerArray[i][nameIndex] = value;
            this.setModified(true);
            return true;
        }

        public boolean getModified() {
            return this.modified;
        }

        public void setModified(boolean mod) {
            this.setChanged();
            this.notifyObservers();
            this.modified = mod;
        }
    }

    class GeneHeaderInfo
    extends IntHeaderInfo {
        GeneHeaderInfo() {
        }

        public int getAIDIndex() {
            return 1;
        }

        public int getGIDIndex() {
            return 0;
        }

        public int getYorfIndex() {
            if (this.getIndex("GID") == -1) {
                return 0;
            }
            return 1;
        }

        public int getNameIndex() {
            if (this.getIndex("GID") == -1) {
                return 1;
            }
            return 2;
        }

        public int getIndex(String header) {
            int retval = super.getIndex(header);
            if (retval != -1) {
                return retval;
            }
            if (header.equals("YORF")) {
                return this.getYorfIndex();
            }
            if (header.equals("NAME")) {
                return this.getNameIndex();
            }
            return -1;
        }
    }

    class TVDataMatrix
    implements DataMatrix {
        private double[] exprData = null;
        private double maxValue = Double.MIN_VALUE;
        private double minValue = Double.MAX_VALUE;

        TVDataMatrix() {
        }

        public void clear() {
            this.exprData = null;
        }

        public double getValue(int x, int y) {
            int nexpr = TVModel.this.nExpr();
            int ngene = TVModel.this.nGene();
            if (x < nexpr && y < ngene && x >= 0 && y >= 0) {
                return this.exprData[x + y * nexpr];
            }
            return -1.0E7;
        }

        public void setExprData(double[] newData) {
            this.exprData = newData;
            for (int i = 0; i < newData.length; ++i) {
                this.updateMinMax(newData[i]);
            }
        }

        public void setValue(double value, int x, int y) {
            this.updateMinMax(value);
            this.exprData[x + y * this.getNumCol()] = value;
            TVModel.this.setChanged();
        }

        public int getNumRow() {
            return TVModel.this.nGene();
        }

        public int getNumCol() {
            return TVModel.this.nExpr();
        }

        public int getNumUnappendedCol() {
            return TVModel.this.appendIndex == -1 ? this.getNumCol() : TVModel.this.appendIndex;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public double getMinValue() {
            return this.minValue;
        }

        private void updateMinMax(double value) {
            if (value != -1.0E7) {
                if (value < this.minValue) {
                    this.minValue = value;
                } else if (value > this.maxValue) {
                    this.maxValue = value;
                }
            }
        }
    }
}

