/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmeans.KMeansCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmedoid.KMedoidCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.KnnViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.KnnViewModel;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.TreeView;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.Properties;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.work.ProvidesTitle;

public class KnnView
extends TreeView {
    public static String SHORTNAME = "knnview";
    public static String NAME = "JTree KnnView";
    private static String appName = "ClusterManager KnnView";

    public KnnView(ClusterManager manager) {
        super(manager);
    }

    public KnnView(PropertyConfig propConfig) {
        super(propConfig);
    }

    public void setVisible(boolean visibility) {
        if (this.viewFrame != null) {
            this.viewFrame.setVisible(visibility);
        }
    }

    public String getAppName() {
        return appName;
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public boolean isAvailable() {
        return KnnView.isReady(this.myNetwork);
    }

    public static boolean isReady(CyNetwork network) {
        String type;
        if (network == null) {
            return false;
        }
        if (!(!ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__clusterType") || (type = (String)network.getRow((CyIdentifiable)network).get("__clusterType", String.class)).equals(KMeansCluster.GROUP_ATTRIBUTE) || type.equals(KMedoidCluster.GROUP_ATTRIBUTE) || type.equals("autosome_heatmap") || type.equals("pam") || type.equals("hopach"))) {
            return false;
        }
        return ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__nodeClusters") || ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__attrClusters");
    }

    protected void startup() {
        CyProperty cyProperty = this.manager.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.dataModel = new KnnViewModel(this.monitor, this.myNetwork, this.myView, this.manager);
        this.setConfigDefaults(new PropertyConfig((CyProperty<Properties>)cyProperty, KnnView.globalConfigName(), "ProgramConfig"));
        PropertyConfig documentConfig = new PropertyConfig((CyProperty<Properties>)cyProperty, this.getShortName(), "DocumentConfig");
        this.dataModel.setDocumentConfig(documentConfig);
        KnnViewFrame frame = new KnnViewFrame(this, appName);
        frame.setDataModel(this.dataModel);
        frame.setLoaded(true);
        frame.addWindowListener(this);
        frame.setVisible(true);
        this.geneSelection = frame.getGeneSelection();
        this.geneSelection.addObserver(this);
        this.arraySelection = frame.getArraySelection();
        this.arraySelection.addObserver(this);
        this.manager.registerService(this, RowsSetListener.class, new Properties());
    }
}

