/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.LineTypeVisualProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipEdges {
    private CyNetwork network = null;
    private CyNetworkView networkView = null;
    private CyTableManager tableManager = null;
    private ClusterManager manager;
    private CyTable FuzzyClusterTable = null;

    public MembershipEdges(CyNetwork network, CyNetworkView view, ClusterManager manager, CyTable FuzzyClusterTable) {
        this.network = network;
        this.networkView = view;
        this.tableManager = manager.getTableManager();
        this.manager = manager;
        this.FuzzyClusterTable = FuzzyClusterTable;
        this.createMembershipEdges();
    }

    private void createMembershipEdges() {
        ArrayList clusterList = new ArrayList();
        int numC = this.FuzzyClusterTable.getColumns().size() - 1;
        for (int i = 0; i < numC; ++i) {
            clusterList.add(new ArrayList());
        }
        List nodeList = this.network.getNodeList();
        for (CyNode cyNode : nodeList) {
            CyRow nodeRow = this.FuzzyClusterTable.getRow((Object)cyNode.getSUID());
            for (int i = 1; i <= numC; ++i) {
                if (nodeRow.get("Cluster_" + i, Double.class) == null) continue;
                ((List)clusterList.get(i - 1)).add(cyNode);
            }
        }
        for (List list : clusterList) {
            CyNode centroid = this.network.addNode();
            this.network.getRow((CyIdentifiable)centroid).set("name", (Object)("Centroid" + clusterList.indexOf(list)));
            double x = 1.0E-4;
            double y = 1.0E-4;
            double count = 0.0;
            for (CyNode node : list) {
                View nodeView = this.networkView.getNodeView(node);
                x += ((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION)).doubleValue();
                y += ((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)).doubleValue();
                count += 1.0;
                this.network.addEdge(centroid, node, false);
                this.networkView.updateView();
            }
            if (count != 0.0) {
                x /= count;
                y /= count;
            }
            View centroidView = this.networkView.getNodeView(centroid);
            centroidView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)x);
            centroidView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)y);
            List edgeList = this.network.getAdjacentEdgeList(centroid, CyEdge.Type.ANY);
            this.membershipEdgeStyle(clusterList.indexOf(list) + 1, edgeList, this.FuzzyClusterTable);
            this.networkView.updateView();
        }
    }

    private void membershipEdgeStyle(int cNum, List<CyEdge> edgeList, CyTable FuzzyClusterTable) {
        for (CyEdge edge : edgeList) {
            View edgeView = this.networkView.getEdgeView(edge);
            CyNode node = edge.getTarget();
            edgeView.setLockedValue(BasicVisualLexicon.EDGE_LINE_TYPE, (Object)LineTypeVisualProperty.DASH_DOT);
            edgeView.setLockedValue(BasicVisualLexicon.EDGE_TRANSPARENCY, (Object)((int)((Double)FuzzyClusterTable.getRow((Object)node.getSUID()).get("Cluster_" + cNum, Double.class) * 255.0)));
        }
    }
}

