/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import java.util.HashMap;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;

public class NetworkSelectionLinker
implements RowsSetListener {
    CyRootNetwork rootNetwork;
    CyEventHelper eventHelper;
    ClusterManager clusterManager;
    CyNetworkViewManager viewManager;
    boolean ignoreSelection = false;

    public NetworkSelectionLinker(CyRootNetwork rootNetwork, CyEventHelper eventHelper, ClusterManager mgr) {
        this.rootNetwork = rootNetwork;
        this.eventHelper = eventHelper;
        this.clusterManager = mgr;
        this.viewManager = this.clusterManager.getService(CyNetworkViewManager.class);
    }

    public void handleEvent(RowsSetEvent e) {
        if (!e.containsColumn("selected") || this.ignoreSelection) {
            return;
        }
        CyNetworkView currentNetworkView = this.clusterManager.getNetworkView();
        this.ignoreSelection = true;
        HashMap stateMap = new HashMap();
        for (CySubNetwork subNetwork : this.rootNetwork.getSubNetworkList()) {
            if (((CyTable)e.getSource()).equals(subNetwork.getTable(CyNode.class, "LOCAL_ATTRS"))) {
                for (RowSetRecord record : e.getColumnRecords("selected")) {
                    Long suid = (Long)record.getRow().get("SUID", Long.class);
                    Boolean value = (Boolean)record.getValue();
                    for (CySubNetwork sub2 : this.rootNetwork.getSubNetworkList()) {
                        if (subNetwork.equals(sub2) || sub2.getDefaultNodeTable().getRow((Object)suid) == null) continue;
                        sub2.getDefaultNodeTable().getRow((Object)suid).set("selected", (Object)value);
                    }
                }
            }
            if (!this.viewManager.viewExists((CyNetwork)subNetwork)) continue;
            for (CyNetworkView view : this.viewManager.getNetworkViews((CyNetwork)subNetwork)) {
                if (view.equals(currentNetworkView)) continue;
                view.updateView();
            }
        }
        this.eventHelper.flushPayloadEvents();
        this.ignoreSelection = false;
    }
}

