/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterVizFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkViewContext;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewNetworkViewFactory
implements ClusterVizFactory {
    ClusterManager clusterManager;
    NewNetworkViewContext context = new NewNetworkViewContext();
    boolean checkAvailable;

    public NewNetworkViewFactory(ClusterManager clusterManager, boolean checkAvailable) {
        this.clusterManager = clusterManager;
        this.checkAvailable = checkAvailable;
    }

    @Override
    public String getName() {
        if (this.checkAvailable) {
            return NewNetworkView.CLUSTERNAME;
        }
        return NewNetworkView.ATTRIBUTENAME;
    }

    @Override
    public String getShortName() {
        if (this.checkAvailable) {
            return NewNetworkView.CLUSTERSHORTNAME;
        }
        return NewNetworkView.ATTRSHORTNAME;
    }

    @Override
    public ClusterViz getVisualizer() {
        return null;
    }

    public boolean isReady() {
        if (!this.checkAvailable) {
            return true;
        }
        return NewNetworkView.isReady(this.clusterManager.getNetwork(), this.clusterManager);
    }

    @Override
    public boolean isAvailable(CyNetwork network) {
        if (!this.checkAvailable) {
            return true;
        }
        if (network == null) {
            return false;
        }
        return NewNetworkView.isReady(network, this.clusterManager);
    }

    @Override
    public List<ClusterTaskFactory.ClusterType> getTypeList() {
        return Collections.singletonList(ClusterTaskFactory.ClusterType.UI);
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new NewNetworkView(this.context, this.clusterManager, this.checkAvailable)});
    }
}

