/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.ui.MonitorableTask;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDistances
implements MonitorableTask {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected List<CyNode> nodesList;
    protected CyNetwork network;
    protected int[][] distances;
    protected boolean directed;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;
    protected Map<Long, Integer> nodeIndexToMatrixIndexMap;

    public NodeDistances(List<CyNode> nodesList, CyNetwork network, Map<Long, Integer> nodeIndexToMatrixIndexMap) {
        this.nodesList = nodesList;
        this.nodeIndexToMatrixIndexMap = nodeIndexToMatrixIndexMap;
        this.network = network;
        this.distances = new int[nodesList.size()][];
        this.directed = false;
    }

    @Override
    public void start(boolean return_when_done) {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                return new NodeDistancesTask();
            }
        };
        worker.execute();
        if (return_when_done) {
            try {
                worker.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean wasCanceled() {
        return this.canceled;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    @Override
    public String getTaskDescription() {
        return "Calculating Node Distances";
    }

    @Override
    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public int[][] calculate() {
        int index;
        CyNode from_node;
        this.currentProgress = 0;
        this.lengthOfTask = this.distances.length;
        this.done = false;
        this.canceled = false;
        CyNode[] nodes = new CyNode[this.nodesList.size()];
        Integer[] integers = new Integer[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            from_node = this.nodesList.get(i);
            if (from_node == null) continue;
            index = this.nodeIndexToMatrixIndexMap.get(from_node.getSUID());
            if (index < 0 || index >= nodes.length) {
                System.err.println("WARNING: GraphNode \"" + from_node + "\" has an index value that is out of range: " + index + ".  Graph indices should be maintained such " + "that no index is unused.");
                return null;
            }
            if (nodes[index] != null) {
                System.err.println("WARNING: GraphNode \"" + from_node + "\" has an index value ( " + index + " ) that is the same as " + "that of another GraphNode ( \"" + nodes[index] + "\" ).  Graph indices should be maintained such " + "that indices are unique.");
                return null;
            }
            nodes[index] = from_node;
            integers[index] = index;
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        boolean[] completed_nodes = new boolean[nodes.length];
        for (int from_node_index = 0; from_node_index < nodes.length; ++from_node_index) {
            if (this.canceled) {
                this.distances = null;
                return this.distances;
            }
            from_node = nodes[from_node_index];
            if (from_node == null) {
                if (this.distances[from_node_index] == null) {
                    this.distances[from_node_index] = new int[nodes.length];
                }
                Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
                continue;
            }
            if (this.distances[from_node_index] == null) {
                this.distances[from_node_index] = new int[nodes.length];
            }
            Arrays.fill(this.distances[from_node_index], Integer.MAX_VALUE);
            this.distances[from_node_index][from_node_index] = 0;
            Arrays.fill(completed_nodes, false);
            queue.add(integers[from_node_index]);
            while (!queue.isEmpty()) {
                if (this.canceled) {
                    this.distances = null;
                    return this.distances;
                }
                index = (Integer)queue.removeFirst();
                if (completed_nodes[index]) continue;
                completed_nodes[index] = true;
                CyNode to_node = nodes[index];
                int to_node_distance = this.distances[from_node_index][index];
                if (index < from_node_index) {
                    for (int i = 0; i < nodes.length; ++i) {
                        int distance_through_to_node;
                        if (this.distances[index][i] == Integer.MAX_VALUE || (distance_through_to_node = to_node_distance + this.distances[index][i]) > this.distances[from_node_index][i]) continue;
                        if (this.distances[index][i] == 1) {
                            completed_nodes[i] = true;
                        }
                        this.distances[from_node_index][i] = distance_through_to_node;
                    }
                    continue;
                }
                Collection<CyNode> neighbors = this.getNeighbors(to_node);
                for (CyNode neighbor : neighbors) {
                    if (this.canceled) {
                        this.distances = null;
                        return this.distances;
                    }
                    int neighbor_index = this.nodeIndexToMatrixIndexMap.get(neighbor.getSUID());
                    if (nodes[neighbor_index] == null) {
                        this.distances[from_node_index][neighbor_index] = Integer.MAX_VALUE;
                        continue;
                    }
                    if (completed_nodes[neighbor_index]) continue;
                    int neighbor_distance = this.distances[from_node_index][neighbor_index];
                    if (to_node_distance == Integer.MAX_VALUE || neighbor_distance <= to_node_distance + 1) continue;
                    this.distances[from_node_index][neighbor_index] = to_node_distance + 1;
                    queue.addLast(integers[neighbor_index]);
                }
            }
            ++this.currentProgress;
            double percentDone = (double)(this.currentProgress * 100) / (double)this.lengthOfTask;
            this.statusMessage = "Completed " + percentDone + "%.";
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
        return this.distances;
    }

    public int[][] getDistances() {
        return this.distances;
    }

    private Collection<CyNode> getNeighbors(CyNode node) {
        HashSet<CyNode> result = new HashSet<CyNode>();
        List edges = this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY);
        if (edges == null || edges.size() == 0) {
            return result;
        }
        Long targetID = node.getSUID();
        for (CyEdge curEdge : edges) {
            if (curEdge.getSource().getSUID() != targetID) {
                result.add(curEdge.getSource());
                continue;
            }
            if (curEdge.getTarget().getSUID() == targetID) continue;
            result.add(curEdge.getTarget());
        }
        return result;
    }

    class NodeDistancesTask {
        NodeDistancesTask() {
            NodeDistances.this.calculate();
        }
    }
}

