/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterTaskFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.ResultsPanel;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsPanelTask
extends AbstractTask
implements ClusterViz,
ClusterAlgorithm {
    private static String appName = "ClusterMaker Results Panel";
    private boolean checkForAvailability = false;
    private ClusterManager manager;
    private String clusterAttribute = null;
    public static String CLUSTERNAME = "Create Results Panel from Clusters";
    public static String CLUSTERSHORTNAME = "clusterResultsPanel";
    public ResultsPanel resultsPanel;
    private final CyServiceRegistrar registrar;
    public List<NodeCluster> clusters;
    public AbstractClusterResults clusterResults;
    private CyNetworkView networkView;
    public boolean createFlag;
    @Tunable(description="Network to look for cluster", context="nogui")
    public CyNetwork network = null;

    public ResultsPanelTask(CyNetwork network, ClusterManager manager, List<NodeCluster> clusters, boolean createFlag) {
        this(manager, true, createFlag);
        this.network = network;
    }

    public ResultsPanelTask(ClusterManager manager, boolean available, boolean createFlag) {
        this.manager = manager;
        this.createFlag = createFlag;
        this.networkView = manager.getNetworkView();
        this.registrar = manager.getService(CyServiceRegistrar.class);
        this.checkForAvailability = available;
        if (this.network == null) {
            this.network = manager.getNetwork();
        }
    }

    public List<NodeCluster> getClusters() {
        Serializable cluster2;
        ArrayList<NodeCluster> clusters = new ArrayList<NodeCluster>();
        ArrayList<List<CyNode>> clusterList = new ArrayList<List<CyNode>>();
        this.clusterAttribute = (String)this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").get("__clusterAttribute", String.class);
        HashMap clusterMap = new HashMap();
        for (CyNode node : this.network.getNodeList()) {
            if (!ModelUtils.hasAttribute(this.network, (CyIdentifiable)node, this.clusterAttribute)) continue;
            cluster2 = (Integer)this.network.getRow((CyIdentifiable)node).get(this.clusterAttribute, Integer.class);
            if (!clusterMap.containsKey(cluster2)) {
                clusterMap.put(cluster2, new ArrayList());
            }
            ((ArrayList)clusterMap.get(cluster2)).add(node);
        }
        Iterator<Object> i$ = clusterMap.keySet().iterator();
        while (i$.hasNext()) {
            int clustNum = (Integer)i$.next();
            cluster2 = new NodeCluster((Collection)clusterMap.get(clustNum));
            clusterList.add((List<CyNode>)clusterMap.get(clustNum));
            ((NodeCluster)cluster2).setClusterNumber(clustNum);
            clusters.add((NodeCluster)cluster2);
        }
        this.clusterResults = new AbstractClusterResults(this.network, clusterList);
        List<Double> modularityList = this.clusterResults.getModularityList();
        for (int i = 0; i < clusters.size(); ++i) {
            ((NodeCluster)clusters.get(i)).setClusterScore(modularityList.get(i));
        }
        return clusters;
    }

    @Override
    public void run(TaskMonitor monitor) {
        if (this.createFlag) {
            monitor.setTitle("Creating a new results panel with cluster results");
            this.clusters = this.getClusters();
            this.resultsPanel = new ResultsPanel(this.clusters, this.clusterResults, this.network, this.networkView, this.manager, monitor);
            this.registrar.registerService((Object)this.resultsPanel, CytoPanelComponent.class, new Properties());
            this.manager.setResultsPanel(this.resultsPanel);
        } else {
            monitor.setTitle("Deleting the results panel");
            this.resultsPanel = this.manager.getResultsPanel();
            this.registrar.unregisterService((Object)this.resultsPanel, CytoPanelComponent.class);
            this.manager.setResultsPanel(null);
        }
    }

    @Override
    public ClusterResults getResults() {
        return null;
    }

    @Override
    public String getShortName() {
        if (this.checkForAvailability) {
            return CLUSTERSHORTNAME;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.checkForAvailability) {
            return CLUSTERNAME;
        }
        return null;
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        boolean available = ResultsPanelTask.isReady(this.network, this.manager);
        this.clusterAttribute = (String)this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").get("__clusterAttribute", String.class);
        return available;
    }

    public static boolean isReady(CyNetwork network, ClusterManager manager) {
        String clusterAttribute;
        if (network == null) {
            return false;
        }
        CyTable networkTable = network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        if (!CyTableUtil.getColumnNames((CyTable)networkTable).contains("__clusterType")) {
            return false;
        }
        String cluster_type = (String)network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").get("__clusterType", String.class);
        if (!(manager.getAlgorithm(cluster_type) == null || manager.getAlgorithm(cluster_type) != null && manager.getAlgorithm(cluster_type).getTypeList().contains((Object)ClusterTaskFactory.ClusterType.NETWORK))) {
            return false;
        }
        return CyTableUtil.getColumnNames((CyTable)networkTable).contains("__clusterAttribute") && (clusterAttribute = (String)network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").get("__clusterAttribute", String.class)) != null;
    }
}

