/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.ui.NodeDistances;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringEmbeddedLayouter {
    public static final int DEFAULT_NUM_LAYOUT_PASSES = 2;
    public static final double DEFAULT_AVERAGE_ITERATIONS_PER_NODE = 20.0;
    public static final double[] DEFAULT_NODE_DISTANCE_SPRING_SCALARS = new double[]{1.0, 1.0};
    public static final double DEFAULT_NODE_DISTANCE_STRENGTH_CONSTANT = 15.0;
    public static final double DEFAULT_NODE_DISTANCE_REST_LENGTH_CONSTANT = 200.0;
    public static final double DEFAULT_DISCONNECTED_NODE_DISTANCE_SPRING_STRENGTH = 0.05;
    public static final double DEFAULT_DISCONNECTED_NODE_DISTANCE_SPRING_REST_LENGTH = 2500.0;
    public static final double[] DEFAULT_ANTICOLLISION_SPRING_SCALARS = new double[]{0.0, 1.0};
    public static final double DEFAULT_ANTICOLLISION_SPRING_STRENGTH = 100.0;
    protected int numLayoutPasses = 2;
    protected double averageIterationsPerNode = 20.0;
    protected double[] nodeDistanceSpringScalars = DEFAULT_NODE_DISTANCE_SPRING_SCALARS;
    protected double nodeDistanceStrengthConstant = 15.0;
    protected double nodeDistanceRestLengthConstant = 200.0;
    protected double disconnectedNodeDistanceSpringStrength = 0.05;
    protected double disconnectedNodeDistanceSpringRestLength = 2500.0;
    protected double[][] nodeDistanceSpringStrengths;
    protected double[][] nodeDistanceSpringRestLengths;
    protected double[] anticollisionSpringScalars = DEFAULT_ANTICOLLISION_SPRING_SCALARS;
    protected double anticollisionSpringStrength = 100.0;
    protected CyNetworkView graphView;
    protected int nodeCount;
    protected int edgeCount;
    protected int layoutPass;
    protected Map<Long, Integer> nodeIndexToMatrixIndexMap;
    protected SortedMap<Integer, Long> matrixIndexToNodeIndexMap;
    private boolean interrupted;

    public SpringEmbeddedLayouter() {
    }

    public SpringEmbeddedLayouter(CyNetworkView graph_view) {
        this.setGraphView(graph_view);
        this.initializeSpringEmbeddedLayouter();
    }

    public void setGraphView(CyNetworkView new_graph_view) {
        this.graphView = new_graph_view;
    }

    public View<CyNetwork> getGraphView() {
        return this.graphView;
    }

    protected void initializeSpringEmbeddedLayouter() {
    }

    public void interruptDoLayout() {
        this.interrupted = true;
    }

    public void resetDoLayout() {
        this.interrupted = false;
    }

    public boolean doLayout(double weightLayout, double goalTotal, double progress) {
        this.nodeCount = ((CyNetwork)this.graphView.getModel()).getNodeCount();
        this.edgeCount = ((CyNetwork)this.graphView.getModel()).getEdgeCount();
        this.nodeIndexToMatrixIndexMap = new HashMap<Long, Integer>();
        this.matrixIndexToNodeIndexMap = new TreeMap<Integer, Long>();
        Iterator nodes = ((CyNetwork)this.graphView.getModel()).getNodeList().iterator();
        int count = 0;
        while (nodes.hasNext()) {
            CyNode n = (CyNode)nodes.next();
            this.nodeIndexToMatrixIndexMap.put(n.getSUID(), count);
            this.matrixIndexToNodeIndexMap.put(count, n.getSUID());
            ++count;
        }
        double euclidean_distance_threshold = 0.5 * (double)(this.nodeCount + this.edgeCount);
        int num_iterations = (int)((double)this.nodeCount * this.averageIterationsPerNode / (double)this.numLayoutPasses);
        List<PartialDerivatives> partials_list = this.createPartialsList();
        PotentialEnergy potential_energy = new PotentialEnergy();
        PartialDerivatives furthest_node_partials = null;
        this.layoutPass = 0;
        while (this.layoutPass < this.numLayoutPasses) {
            this.setupForLayoutPass();
            potential_energy.reset();
            partials_list.clear();
            for (View node_view : this.graphView.getNodeViews()) {
                PartialDerivatives partials = new PartialDerivatives((View<CyNode>)node_view);
                this.calculatePartials(partials, null, potential_energy, false);
                partials_list.add(partials);
                if (furthest_node_partials != null && !(partials.euclideanDistance > furthest_node_partials.euclideanDistance)) continue;
                furthest_node_partials = partials;
            }
            for (int iterations_i = 0; iterations_i < num_iterations && furthest_node_partials.euclideanDistance >= euclidean_distance_threshold; ++iterations_i) {
                if (this.interrupted) {
                    System.err.println("Interrupted: Layouter");
                    this.resetDoLayout();
                    return false;
                }
                furthest_node_partials = this.moveNode(furthest_node_partials, partials_list, potential_energy);
                progress += 100.0 * (1.0 / (double)(num_iterations * this.numLayoutPasses)) * (weightLayout / goalTotal);
            }
            ++this.layoutPass;
        }
        this.resetDoLayout();
        return true;
    }

    protected void setupForLayoutPass() {
        this.setupNodeDistanceSprings();
    }

    protected void setupNodeDistanceSprings() {
        if (this.layoutPass != 0) {
            return;
        }
        this.nodeDistanceSpringRestLengths = new double[this.nodeCount][this.nodeCount];
        this.nodeDistanceSpringStrengths = new double[this.nodeCount][this.nodeCount];
        if (this.nodeDistanceSpringScalars[this.layoutPass] == 0.0) {
            return;
        }
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        Collection<Long> matrixIndices = this.matrixIndexToNodeIndexMap.values();
        int i = 0;
        for (Long nodeId : matrixIndices) {
            nodeList.add(i, ((CyNetwork)this.graphView.getModel()).getNode(nodeId.longValue()));
            ++i;
        }
        NodeDistances ind = new NodeDistances(nodeList, (CyNetwork)this.graphView.getModel(), this.nodeIndexToMatrixIndexMap);
        int[][] node_distances = ind.calculate();
        if (node_distances == null) {
            return;
        }
        double node_distance_strength_constant = this.nodeDistanceStrengthConstant;
        double node_distance_rest_length_constant = this.nodeDistanceRestLengthConstant;
        for (int node_i = 0; node_i < this.nodeCount; ++node_i) {
            for (int node_j = node_i + 1; node_j < this.nodeCount; ++node_j) {
                this.nodeDistanceSpringRestLengths[node_i][node_j] = node_distances[node_i][node_j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringRestLength : node_distance_rest_length_constant * (double)node_distances[node_i][node_j];
                this.nodeDistanceSpringRestLengths[node_j][node_i] = this.nodeDistanceSpringRestLengths[node_i][node_j];
                this.nodeDistanceSpringStrengths[node_i][node_j] = node_distances[node_i][node_j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringStrength : node_distance_strength_constant / (double)(node_distances[node_i][node_j] * node_distances[node_i][node_j]);
                this.nodeDistanceSpringStrengths[node_j][node_i] = this.nodeDistanceSpringStrengths[node_i][node_j];
            }
        }
    }

    protected PartialDerivatives calculatePartials(PartialDerivatives partials, List<PartialDerivatives> partials_list, PotentialEnergy potential_energy, boolean reversed) {
        partials.reset();
        View<CyNode> nodeView = partials.getNodeView();
        int node_view_index = this.nodeIndexToMatrixIndexMap.get(((CyNode)nodeView.getModel()).getSUID());
        double node_view_radius = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
        double node_view_x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        double node_view_y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        PartialDerivatives other_node_partials = null;
        View<CyNode> other_node_view = null;
        PartialDerivatives furthest_partials = null;
        Iterator<PartialDerivatives> iterator = partials_list == null ? this.graphView.getNodeViews().iterator() : partials_list.iterator();
        while (iterator.hasNext()) {
            if (partials_list == null) {
                other_node_view = (View<CyNode>)iterator.next();
            } else {
                other_node_partials = iterator.next();
                other_node_view = other_node_partials.getNodeView();
            }
            if (((CyNode)nodeView.getModel()).getSUID() == ((CyNode)other_node_view.getModel()).getSUID()) continue;
            int other_node_view_index = this.nodeIndexToMatrixIndexMap.get(((CyNode)other_node_view.getModel()).getSUID());
            double other_node_view_radius = Math.max((Double)other_node_view.getVisualProperty(BasicVisualLexicon.NODE_WIDTH), (Double)other_node_view.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT));
            double delta_x = node_view_x - (Double)other_node_view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double delta_y = node_view_y - (Double)other_node_view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double euclidean_distance = Math.sqrt(delta_x * delta_x + delta_y * delta_y);
            double euclidean_distance_cubed = Math.pow(euclidean_distance, 3.0);
            double distance_from_touching = euclidean_distance - (node_view_radius + other_node_view_radius);
            double incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (delta_x - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * delta_x / euclidean_distance));
            if (!reversed) {
                partials.x += incremental_change;
            }
            if (other_node_partials != null) {
                incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[other_node_view_index][node_view_index] * (-delta_x - this.nodeDistanceSpringRestLengths[other_node_view_index][node_view_index] * -delta_x / euclidean_distance));
                other_node_partials.x = reversed ? (other_node_partials.x -= incremental_change) : (other_node_partials.x += incremental_change);
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (delta_x - (node_view_radius + other_node_view_radius) * delta_x / euclidean_distance));
                if (!reversed) {
                    partials.x += incremental_change;
                }
                if (other_node_partials != null) {
                    incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-delta_x - (node_view_radius + other_node_view_radius) * -delta_x / euclidean_distance));
                    other_node_partials.x = reversed ? (other_node_partials.x -= incremental_change) : (other_node_partials.x += incremental_change);
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (delta_y - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * delta_y / euclidean_distance));
            if (!reversed) {
                partials.y += incremental_change;
            }
            if (other_node_partials != null) {
                incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[other_node_view_index][node_view_index] * (-delta_y - this.nodeDistanceSpringRestLengths[other_node_view_index][node_view_index] * -delta_y / euclidean_distance));
                other_node_partials.y = reversed ? (other_node_partials.y -= incremental_change) : (other_node_partials.y += incremental_change);
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (delta_y - (node_view_radius + other_node_view_radius) * delta_y / euclidean_distance));
                if (!reversed) {
                    partials.y += incremental_change;
                }
                if (other_node_partials != null) {
                    incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-delta_y - (node_view_radius + other_node_view_radius) * -delta_y / euclidean_distance));
                    other_node_partials.y = reversed ? (other_node_partials.y -= incremental_change) : (other_node_partials.y += incremental_change);
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (1.0 - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_y * delta_y) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.xx -= incremental_change;
                }
            } else {
                partials.xx += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.xx += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (node_view_radius + other_node_view_radius) * (delta_y * delta_y) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.xx -= incremental_change;
                    }
                } else {
                    partials.xx += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.xx += incremental_change;
                    }
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (1.0 - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_x * delta_x) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.yy -= incremental_change;
                }
            } else {
                partials.yy += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.yy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (node_view_radius + other_node_view_radius) * (delta_x * delta_x) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.yy -= incremental_change;
                    }
                } else {
                    partials.yy += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.yy += incremental_change;
                    }
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_x * delta_y) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.xy -= incremental_change;
                }
            } else {
                partials.xy += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.xy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * ((node_view_radius + other_node_view_radius) * (delta_x * delta_y) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.xy -= incremental_change;
                    }
                } else {
                    partials.xy += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.xy += incremental_change;
                    }
                }
            }
            double distance_from_rest = euclidean_distance - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index];
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (distance_from_rest * distance_from_rest) / 2.0);
            if (reversed) {
                if (other_node_partials != null) {
                    potential_energy.totalEnergy -= incremental_change;
                }
            } else {
                potential_energy.totalEnergy += incremental_change;
                if (other_node_partials != null) {
                    potential_energy.totalEnergy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (distance_from_touching * distance_from_touching) / 2.0);
                if (reversed) {
                    if (other_node_partials != null) {
                        potential_energy.totalEnergy -= incremental_change;
                    }
                } else {
                    potential_energy.totalEnergy += incremental_change;
                    if (other_node_partials != null) {
                        potential_energy.totalEnergy += incremental_change;
                    }
                }
            }
            if (other_node_partials == null) continue;
            other_node_partials.euclideanDistance = Math.sqrt(other_node_partials.x * other_node_partials.x + other_node_partials.y * other_node_partials.y);
            if (furthest_partials != null && !(other_node_partials.euclideanDistance > furthest_partials.euclideanDistance)) continue;
            furthest_partials = other_node_partials;
        }
        if (!reversed) {
            partials.euclideanDistance = Math.sqrt(partials.x * partials.x + partials.y * partials.y);
        }
        if (furthest_partials == null || partials.euclideanDistance > furthest_partials.euclideanDistance) {
            furthest_partials = partials;
        }
        return furthest_partials;
    }

    protected PartialDerivatives moveNode(PartialDerivatives partials, List<PartialDerivatives> partials_list, PotentialEnergy potential_energy) {
        PartialDerivatives starting_partials = new PartialDerivatives(partials);
        this.calculatePartials(partials, partials_list, potential_energy, true);
        this.simpleMoveNode(starting_partials);
        return this.calculatePartials(partials, partials_list, potential_energy, false);
    }

    protected void simpleMoveNode(PartialDerivatives partials) {
        View<CyNode> node_view = partials.getNodeView();
        double denomenator = partials.xx * partials.yy - partials.xy * partials.xy;
        double delta_x = (-partials.x * partials.yy - -partials.y * partials.xy) / denomenator;
        double delta_y = (-partials.y * partials.xx - -partials.x * partials.xy) / denomenator;
        double x = (Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        double y = (Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        node_view.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)(x + delta_x));
        node_view.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)(y + delta_y));
    }

    protected List<PartialDerivatives> createPartialsList() {
        return new ArrayList<PartialDerivatives>();
    }

    static class PotentialEnergy {
        public double totalEnergy = 0.0;

        PotentialEnergy() {
        }

        public void reset() {
            this.totalEnergy = 0.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PartialDerivatives {
        protected View<CyNode> nodeView;
        public double x;
        public double y;
        public double xx;
        public double yy;
        public double xy;
        public double euclideanDistance;

        public PartialDerivatives(View<CyNode> nodeView) {
            this.nodeView = nodeView;
        }

        public PartialDerivatives(PartialDerivatives copy_from) {
            this.nodeView = copy_from.getNodeView();
            this.copyFrom(copy_from);
        }

        public View<CyNode> getNodeView() {
            return this.nodeView;
        }

        public void copyFrom(PartialDerivatives other_partial_derivatives) {
            this.x = other_partial_derivatives.x;
            this.y = other_partial_derivatives.y;
            this.xx = other_partial_derivatives.xx;
            this.yy = other_partial_derivatives.yy;
            this.xy = other_partial_derivatives.xy;
            this.euclideanDistance = other_partial_derivatives.euclideanDistance;
        }

        public void reset() {
            this.x = 0.0;
            this.y = 0.0;
            this.xx = 0.0;
            this.yy = 0.0;
            this.xy = 0.0;
            this.euclideanDistance = 0.0;
        }

        public String toString() {
            return "PartialDerivatives( \"" + this.getNodeView() + "\", x=" + this.x + ", y=" + this.y + ", xx=" + this.xx + ", yy=" + this.yy + ", xy=" + this.xy + ", euclideanDistance=" + this.euclideanDistance + " )";
        }
    }
}

