/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.ui;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.HierarchicalCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.HeaderInfo;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.PropertyConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeSelectionI;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewApp;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.TreeViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.ViewFrame;
import edu.ucsf.rbvi.clusterMaker2.internal.treeview.model.TreeViewModel;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.property.CyProperty;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeView
extends TreeViewApp
implements Observer,
RowsSetListener,
ClusterViz,
ClusterAlgorithm {
    public static String SHORTNAME = "treeview";
    public static String NAME = "JTree TreeView";
    private URL codeBase = null;
    protected ViewFrame viewFrame = null;
    protected TreeSelectionI geneSelection = null;
    protected TreeSelectionI arraySelection = null;
    protected TreeViewModel dataModel = null;
    protected CyNetworkView myView = null;
    protected CyNetwork myNetwork = null;
    protected TaskMonitor monitor = null;
    private List<CyNode> selectedNodes = new ArrayList<CyNode>();
    private List<CyNode> selectedArrays = new ArrayList<CyNode>();
    private boolean disableListeners = false;
    private boolean ignoreSelection = false;
    protected ClusterManager manager = null;
    protected CyNetworkTableManager networkTableManager = null;
    private static String appName = "clusterMaker TreeView";

    public TreeView(ClusterManager manager) {
        this.manager = manager;
        this.networkTableManager = manager.getService(CyNetworkTableManager.class);
    }

    public TreeView(PropertyConfig propConfig) {
        super(propConfig);
    }

    public void setVisible(boolean visibility) {
        if (this.viewFrame != null) {
            this.viewFrame.setVisible(visibility);
        }
    }

    public String getAppName() {
        return appName;
    }

    @Override
    public Object getContext() {
        return null;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public ClusterResults getResults() {
        return null;
    }

    @Override
    public void run(TaskMonitor monitor) {
        monitor.setTitle("Creating a tree view with cluster results");
        this.myNetwork = this.manager.getNetwork();
        this.myView = this.manager.getNetworkView();
        this.monitor = monitor;
        monitor.setTitle(this.getName());
        if (this.isAvailable()) {
            this.startup();
        } else {
            monitor.showMessage(TaskMonitor.Level.ERROR, "No compatible cluster results available");
        }
    }

    @Override
    public boolean isAvailable() {
        return TreeView.isReady(this.myNetwork);
    }

    public static boolean isReady(CyNetwork network) {
        if (network == null) {
            return false;
        }
        if (!ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__clusterType")) {
            return false;
        }
        if (!((String)network.getRow((CyIdentifiable)network).get("__clusterType", String.class)).equals(HierarchicalCluster.GROUP_ATTRIBUTE)) {
            return false;
        }
        return ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__nodeClusters") || ModelUtils.hasAttribute(network, (CyIdentifiable)network, "__attrClusters");
    }

    public void cancel() {
    }

    protected void startup() {
        CyProperty cyProperty = this.manager.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.dataModel = new TreeViewModel(this.monitor, this.myNetwork, this.myView, this.manager);
        this.setConfigDefaults(new PropertyConfig((CyProperty<Properties>)cyProperty, TreeView.globalConfigName(), "ProgramConfig"));
        PropertyConfig documentConfig = new PropertyConfig((CyProperty<Properties>)cyProperty, this.getShortName(), "DocumentConfig");
        this.dataModel.setDocumentConfig(documentConfig);
        TreeViewFrame frame = new TreeViewFrame(this, appName);
        frame.setDataModel(this.dataModel);
        frame.setLoaded(true);
        frame.addWindowListener(this);
        frame.setVisible(true);
        this.geneSelection = frame.getGeneSelection();
        this.geneSelection.addObserver(this);
        this.arraySelection = frame.getArraySelection();
        this.arraySelection.addObserver(this);
        this.manager.registerService(this, RowsSetListener.class, new Properties());
    }

    public void handleEvent(RowsSetEvent e) {
        if (!e.containsColumn("selected")) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        CyTable table = (CyTable)e.getSource();
        CyNetwork net = this.networkTableManager.getNetworkForTable(table);
        Class type = this.networkTableManager.getTableType(table);
        if (type.equals(CyNode.class)) {
            if (this.dataModel.isSymmetrical()) {
                return;
            }
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true);
            this.setNodeSelection(selectedNodes, true);
        } else if (type.equals(CyEdge.class) && this.dataModel.isSymmetrical()) {
            List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)net, (String)"selected", (boolean)true);
            this.setEdgeSelection(selectedEdges, true);
        }
    }

    @Override
    public void closeAllWindows() {
        super.closeAllWindows();
        this.manager.unregisterService(this, RowsSetListener.class);
    }

    @Override
    public void update(Observable o, Object arg) {
        CyNetworkView currentView = this.manager.getNetworkView();
        CyNetwork currentNetwork = this.manager.getNetwork();
        if (o == this.arraySelection && arg instanceof Boolean) {
            this.disableListeners = (Boolean)arg;
        }
        if (this.disableListeners) {
            return;
        }
        if (o == this.geneSelection) {
            this.selectedNodes.clear();
            int[] selections = this.geneSelection.getSelectedIndexes();
            HeaderInfo geneInfo = this.dataModel.getGeneHeaderInfo();
            String[] names = geneInfo.getNames();
            for (int i = 0; i < selections.length; ++i) {
                String nodeName = geneInfo.getHeader(selections[i])[0];
                CyNode node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, nodeName, CyNode.class);
                if (node != null && !currentNetwork.containsNode(node)) {
                    String[] tokens = nodeName.split(" ");
                    node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, tokens[0], CyNode.class);
                }
                if (node == null) continue;
                this.selectedNodes.add(node);
            }
            if (!this.dataModel.isSymmetrical() || this.selectedArrays.size() == 0) {
                List nodesToClear = CyTableUtil.getNodesInState((CyNetwork)currentNetwork, (String)"selected", (boolean)true);
                this.ignoreSelection = true;
                for (CyNode node : nodesToClear) {
                    if (this.myNetwork.containsNode(node)) {
                        this.myNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.FALSE);
                    }
                    if (!currentNetwork.containsNode(node)) continue;
                    currentNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.FALSE);
                }
                for (CyNode node : this.selectedNodes) {
                    if (this.myNetwork.containsNode(node)) {
                        this.myNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.TRUE);
                    }
                    if (!currentNetwork.containsNode(node)) continue;
                    currentNetwork.getRow((CyIdentifiable)node).set("selected", (Object)Boolean.TRUE);
                }
                this.manager.getService(CyEventHelper.class).flushPayloadEvents();
                this.ignoreSelection = false;
                if (currentView != null) {
                    currentView.updateView();
                }
            }
            return;
        }
        if (o == this.arraySelection) {
            if (!this.dataModel.isSymmetrical()) {
                return;
            }
            this.selectedArrays.clear();
            int[] selections = this.arraySelection.getSelectedIndexes();
            if (selections.length == this.dataModel.nExpr()) {
                return;
            }
            HeaderInfo arrayInfo = this.dataModel.getArrayHeaderInfo();
            String[] names = arrayInfo.getNames();
            for (int i = 0; i < selections.length; ++i) {
                String nodeName = arrayInfo.getHeader(selections[i])[0];
                CyNode node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, nodeName, CyNode.class);
                if (node != null && !currentNetwork.containsNode(node)) {
                    String[] tokens = nodeName.split(" ");
                    node = (CyNode)ModelUtils.getNetworkObjectWithName(currentNetwork, tokens[0], CyNode.class);
                }
                if (node == null) continue;
                this.selectedArrays.add(node);
            }
        }
        HashMap edgesToSelect = new HashMap();
        this.ignoreSelection = true;
        List edgesToClear = CyTableUtil.getEdgesInState((CyNetwork)currentNetwork, (String)"selected", (boolean)true);
        for (CyEdge edge : edgesToClear) {
            if (this.myNetwork.containsEdge(edge)) {
                this.myNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
            }
            if (!currentNetwork.containsEdge(edge)) continue;
            currentNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.FALSE);
        }
        for (CyNode node1 : this.selectedNodes) {
            for (CyNode node2 : this.selectedArrays) {
                List edges = currentNetwork.getConnectingEdgeList(node1, node2, CyEdge.Type.ANY);
                if (edges == null) continue;
                for (CyEdge edge : edges) {
                    if (currentNetwork.containsEdge(edge)) {
                        currentNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.TRUE);
                    }
                    if (!this.myNetwork.containsEdge(edge)) continue;
                    this.myNetwork.getRow((CyIdentifiable)edge).set("selected", (Object)Boolean.TRUE);
                }
            }
        }
        this.manager.getService(CyEventHelper.class).flushPayloadEvents();
        this.ignoreSelection = false;
        if (currentView != null) {
            currentView.updateView();
        }
        this.selectedNodes.clear();
        this.selectedArrays.clear();
    }

    private void setEdgeSelection(List<CyEdge> edgeArray, boolean select) {
        HeaderInfo geneInfo = this.dataModel.getGeneHeaderInfo();
        HeaderInfo arrayInfo = this.dataModel.getArrayHeaderInfo();
        this.geneSelection.deleteObserver(this);
        this.arraySelection.deleteObserver(this);
        this.geneSelection.setSelectedNode(null);
        this.geneSelection.deselectAllIndexes();
        this.arraySelection.setSelectedNode(null);
        this.arraySelection.deselectAllIndexes();
        for (CyEdge cyEdge : edgeArray) {
            if (!this.myNetwork.containsEdge(cyEdge)) continue;
            CyNode source = cyEdge.getSource();
            CyNode target = cyEdge.getTarget();
            int geneIndex = geneInfo.getHeaderIndex(ModelUtils.getName(this.myNetwork, (CyIdentifiable)source));
            int arrayIndex = arrayInfo.getHeaderIndex(ModelUtils.getName(this.myNetwork, (CyIdentifiable)target));
            this.geneSelection.setIndex(geneIndex, select);
            this.arraySelection.setIndex(arrayIndex, select);
        }
        this.geneSelection.notifyObservers();
        this.arraySelection.notifyObservers();
        this.geneSelection.addObserver(this);
        this.arraySelection.addObserver(this);
    }

    private void setNodeSelection(List<CyNode> nodeArray, boolean select) {
        HeaderInfo geneInfo = this.dataModel.getGeneHeaderInfo();
        this.geneSelection.deleteObserver(this);
        this.geneSelection.setSelectedNode(null);
        this.geneSelection.deselectAllIndexes();
        for (CyNode cyNode : nodeArray) {
            if (!this.myNetwork.containsNode(cyNode)) continue;
            int geneIndex = geneInfo.getHeaderIndex(ModelUtils.getName(this.myNetwork, (CyIdentifiable)cyNode));
            this.geneSelection.setIndex(geneIndex, select);
        }
        this.geneSelection.deleteObserver(this);
        this.geneSelection.notifyObservers();
        this.geneSelection.addObserver(this);
    }
}

