/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.utils;

import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static final String NONEATTRIBUTE = "--None--";

    public static List<CyEdge> getConnectingEdges(CyNetwork network, List<CyNode> nodes) {
        ArrayList<CyEdge> edgeList = new ArrayList<CyEdge>();
        for (int rowIndex = 0; rowIndex < nodes.size(); ++rowIndex) {
            for (int colIndex = rowIndex; colIndex < nodes.size(); ++colIndex) {
                List connectingEdges = network.getConnectingEdgeList(nodes.get(rowIndex), nodes.get(colIndex), CyEdge.Type.ANY);
                if (connectingEdges == null) continue;
                edgeList.addAll(connectingEdges);
            }
        }
        return edgeList;
    }

    public static String getNodeName(CyNetwork network, CyNode node) {
        return (String)network.getRow((CyIdentifiable)node).get("name", String.class);
    }

    public static CyNetwork getNetworkWithName(ClusterManager manager, String networkName) {
        for (CyNetwork network : manager.getService(CyNetworkManager.class).getNetworkSet()) {
            if (!ModelUtils.getNetworkName(network).equals(networkName)) continue;
            return network;
        }
        return null;
    }

    public static String getNetworkName(CyNetwork network) {
        return (String)network.getRow((CyIdentifiable)network).get("name", String.class);
    }

    public static boolean hasAttributeLocal(CyNetwork network, CyIdentifiable value, String column) {
        return ModelUtils.hasAttribute(network, value, column, "LOCAL_ATTRS");
    }

    public static boolean hasAttribute(CyNetwork network, CyIdentifiable value, String column) {
        return ModelUtils.hasAttribute(network, value, column, "USER");
    }

    public static boolean hasAttribute(CyNetwork network, CyIdentifiable value, String column, String namespace) {
        if (!CyTableUtil.getColumnNames((CyTable)network.getRow(value, namespace).getTable()).contains(column)) {
            return false;
        }
        return network.getRow(value, namespace).getRaw(column) != null;
    }

    public static void deleteAttributeLocal(CyNetwork network, CyIdentifiable value, String column) {
        ModelUtils.deleteAttribute(network, value, column, "LOCAL_ATTRS");
    }

    public static void deleteAttribute(CyNetwork network, CyIdentifiable value, String column) {
        ModelUtils.deleteAttribute(network, value, column, "USER");
    }

    public static void deleteAttribute(CyNetwork network, CyIdentifiable value, String column, String namespace) {
        if (!CyTableUtil.getColumnNames((CyTable)network.getRow(value, namespace).getTable()).contains(column)) {
            return;
        }
        network.getRow(value, namespace).getTable().deleteColumn(column);
    }

    public static CyNetwork createChildNetwork(ClusterManager manager, CyNetwork network, List<CyNode> nodeList, List<CyEdge> edgeList, String title) {
        String name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        CySubNetwork newNetwork = ((CySubNetwork)network).getRootNetwork().addSubNetwork(nodeList, edgeList);
        CyNetworkManager netManager = manager.getService(CyNetworkManager.class);
        netManager.addNetwork((CyNetwork)newNetwork);
        newNetwork.getRow((CyIdentifiable)newNetwork).set("name", (Object)(name + title));
        return newNetwork;
    }

    public static void createAndSetLocal(CyNetwork net, CyIdentifiable obj, String column, Object value, Class type, Class elementType) {
        ModelUtils.createAndSet(net, obj, column, value, type, elementType, "LOCAL_ATTRS");
    }

    public static void createAndSet(CyNetwork net, CyIdentifiable obj, String column, Object value, Class type, Class elementType) {
        ModelUtils.createAndSet(net, obj, column, value, type, elementType, "USER");
    }

    public static void createAndSet(CyNetwork net, CyIdentifiable obj, String column, Object value, Class type, Class elementType, String namespace) {
        CyTable tab = net.getRow(obj, namespace).getTable();
        if (tab.getColumn(column) == null) {
            if (type.equals(List.class)) {
                tab.createListColumn(column, elementType, false);
            } else {
                tab.createColumn(column, type, false);
            }
        }
        net.getRow(obj, namespace).set(column, value);
    }

    public static void copyLocalColumn(CyNetwork source, CyNetwork target, Class<? extends CyIdentifiable> clazz, String column) {
        CyTable sourceTable = source.getTable(clazz, "LOCAL_ATTRS");
        CyColumn sourceColumn = sourceTable.getColumn(column);
        if (sourceColumn == null) {
            return;
        }
        CyTable targetTable = target.getTable(clazz, "LOCAL_ATTRS");
        boolean isImmutable = sourceColumn.isImmutable();
        if (sourceColumn.getType().equals(List.class)) {
            targetTable.createListColumn(column, sourceColumn.getListElementType(), isImmutable);
        } else {
            targetTable.createColumn(column, sourceColumn.getType(), isImmutable);
        }
        if (clazz.equals(CyNetwork.class)) {
            Object v = sourceTable.getRow((Object)source.getSUID()).getRaw(column);
            targetTable.getRow((Object)target.getSUID()).set(column, v);
        } else {
            for (CyRow targetRow : targetTable.getAllRows()) {
                Long key = (Long)targetRow.get("SUID", Long.class);
                Object v = sourceTable.getRow((Object)key).getRaw(column);
                targetRow.set(column, v);
            }
        }
    }

    public static ListMultipleSelection<String> updateAttributeList(CyNetwork network, ListMultipleSelection<String> attributes) {
        List<String> attributeArray = ModelUtils.getAllAttributes(network, network.getDefaultNodeTable());
        attributeArray.addAll(ModelUtils.getAllAttributes(network, network.getDefaultEdgeTable()));
        ListMultipleSelection newAttribute = new ListMultipleSelection(attributeArray);
        if (attributeArray.size() > 0) {
            if (attributes != null) {
                newAttribute.setSelectedValues(attributes.getSelectedValues());
            } else {
                newAttribute.setSelectedValues(Collections.singletonList(attributeArray.get(0)));
            }
            return newAttribute;
        }
        return new ListMultipleSelection((Object[])new String[]{NONEATTRIBUTE});
    }

    public static ListMultipleSelection<String> updateNodeAttributeList(CyNetwork network, ListMultipleSelection<String> attribute) {
        List<String> attributeArray = ModelUtils.getAllAttributes(network, network.getDefaultNodeTable());
        if (attributeArray.size() > 0) {
            ListMultipleSelection newAttribute = new ListMultipleSelection(attributeArray);
            if (attribute != null) {
                try {
                    newAttribute.setSelectedValues(attribute.getSelectedValues());
                }
                catch (IllegalArgumentException e) {
                    newAttribute.setSelectedValues(Collections.singletonList(attributeArray.get(0)));
                }
            } else {
                newAttribute.setSelectedValues(Collections.singletonList(attributeArray.get(0)));
            }
            return newAttribute;
        }
        return new ListMultipleSelection((Object[])new String[]{NONEATTRIBUTE});
    }

    public static ListSingleSelection<String> updateEdgeAttributeList(CyNetwork network, ListSingleSelection<String> attribute) {
        List<String> attributeArray = ModelUtils.getAllAttributes(network, network.getDefaultEdgeTable());
        if (attributeArray.size() > 0) {
            ListSingleSelection newAttribute = new ListSingleSelection(attributeArray);
            if (attribute != null && attributeArray.contains(attribute.getSelectedValue())) {
                try {
                    newAttribute.setSelectedValue(attribute.getSelectedValue());
                }
                catch (IllegalArgumentException e) {
                    newAttribute.setSelectedValue((Object)attributeArray.get(0));
                }
            } else {
                newAttribute.setSelectedValue((Object)attributeArray.get(0));
            }
            return newAttribute;
        }
        return new ListSingleSelection((Object[])new String[]{NONEATTRIBUTE});
    }

    public static String getName(CyNetwork network, CyIdentifiable obj) {
        CyRow row = network.getRow(obj);
        if (row == null) {
            return null;
        }
        return (String)row.get("name", String.class);
    }

    public static CyIdentifiable getNetworkObjectWithName(CyNetwork network, String name, Class<? extends CyIdentifiable> clazz) {
        CyTable table = network.getTable(clazz, "USER");
        Collection rows = table.getMatchingRows("name", (Object)name);
        for (CyRow row : rows) {
            Long suid = (Long)row.get("SUID", Long.class);
            if (clazz.equals(CyNode.class)) {
                return network.getNode(suid.longValue());
            }
            if (!clazz.equals(CyEdge.class)) continue;
            return network.getEdge(suid.longValue());
        }
        return null;
    }

    public static Double getNumericValue(CyNetwork network, CyIdentifiable obj, String column) {
        CyColumn col = network.getRow(obj).getTable().getColumn(column);
        Class type = col.getType();
        Number val = null;
        if (type == Double.class) {
            val = (Number)network.getRow(obj).get(column, Double.class);
        } else if (type == Float.class) {
            val = (Number)network.getRow(obj).get(column, Float.class);
        } else if (type == Long.class) {
            val = (Number)network.getRow(obj).get(column, Long.class);
        } else if (type == Integer.class) {
            val = (Number)network.getRow(obj).get(column, Integer.class);
        } else {
            return null;
        }
        if (val == null) {
            return null;
        }
        return val.doubleValue();
    }

    private static List<String> getAllAttributes(CyNetwork network, CyTable table) {
        String[] attributeArray = new String[1];
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add(NONEATTRIBUTE);
        ModelUtils.getAttributesList(attributeList, table);
        Object[] attrArray = attributeList.toArray(attributeArray);
        if (attrArray.length > 1) {
            Arrays.sort(attrArray);
        }
        return Arrays.asList(attrArray);
    }

    private static void getAttributesList(List<String> attributeList, CyTable attributes) {
        Collection names = attributes.getColumns();
        Iterator itr = names.iterator();
        for (CyColumn column : attributes.getColumns()) {
            if (column.getType() != Double.class && column.getType() != Integer.class) continue;
            attributeList.add(column.getName());
        }
    }
}

