/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.swing.RequestsUIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeClusterer
extends AbstractClusterAlgorithm
implements RequestsUIHelper {
    protected DistanceMetric distanceMetric = DistanceMetric.EUCLIDEAN;
    protected List<String> attrList;

    public AbstractAttributeClusterer(ClusterManager clusterManager) {
        super(clusterManager);
    }

    protected void updateKEstimates(CyNetwork network) {
    }

    protected void resetAttributes(CyNetwork network, String group_attr) {
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__arrayOrder")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__arrayOrder");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__nodeOrder")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__nodeOrder");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__attrClusters")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__attrClusters");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__nodeClusters")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__nodeClusters");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__clusterEdgeWeight")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__clusterEdgeWeight");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__clusterType")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__clusterType");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__clusterParams")) {
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, "__clusterParams");
        }
        if (ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, group_attr)) {
            List clList = network.getRow((CyIdentifiable)network).getList(group_attr, String.class);
            ModelUtils.deleteAttributeLocal(network, (CyIdentifiable)network, group_attr);
        }
    }

    protected void updateAttributes(CyNetwork network, String cluster_type, Integer[] rowOrder, String[] weightAttributes, List<String> attrList, Matrix matrix) {
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterType", cluster_type, String.class, null);
        if (matrix.isTransposed()) {
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__attrClusters", attrList, List.class, String.class);
        } else {
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__nodeClusters", attrList, List.class, String.class);
            if (matrix.isSymmetrical()) {
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__attrClusters", attrList, List.class, String.class);
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterEdgeWeight", weightAttributes[0], String.class, null);
            }
        }
        String[] rowArray = matrix.getRowLabels();
        ArrayList<String> orderList = new ArrayList<String>();
        String[] columnArray = matrix.getColLabels();
        ArrayList<String> columnList = new ArrayList<String>(columnArray.length);
        for (int i = 0; i < rowOrder.length; ++i) {
            orderList.add(rowArray[rowOrder[i]]);
            if (!matrix.isSymmetrical()) continue;
            columnList.add(rowArray[rowOrder[i]]);
        }
        if (!matrix.isSymmetrical()) {
            for (int col = 0; col < columnArray.length; ++col) {
                columnList.add(columnArray[col]);
            }
        }
        if (matrix.isTransposed()) {
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__arrayOrder", orderList, List.class, String.class);
            if (!ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__nodeOrder")) {
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__nodeOrder", columnList, List.class, String.class);
            }
        } else {
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__nodeOrder", orderList, List.class, String.class);
            if (!ModelUtils.hasAttributeLocal(network, (CyIdentifiable)network, "__arrayOrder")) {
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__arrayOrder", columnList, List.class, String.class);
            }
        }
    }

    protected void updateParams(CyNetwork network, List<String> params) {
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterParams", params, List.class, String.class);
    }

    protected void createGroups(CyNetwork net, Matrix matrix, int nClusters, int[] clusters, String algorithm) {
        if (matrix.isTransposed()) {
            return;
        }
        this.network = net;
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Creating groups");
        }
        this.attrList = new ArrayList<String>(matrix.nRows());
        for (int cluster2 = 0; cluster2 < nClusters; ++cluster2) {
            ArrayList<CyNode> memberList = new ArrayList<CyNode>();
            for (int i = 0; i < matrix.nRows(); ++i) {
                if (clusters[i] != cluster2) continue;
                this.attrList.add(matrix.getRowLabel(i) + "\t" + cluster2);
                memberList.add(matrix.getRowNode(i));
                ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)matrix.getRowNode(i), algorithm + " Cluster", new Integer(cluster2), Integer.class, null);
            }
            if (!this.createGroups) continue;
            System.out.println("Creating group: Cluster_" + cluster2 + " with " + memberList.size() + " nodes");
            CyGroup group = this.clusterManager.createGroup(this.network, "Cluster_" + cluster2, memberList, null, true);
        }
    }

    public List<String> getAttributeList() {
        return this.attrList;
    }
}

