/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.KClusterAttributes;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.SilhouetteCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.Silhouettes;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKClusterAlgorithm {
    protected List<String> attrList;
    protected CyNetwork network;
    protected String[] weightAttributes;
    protected DistanceMetric metric;
    protected TaskMonitor monitor;
    protected boolean debug = false;
    protected Matrix matrix;
    protected boolean ignoreMissing = true;
    protected boolean selectedOnly = false;
    protected boolean useSilhouette = false;
    protected boolean cancelled = false;
    protected Integer[] rowOrder;
    private Silhouettes[] silhouetteResults = null;

    public AbstractKClusterAlgorithm(CyNetwork network, String[] weightAttributes, DistanceMetric metric, TaskMonitor monitor) {
        this.network = network;
        this.weightAttributes = weightAttributes;
        this.metric = metric;
        this.monitor = monitor;
    }

    public abstract int kcluster(int var1, int var2, Matrix var3, DistanceMetric var4, int[] var5);

    public Integer[] cluster(ClusterManager clusterManager, int nClusters, int nIterations, boolean transpose, String algorithm, KClusterAttributes context, boolean createGroups) {
        String keyword = "GENE";
        if (transpose) {
            keyword = "ARRY";
        }
        for (int att = 0; att < this.weightAttributes.length; ++att) {
            if (!this.debug) continue;
            this.monitor.showMessage(TaskMonitor.Level.INFO, "Attribute: '" + this.weightAttributes[att] + "'");
        }
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Creating distance matrix");
        }
        this.matrix = new Matrix(this.network, this.weightAttributes, transpose, this.ignoreMissing, this.selectedOnly);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "cluster matrix has " + this.matrix.nRows() + " rows");
        this.matrix.setUniformWeights();
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Clustering...");
        }
        if (context.useSilhouette) {
            TaskMonitor saveMonitor = this.monitor;
            this.monitor = null;
            this.silhouetteResults = new Silhouettes[context.kMax];
            int nThreads = Runtime.getRuntime().availableProcessors() - 1;
            if (nThreads > 1) {
                this.runThreadedSilhouette(context.kMax, nIterations, nThreads, saveMonitor);
            } else {
                this.runLinearSilhouette(context.kMax, nIterations, saveMonitor);
            }
            if (this.cancelled()) {
                return null;
            }
            double maxSil = Double.MIN_VALUE;
            for (int kEstimate = 2; kEstimate < context.kMax; ++kEstimate) {
                double sil = this.silhouetteResults[kEstimate].getMean();
                saveMonitor.showMessage(TaskMonitor.Level.INFO, "Average silhouette for " + kEstimate + " clusters is " + sil);
                if (!(sil > maxSil)) continue;
                maxSil = sil;
                nClusters = kEstimate;
            }
            this.monitor = saveMonitor;
        }
        int[] clusters = new int[this.matrix.nRows()];
        if (this.cancelled()) {
            return null;
        }
        int nClustersFound = this.kcluster(nClusters, nIterations, this.matrix, this.metric, clusters);
        if (this.cancelled()) {
            return null;
        }
        if (nClusters == 0) {
            nClusters = nClustersFound;
        }
        Silhouettes sResult = SilhouetteCalculator.calculate((BaseMatrix)this.matrix, this.metric, clusters);
        if (!this.matrix.isTransposed()) {
            this.createGroups(clusterManager, nClusters, clusters, algorithm, createGroups);
        }
        this.rowOrder = this.matrix.indexSort(clusters, clusters.length);
        String resultString = "Created " + nClusters + " clusters with average silhouette = " + sResult.getMean();
        this.monitor.showMessage(TaskMonitor.Level.INFO, resultString);
        return this.rowOrder;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public List<String> getAttributeList() {
        return this.attrList;
    }

    protected void createGroups(ClusterManager clusterManager, int nClusters, int[] clusters, String algorithm, boolean createGroups) {
        if (this.matrix.isTransposed()) {
            return;
        }
        this.attrList = new ArrayList<String>(this.matrix.nRows());
        for (int cluster2 = 0; cluster2 < nClusters; ++cluster2) {
            ArrayList<CyNode> memberList = new ArrayList<CyNode>();
            for (int i = 0; i < this.matrix.nRows(); ++i) {
                if (clusters[i] != cluster2) continue;
                this.attrList.add(this.matrix.getRowLabel(i) + "\t" + cluster2);
                memberList.add(this.matrix.getRowNode(i));
                ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.matrix.getRowNode(i), algorithm + " Cluster", new Integer(cluster2), Integer.class, null);
            }
            if (!createGroups) continue;
            CyGroup group = clusterManager.createGroup(this.network, "Cluster_" + cluster2, memberList, null, true);
        }
    }

    public void getClusterMeans(int nClusters, Matrix data, Matrix cdata, int[] clusterid) {
        int j;
        int i;
        double[][] cmask = new double[nClusters][cdata.nColumns()];
        for (i = 0; i < nClusters; ++i) {
            for (j = 0; j < data.nColumns(); ++j) {
                cdata.setValue(i, j, null);
                cmask[i][j] = 0.0;
            }
        }
        for (int k = 0; k < data.nRows(); ++k) {
            int i2 = clusterid[k];
            for (int j2 = 0; j2 < data.nColumns(); ++j2) {
                if (!data.hasValue(k, j2)) continue;
                double cValue = 0.0;
                double dataValue = data.getValue(k, j2);
                if (cdata.hasValue(i2, j2)) {
                    cValue = cdata.getValue(i2, j2);
                }
                cdata.setValue(i2, j2, (Double)(cValue + dataValue));
                cmask[i2][j2] = cmask[i2][j2] + 1.0;
            }
        }
        for (i = 0; i < nClusters; ++i) {
            for (j = 0; j < data.nColumns(); ++j) {
                if (!(cmask[i][j] > 0.0)) continue;
                double cData = cdata.getValue(i, j) / cmask[i][j];
                cdata.setValue(i, j, (Double)cData);
            }
        }
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    protected int[] chooseRandomElementsAsCenters(int nElements, int nClusters) {
        int i;
        int[] centers = new int[nClusters];
        ArrayList<Integer> candidates = new ArrayList<Integer>(nElements);
        for (i = 0; i < nElements; ++i) {
            candidates.add(i);
        }
        for (i = 0; i < nClusters; ++i) {
            int index = (int)Math.floor(Math.random() * (double)candidates.size());
            centers[i] = (Integer)candidates.get(index);
            candidates.remove(index);
        }
        return centers;
    }

    protected int[] chooseCentralElementsAsCenters(int nElements, int nClusters, double[][] distances) {
        int[] centers = new int[nClusters];
        double[][] normalized = new double[nElements][nElements];
        for (int i = 0; i < nElements; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < nElements; ++j) {
                double x;
                normalized[i][j] = x = distances[i][j];
                sum += x;
            }
            j = 0;
            while (j < nElements) {
                double[] dArray = normalized[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
        KeyValuePair[] pairs = new KeyValuePair[nElements];
        for (int i = 0; i < nElements; ++i) {
            pairs[i] = new KeyValuePair(0.0, i);
            for (int j = 0; j < nElements; ++j) {
                pairs[i].key += normalized[i][j];
            }
        }
        KeyValuePairComparator comparator = new KeyValuePairComparator();
        Arrays.sort(pairs, comparator);
        for (int i = 0; i < nClusters; ++i) {
            centers[i] = pairs[i].value;
        }
        return centers;
    }

    private void renumberClusters(int nClusters, int[] clusters) {
        int[] clusterSizes = new int[nClusters];
        Arrays.fill(clusterSizes, 0);
        for (int row = 0; row < clusters.length; ++row) {
            int n = clusters[row];
            clusterSizes[n] = clusterSizes[n] + 1;
        }
        Integer[] sortedClusters = new Integer[nClusters];
        for (int cluster2 = 0; cluster2 < nClusters; ++cluster2) {
            sortedClusters[cluster2] = cluster2;
        }
        Arrays.sort(sortedClusters, new SizeComparator(clusterSizes));
        int[] clusterIndex = new int[nClusters];
        for (int cluster3 = 0; cluster3 < nClusters; ++cluster3) {
            clusterIndex[sortedClusters[cluster3].intValue()] = cluster3;
        }
        for (int row = 0; row < clusters.length; ++row) {
            clusters[row] = clusterIndex[clusters[row]];
        }
    }

    private void runThreadedSilhouette(int kMax, int nIterations, int nThreads, TaskMonitor saveMonitor) {
        int pool;
        ExecutorService[] threadPools = new ExecutorService[nThreads];
        for (pool = 0; pool < threadPools.length; ++pool) {
            threadPools[pool] = Executors.newFixedThreadPool(1);
        }
        for (int kEstimate = 2; kEstimate < kMax; ++kEstimate) {
            int[] clusters = new int[this.matrix.nRows()];
            RunKMeans r = new RunKMeans(this.matrix, clusters, kEstimate, nIterations, saveMonitor);
            threadPools[(kEstimate - 2) % nThreads].submit(r);
        }
        for (pool = 0; pool < threadPools.length; ++pool) {
            threadPools[pool].shutdown();
            try {
                boolean result = threadPools[pool].awaitTermination(7L, TimeUnit.DAYS);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void runLinearSilhouette(int kMax, int nIterations, TaskMonitor saveMonitor) {
        for (int kEstimate = 2; kEstimate < kMax; ++kEstimate) {
            int[] clusters = new int[this.matrix.nRows()];
            if (this.cancelled()) {
                return;
            }
            if (saveMonitor != null) {
                saveMonitor.setStatusMessage("Getting silhouette with a k estimate of " + kEstimate);
            }
            int ifound = this.kcluster(kEstimate, nIterations, this.matrix, this.metric, clusters);
            this.silhouetteResults[kEstimate] = SilhouetteCalculator.calculate((BaseMatrix)this.matrix, this.metric, clusters);
        }
    }

    private class RunKMeans
    implements Runnable {
        Matrix matrix;
        int[] clusters;
        int kEstimate;
        int nIterations;
        TaskMonitor saveMonitor = null;

        public RunKMeans(Matrix matrix, int[] clusters, int k, int nIterations, TaskMonitor saveMonitor) {
            this.matrix = matrix;
            this.clusters = clusters;
            this.kEstimate = k;
            this.nIterations = nIterations;
            this.saveMonitor = saveMonitor;
        }

        public void run() {
            int[] clusters = new int[this.matrix.nRows()];
            if (AbstractKClusterAlgorithm.this.cancelled()) {
                return;
            }
            if (this.saveMonitor != null) {
                this.saveMonitor.setStatusMessage("Getting silhouette with a k estimate of " + this.kEstimate);
            }
            try {
                int ifound = AbstractKClusterAlgorithm.this.kcluster(this.kEstimate, this.nIterations, this.matrix, AbstractKClusterAlgorithm.this.metric, clusters);
                ((AbstractKClusterAlgorithm)AbstractKClusterAlgorithm.this).silhouetteResults[this.kEstimate] = SilhouetteCalculator.calculate((BaseMatrix)this.matrix, AbstractKClusterAlgorithm.this.metric, clusters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SizeComparator
    implements Comparator<Integer> {
        int[] sizeArray = null;

        public SizeComparator(int[] a) {
            this.sizeArray = a;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.sizeArray[o1] > this.sizeArray[o2]) {
                return 1;
            }
            if (this.sizeArray[o1] < this.sizeArray[o2]) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuePairComparator
    implements Comparator<KeyValuePair> {
        private KeyValuePairComparator() {
        }

        @Override
        public int compare(KeyValuePair a, KeyValuePair b) {
            if (Double.valueOf(a.key) < Double.valueOf(b.key)) {
                return -1;
            }
            return 1;
        }
    }

    private class KeyValuePair {
        public double key;
        public int value;

        public KeyValuePair(double key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

