/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMatrix {
    protected int nRows;
    protected int nColumns;
    protected Double[][] matrix;
    protected double[] colWeights;
    protected double[] rowWeights;
    protected double maxAttribute;
    protected String[] rowLabels;
    protected String[] columnLabels;
    protected boolean transpose;
    protected boolean symmetrical;
    public static DistanceMetric[] distanceTypes = new DistanceMetric[]{DistanceMetric.EUCLIDEAN, DistanceMetric.CITYBLOCK, DistanceMetric.CORRELATION, DistanceMetric.ABS_CORRELATION, DistanceMetric.UNCENTERED_CORRELATION, DistanceMetric.ABS_UNCENTERED_CORRELATION, DistanceMetric.SPEARMANS_RANK, DistanceMetric.KENDALLS_TAU, DistanceMetric.VALUE_IS_CORRELATION};

    BaseMatrix() {
    }

    public BaseMatrix(int rows, int cols) {
        this.init(rows, cols);
    }

    public BaseMatrix(int rows, int cols, Double[] data) {
        if (rows == 0) {
            rows = data.length / cols;
        }
        if (cols == 0) {
            cols = data.length / rows;
        }
        if (rows * cols != data.length) {
            throw new IllegalArgumentException("Data array length does not conform with specified matrix dimension");
        }
        this.init(rows, cols);
        int k = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.matrix[i][j] = data[k++];
            }
        }
    }

    private void init(int rows, int cols) {
        this.nRows = rows;
        this.nColumns = cols;
        this.matrix = new Double[rows][cols];
        this.colWeights = new double[cols];
        this.rowWeights = new double[rows];
        this.columnLabels = new String[cols];
        this.rowLabels = new String[rows];
        this.transpose = false;
        this.setUniformWeights();
    }

    public int nRows() {
        return this.nRows;
    }

    public int nColumns() {
        return this.nColumns;
    }

    public Double getValue(int row, int column) {
        return this.matrix[row][column];
    }

    public double doubleValue(int row, int column) {
        if (this.matrix[row][column] != null) {
            return this.matrix[row][column];
        }
        return Double.NaN;
    }

    public void setValue(int row, int column, double value) {
        this.matrix[row][column] = new Double(value);
    }

    public void setValue(int row, int column, Double value) {
        this.matrix[row][column] = value;
    }

    public boolean hasValue(int row, int column) {
        return this.matrix[row][column] != null;
    }

    public void setUniformWeights() {
        if (this.colWeights == null || this.rowWeights == null) {
            this.colWeights = new double[this.nColumns];
            this.rowWeights = new double[this.nRows];
        }
        Arrays.fill(this.colWeights, 1.0);
        Arrays.fill(this.rowWeights, 1.0);
    }

    public double[] getRowWeights() {
        return this.rowWeights;
    }

    public double getRowWeight(int row) {
        return this.rowWeights[row];
    }

    public double[] getColWeights() {
        return this.colWeights;
    }

    public double getColWeight(int col) {
        return this.colWeights[col];
    }

    public double[] getWeights() {
        return this.colWeights;
    }

    public void setRowWeight(int row, double value) {
        if (this.rowWeights == null) {
            this.rowWeights = new double[this.nRows];
        }
        this.rowWeights[row] = value;
    }

    public void setColWeight(int col, double value) {
        if (this.colWeights == null) {
            this.colWeights = new double[this.nColumns];
        }
        this.colWeights[col] = value;
    }

    public String[] getColLabels() {
        return this.columnLabels;
    }

    public String getColLabel(int col) {
        return this.columnLabels[col];
    }

    public void setColLabel(int col, String label) {
        this.columnLabels[col] = label;
    }

    public String[] getRowLabels() {
        return this.rowLabels;
    }

    public String getRowLabel(int row) {
        return this.rowLabels[row];
    }

    public void setRowLabel(int row, String label) {
        this.rowLabels[row] = label;
    }

    protected void setRowLabels(List<String> labelList) {
        int index = 0;
        for (String label : labelList) {
            this.rowLabels[index++] = label;
        }
    }

    protected void setColumnLabels(List<String> labelList) {
        int index = 0;
        for (String label : labelList) {
            this.columnLabels[index++] = label;
        }
    }

    public double[] getRank(int row) {
        int m;
        int i;
        double[] tData = new double[this.nColumns];
        int nVals = 0;
        for (int column = 0; column < this.nColumns; ++column) {
            if (!this.hasValue(row, column)) continue;
            tData[nVals++] = this.matrix[row][column];
        }
        if (nVals == 0) {
            return null;
        }
        Integer[] index = this.indexSort(tData, nVals);
        double[] rank = new double[nVals];
        for (i = 0; i < nVals; ++i) {
            rank[index[i].intValue()] = i;
        }
        for (i = 0; i < nVals; i += m) {
            int j;
            m = 0;
            double value = tData[index[i]];
            for (j = i + 1; j < nVals && tData[index[j]] == value; ++j) {
            }
            m = j - i;
            value = rank[index[i]] + (double)(m - 1) / 2.0;
            for (j = i; j < i + m; ++j) {
                rank[index[j].intValue()] = value;
            }
        }
        return rank;
    }

    public double[][] getDistanceMatrix(DistanceMetric metric) {
        double[][] result = new double[this.nRows][this.nRows];
        for (int row = 0; row < this.nRows; ++row) {
            for (int column = row; column < this.nRows; ++column) {
                result[row][column] = metric.getMetric(this, this, this.getWeights(), row, column);
                if (row == column) continue;
                result[column][row] = result[row][column];
            }
        }
        return result;
    }

    public void printMatrix() {
        for (int col = 0; col < this.nColumns; ++col) {
            System.out.print("\t" + this.columnLabels[col]);
        }
        System.out.println();
        for (int row = 0; row < this.nRows; ++row) {
            System.out.print(this.rowLabels[row] + "\t");
            for (int col = 0; col < this.nColumns; ++col) {
                if (this.matrix[row][col] != null) {
                    System.out.print(this.matrix[row][col] + "\t");
                    continue;
                }
                System.out.print("\t");
            }
            System.out.println();
        }
    }

    public Integer[] indexSort(double[] tData, int nVals) {
        Integer[] index = new Integer[nVals];
        for (int i = 0; i < nVals; ++i) {
            index[i] = new Integer(i);
        }
        IndexComparator iCompare = new IndexComparator(tData);
        Arrays.sort(index, iCompare);
        return index;
    }

    public Integer[] indexSort(int[] tData, int nVals) {
        Integer[] index = new Integer[nVals];
        for (int i = 0; i < nVals; ++i) {
            index[i] = new Integer(i);
        }
        IndexComparator iCompare = new IndexComparator(tData);
        Arrays.sort(index, iCompare);
        return index;
    }

    public boolean isTransposed() {
        return this.transpose;
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setMissingToZero() {
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                if (this.matrix[row][col] != null) continue;
                this.matrix[row][col] = new Double(0.0);
            }
        }
    }

    public void adjustDiagonals() {
        for (int col = 0; col < this.nColumns; ++col) {
            this.matrix[col][col] = new Double(this.maxAttribute);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexComparator
    implements Comparator<Integer> {
        double[] data = null;
        int[] intData = null;

        public IndexComparator(double[] data) {
            this.data = data;
        }

        public IndexComparator(int[] data) {
            this.intData = data;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.data != null) {
                if (this.data[o1] < this.data[o2]) {
                    return -1;
                }
                if (this.data[o1] > this.data[o2]) {
                    return 1;
                }
                return 0;
            }
            if (this.intData != null) {
                if (this.intData[o1] < this.intData[o2]) {
                    return -1;
                }
                if (this.intData[o1] > this.intData[o2]) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

