/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BiMine;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AttributeList;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.BoundedDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiMineContext {
    CyNetwork network;
    @Tunable(description="Threshold for Preprocessing", gravity=1.0)
    public BoundedDouble delta = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(Double.MAX_VALUE), true, true);
    @Tunable(description="Threshold for ASR", gravity=1.0)
    public Double alpha = 1.0;
    @ContainsTunables
    public AttributeList attributeList = null;
    public boolean selectedOnly = false;
    @Tunable(description="Create groups from clusters", groups={"Visualization Options"}, gravity=150.0)
    public boolean createGroups = false;
    @Tunable(description="Show HeatMap when complete", groups={"Visualization Options"}, gravity=151.0)
    public boolean showUI = false;

    @Tunable(description="Use only selected nodes/edges for cluster", groups={"BiMine Parameters"}, gravity=100.0)
    public boolean getselectedOnly() {
        return this.selectedOnly;
    }

    public void setselectedOnly(boolean sel) {
        this.selectedOnly = sel;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.attributeList == null) {
            this.attributeList = new AttributeList(network);
        } else {
            this.attributeList.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("nodeAttributeList=" + this.attributeList.getNodeAttributeList().toString());
        params.add("edgeAttribute=" + this.attributeList.getEdgeAttribute());
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("createGroups=" + this.createGroups);
        return params;
    }
}

