/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BicFinder;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BicFinder.BicFinderContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunBicFinder {
    protected CyNetwork network;
    protected String[] weightAttributes;
    protected Matrix matrix;
    protected Matrix biclusterMatrix;
    protected Double[][] arr;
    protected int[][] discrete_matrix;
    protected Matrix matrix_t;
    protected List<Map<Integer, Integer>> dag;
    protected List<Map<Integer, List<Boolean>>> csl;
    protected List<Map<Integer, Map<Integer, Double>>> csi;
    protected int[] maxCSL;
    protected Double[][] geneRho;
    protected Double[][] conditionRho;
    protected int[] clusters;
    protected TaskMonitor monitor;
    protected boolean ignoreMissing = true;
    protected boolean selectedOnly = false;
    BicFinderContext context;
    double alpha;
    double delta;
    int nelements;
    int nattrs;
    protected Map<Integer, List<Integer>> clusterRows;
    protected Map<Integer, List<Integer>> clusterCols;
    protected Map<Integer, List<Long>> clusterNodes;
    protected Map<Integer, List<String>> clusterAttrs;

    public Matrix getMatrix() {
        return this.matrix;
    }

    public Matrix getBiclusterMatrix() {
        return this.biclusterMatrix;
    }

    public int[] getClustersArray() {
        return this.clusters;
    }

    public RunBicFinder(CyNetwork network, String[] weightAttributes, TaskMonitor monitor, BicFinderContext context) {
        this.network = network;
        this.weightAttributes = weightAttributes;
        this.monitor = monitor;
        this.context = context;
        this.alpha = (Double)context.alpha.getValue();
        this.delta = (Double)context.delta.getValue();
    }

    public Integer[] cluster(boolean transpose) {
        int i;
        this.matrix = new Matrix(this.network, this.weightAttributes, transpose, this.ignoreMissing, this.selectedOnly);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "cluster matrix has " + this.matrix.nRows() + " rows");
        this.matrix.setUniformWeights();
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Clustering...");
        }
        this.nelements = this.matrix.nRows();
        this.nattrs = this.matrix.nColumns();
        this.discrete_matrix = this.getDiscreteMatrix();
        System.out.println("Discrete Matrix:");
        for (i = 0; i < this.nelements; ++i) {
            for (int j = 0; j < this.nattrs - 1; ++j) {
                System.out.print(this.discrete_matrix[i][j] + "\t");
            }
            System.out.println("");
        }
        this.generateCSL();
        this.generateCSI();
        this.dag = this.generateDag();
        this.clusterRows = new HashMap<Integer, List<Integer>>();
        this.clusterCols = new HashMap<Integer, List<Integer>>();
        for (i = 0; i < this.nelements; ++i) {
            List<Object> genes = new ArrayList<Integer>();
            List<Object> conditions = new ArrayList<Integer>();
            for (int c = 0; c < this.nattrs; ++c) {
                conditions.add(c);
            }
            LinkedList<Map.Entry<Integer, Integer>> edges = new LinkedList<Map.Entry<Integer, Integer>>(this.dag.get(i).entrySet());
            Collections.sort(edges, new Comparator<Map.Entry<Integer, Integer>>(){

                @Override
                public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            for (Map.Entry entry : edges) {
                int k = (Integer)entry.getKey();
                System.out.println("i-->k: " + i + "-->" + k + "\n");
                List<Object> genes_c = new ArrayList();
                List<Object> conditions_c = new ArrayList();
                genes_c = this.union(genes, Arrays.asList(i, k));
                conditions_c = this.intersection(conditions, this.getCommonConditions(i, k));
                System.out.println("Current Genes:");
                for (Integer n : genes_c) {
                    System.out.print(n + ",");
                }
                System.out.println("\nCurrent Conditions:");
                for (Integer n : conditions_c) {
                    System.out.print(n + ",");
                }
                System.out.println("");
                double acsi = this.getACSI(i, genes_c, conditions_c);
                System.out.println("ACSI:" + acsi);
                if (!(acsi >= this.alpha)) continue;
                genes = genes_c;
                conditions = conditions_c;
            }
            if (this.isSubset(genes, conditions) || !(this.getASR(genes, conditions) >= this.delta)) continue;
            this.clusterRows.put(this.clusterRows.size() + 1, genes);
            this.clusterCols.put(this.clusterCols.size() + 1, conditions);
        }
        int totalRows = 0;
        for (List<Integer> biclust : this.clusterRows.values()) {
            totalRows += biclust.size();
        }
        this.clusters = new int[totalRows];
        CyNode[] rowNodes = new CyNode[totalRows];
        this.biclusterMatrix = new Matrix(this.network, totalRows, this.nattrs);
        int i2 = 0;
        this.clusterNodes = new HashMap<Integer, List<Long>>();
        this.clusterAttrs = new HashMap<Integer, List<String>>();
        for (Integer biclust : this.clusterRows.keySet()) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Integer node : this.clusterRows.get(biclust)) {
                this.biclusterMatrix.setRowLabel(i2, this.matrix.getRowLabel(node));
                rowNodes[i2] = this.matrix.getRowNode(node);
                for (int j = 0; j < this.nattrs; ++j) {
                    this.biclusterMatrix.setValue(i2, j, this.matrix.getValue(node, j));
                }
                this.clusters[i2] = biclust;
                ++i2;
                arrayList.add(this.matrix.getRowNode(node).getSUID());
            }
            this.clusterNodes.put(biclust, arrayList);
            ArrayList<String> attrs = new ArrayList<String>();
            for (Integer cond : this.clusterCols.get(biclust)) {
                attrs.add(this.matrix.getColLabel(cond));
            }
            this.clusterAttrs.put(biclust, attrs);
        }
        for (int j = 0; j < this.nattrs; ++j) {
            this.biclusterMatrix.setColLabel(j, this.matrix.getColLabel(j));
        }
        this.biclusterMatrix.setRowNodes(rowNodes);
        Integer[] rowOrder = this.biclusterMatrix.indexSort(this.clusters, this.clusters.length);
        return rowOrder;
    }

    private boolean isSubset(List<Integer> genes, List<Integer> conditions) {
        boolean subset = false;
        for (Integer biclust : this.clusterRows.keySet()) {
            if (!this.clusterRows.get(biclust).containsAll(genes) || !this.clusterCols.get(biclust).containsAll(conditions)) continue;
            subset = true;
            break;
        }
        return subset;
    }

    private double getACSI(int gene_i, List<Integer> genes, List<Integer> conditions) {
        if (genes.size() <= 2) {
            return 1.0;
        }
        double acsi = 0.0;
        int i = genes.indexOf(gene_i);
        for (int j = i + 1; j < genes.size(); ++j) {
            for (int k = j + 1; k < genes.size(); ++k) {
                acsi += this.csi.get(gene_i).get(genes.get(j)).get(genes.get(k)).doubleValue();
            }
        }
        acsi *= 2.0;
        return acsi /= (double)((genes.size() - 1) * (genes.size() - 2));
    }

    private double getASR(List<Integer> genes, List<Integer> conditions) {
        Matrix data = new Matrix(this.network, genes.size(), conditions.size());
        for (int i = 0; i < genes.size(); ++i) {
            for (int j = 0; j < conditions.size(); ++j) {
                data.setValue(i, j, this.matrix.getValue(genes.get(i), conditions.get(j)));
            }
        }
        double asr = 0.0;
        double asr_g = 0.0;
        double asr_c = 0.0;
        for (int i = 0; i < genes.size(); ++i) {
            for (int j = i + 1; j < genes.size(); ++j) {
                asr_g += this.getSpearmansRho(data, i, j).doubleValue();
            }
        }
        asr = 2.0 * (asr_g /= (double)(genes.size() * (genes.size() - 1)));
        return asr;
    }

    private Double getSpearmansRho(Matrix data, int i, int j) {
        Double rho = 0.0;
        double[] rank1 = data.getRank(i);
        double[] rank2 = data.getRank(j);
        int n = rank1.length;
        double sum_d2 = 0.0;
        int k = 0;
        while (i < n) {
            sum_d2 += Math.pow(rank1[k] - rank2[k], 2.0);
            ++i;
        }
        rho = 1.0 - 6.0 * sum_d2 / (double)(n * (n * n - 1));
        return rho;
    }

    private void generateCSI() {
        this.csi = new ArrayList<Map<Integer, Map<Integer, Double>>>(this.nelements);
        for (int i = 0; i < this.nelements - 2; ++i) {
            HashMap jmap = new HashMap();
            for (int j = i + 1; j < this.nelements - 1; ++j) {
                HashMap<Integer, Double> kmap = new HashMap<Integer, Double>();
                for (int k = j + 1; k < this.nelements; ++k) {
                    double sum = 0.0;
                    for (int l = 0; l < this.nattrs - 1; ++l) {
                        if (this.discrete_matrix[i][l] != this.discrete_matrix[j][l] || this.discrete_matrix[i][l] != this.discrete_matrix[k][l]) continue;
                        sum += 1.0;
                    }
                    kmap.put(k, sum /= (double)this.maxCSL[i]);
                }
                jmap.put(j, kmap);
            }
            this.csi.add(i, jmap);
        }
    }

    private void generateCSL() {
        this.csl = new ArrayList<Map<Integer, List<Boolean>>>(this.nelements);
        this.maxCSL = new int[this.nelements];
        for (int i = 0; i < this.nelements; ++i) {
            HashMap simlistMap = new HashMap();
            this.maxCSL[i] = -1;
            for (int j = i + 1; j < this.nelements; ++j) {
                ArrayList<Boolean> simlist = new ArrayList<Boolean>(this.nattrs - 1);
                int trueCount = 0;
                for (int k = 0; k < this.nattrs - 1; ++k) {
                    if (this.discrete_matrix[i][k] == this.discrete_matrix[j][k]) {
                        simlist.add(true);
                        ++trueCount;
                        continue;
                    }
                    simlist.add(false);
                }
                if (trueCount > this.maxCSL[i]) {
                    this.maxCSL[i] = trueCount;
                }
                simlistMap.put(j, simlist);
            }
            this.csl.add(simlistMap);
        }
    }

    private List<Map<Integer, Integer>> generateDag() {
        ArrayList<Map<Integer, Integer>> graph = new ArrayList<Map<Integer, Integer>>();
        for (int i = 0; i < this.nelements; ++i) {
            HashMap<Integer, Integer> edges = new HashMap<Integer, Integer>();
            for (int j = i + 1; j < this.nelements; ++j) {
                edges.put(j, Collections.frequency((Collection)this.csl.get(i).get(j), true));
            }
            graph.add(edges);
        }
        return graph;
    }

    private int[][] getDiscreteMatrix() {
        int[][] M = new int[this.nelements][this.nattrs - 1];
        for (int i = 0; i < this.nelements; ++i) {
            for (int j = 0; j < this.nattrs - 1; ++j) {
                Double next;
                Double current = this.matrix.getValue(i, j);
                if (current == null) {
                    current = 0.0;
                }
                if ((next = this.matrix.getValue(i, j + 1)) == null) {
                    next = 0.0;
                }
                M[i][j] = current > next ? -1 : (current < next ? 1 : 0);
            }
        }
        return M;
    }

    private List<Integer> getCommonConditions(int i, int k) {
        HashSet<Integer> newConds = new HashSet<Integer>();
        for (int l = 0; l < this.nattrs - 1; ++l) {
            if (this.discrete_matrix[i][l] != this.discrete_matrix[k][l]) continue;
            newConds.add(l);
            newConds.add(l + 1);
        }
        return new ArrayList<Integer>(newConds);
    }

    public List<Integer> union(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> unionList = new ArrayList<Integer>(a);
        unionList.removeAll(b);
        unionList.addAll(b);
        Collections.sort(unionList);
        return unionList;
    }

    public List<Integer> intersection(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> intersectionList = new ArrayList<Integer>(a);
        intersectionList.retainAll(b);
        return intersectionList;
    }

    public Map<Integer, List<Long>> getClusterNodes() {
        return this.clusterNodes;
    }

    public Map<Integer, List<String>> getClusterAttrs() {
        return this.clusterAttrs;
    }
}

