/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.ChengChurch;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AttributeList;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.BoundedDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChengChurchContext {
    CyNetwork network;
    @Tunable(description="Number of Biclusters", gravity=1.0)
    public int nClusters = 1;
    @Tunable(description="Maximum Mean Squared Residue allowed for a Bicluster", gravity=2.0)
    public double delta = 1.0;
    @Tunable(description="Threshold for Multiple Node Deletion", gravity=3.0)
    public BoundedDouble alpha = new BoundedDouble(Double.valueOf(1.0), Double.valueOf(1.1), Double.valueOf(Double.MAX_VALUE), true, true);
    @ContainsTunables
    public AttributeList attributeList = null;
    public boolean selectedOnly = false;
    @Tunable(description="Cluster attributes as well as nodes", groups={"ChengChurch Parameters"}, gravity=101.0)
    public boolean clusterAttributes = false;
    @Tunable(description="Create groups from clusters", groups={"Visualization Options"}, gravity=150.0)
    public boolean createGroups = false;
    @Tunable(description="Show HeatMap when complete", groups={"Visualization Options"}, gravity=151.0)
    public boolean showUI = false;

    @Tunable(description="Use only selected nodes/edges for cluster", groups={"ChengChurch Parameters"}, gravity=100.0)
    public boolean getselectedOnly() {
        return this.selectedOnly;
    }

    public void setselectedOnly(boolean sel) {
        this.selectedOnly = sel;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.attributeList == null) {
            this.attributeList = new AttributeList(network);
        } else {
            this.attributeList.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("nodeAttributeList=" + this.attributeList.getNodeAttributeList().toString());
        params.add("edgeAttribute=" + this.attributeList.getEdgeAttribute());
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("clusterAttributes=" + this.clusterAttributes);
        params.add("createGroups=" + this.createGroups);
        return params;
    }
}

